/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adfmf.amx.skins.ADFMobileSkinsNode;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.editor.ADFMobileConfigNode;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.adfmf.framework.dt.ide.FeatureArchive;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resourcebundle.ResourceBundleOptions;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.jdeveloper.library.ApplicationLibraryList;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class McAppUtils {
    private static final String[] _IMAGE_EXT_ARRAY = new String[]{".png", ".jpg", ".jpeg", ".gif"};
    private static final String _NAME = "name";
    private static final String _VERSION = "version";
    private static final String _URL_SCHEME = "urlScheme";
    private static final String _ID = "id";
    private static final String _BASENAME = "basename";
    private static final Logger _LOGGER = Logger.getLogger(McAppUtils.class.getName());

    public static URL getAppRootURL(Workspace workspace) {
        URL oWorkspaceURL;
        URL oAppRootURL = null;
        if (null == workspace) {
            workspace = Ide.getActiveWorkspace();
        }
        if (null != workspace && null != (oWorkspaceURL = workspace.getURL())) {
            oAppRootURL = URLFileSystem.getParent((URL)oWorkspaceURL);
        }
        return oAppRootURL;
    }

    public static URL getProjectRootURL(Project project) {
        if (project != null) {
            URL projectFileUrl = project.getURL();
            return URLFileSystem.getParent((URL)projectFileUrl);
        }
        return null;
    }

    public static URL getHtmlRootDirectory(Project project) {
        if (project != null) {
            return J2eeSettings.getInstance((Project)project).getHtmlRootDirectory();
        }
        return null;
    }

    public static void setApplicationDefaultBundleTypeToXliff(Workspace workspace) {
        ResourceBundleOptions appBundleOptions = ResourceBundleOptions.getInstance((PropertyStorage)workspace);
        appBundleOptions.setDefaultBundleTypeId("xliffResourceBundleId");
    }

    public static String getPageRelativePath(Project project, URL fileUrl) {
        URL rootUrl = McAppUtils.getProjectRootURL(project);
        URL publicHtmlUrl = URLFactory.newDirURL((URL)rootUrl, (String)"public_html");
        String relativePath = URLFileSystem.toRelativeSpec((URL)fileUrl, (URL)publicHtmlUrl);
        if (!relativePath.startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        return relativePath;
    }

    public static URL getUIProjectClassesDirectoryURL(Workspace oWorkspace) {
        Project oFirstUIProject;
        URL oUIProjectClassesDirectoryURL = null;
        if (null != oWorkspace && null != (oFirstUIProject = McTechnologyUtils.findFirstUIProjectInWorkspace(oWorkspace))) {
            oUIProjectClassesDirectoryURL = JavaProject.getInstance((Project)oFirstUIProject).getOutputDirectory();
        }
        return oUIProjectClassesDirectoryURL;
    }

    public static String getUIProjectClassesDirectoryPath(Workspace oWorkspace) {
        URL oUIProjectClassesDirectoryURL = McAppUtils.getUIProjectClassesDirectoryURL(oWorkspace);
        if (null != oUIProjectClassesDirectoryURL && URLFileSystem.exists((URL)oUIProjectClassesDirectoryURL)) {
            return oUIProjectClassesDirectoryURL.getPath();
        }
        return null;
    }

    public static URL getApplicationSrcMetaInfDirURL(Workspace oWorkspace) {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)oWorkspace);
        return appContent.getApplicationMetaInfURL();
    }

    public static URL getApplicationXmlURL(Workspace oWorkspace) {
        return URLFactory.newURL((URL)McAppUtils.getApplicationAdfMetaInfUrl(oWorkspace), (String)"adfmf-application.xml");
    }

    public static URL getConnectionsXmlURL(Workspace oWorkspace) {
        URL url = URLFactory.newURL((URL)McAppUtils.getApplicationAdfMetaInfUrl(oWorkspace), (String)"connections.xml");
        if (URLFileSystem.exists((URL)url)) {
            return url;
        }
        return null;
    }

    public static URL getApplicationAdfMetaInfUrl(Workspace oWorkspace) {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)oWorkspace);
        return appContent.getADFMetaInfURL();
    }

    public static URL getApplicationAdfFolderUrl(Workspace workspace) throws FileNotFoundException {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)workspace);
        URL adfFolderUrl = appContent.getADFSourceURL();
        if (null == adfFolderUrl) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00089");
            throw new IllegalStateException(msg);
        }
        boolean adfDirectoryExists = URLFileSystem.exists((URL)adfFolderUrl);
        boolean isDirectory = URLFileSystem.isDirectory((URL)adfFolderUrl);
        if (!adfDirectoryExists || !isDirectory) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-00090", URLFileSystem.getPlatformPathName((URL)adfFolderUrl));
            throw new FileNotFoundException(msg);
        }
        return adfFolderUrl;
    }

    public static String getAppPackagePrefix(Workspace oWorkspace) {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)oWorkspace);
        return appContent.getAppPackagePrefix();
    }

    public static URL getProjectFeatureXmlUrl(Project project) {
        if (project != null) {
            URL projectFileUrl = project.getURL();
            URL projectDirectoryUrl = URLFileSystem.getParent((URL)projectFileUrl);
            URL defaultDirectory = URLFactory.newURL((URL)projectDirectoryUrl, (String)"src/META-INF");
            return URLFactory.newURL((URL)defaultDirectory, (String)ADFMobileConstants.FEATURE_XML_FILENAME);
        }
        return null;
    }

    public static URL getProjectPublicHtmlDir(Project project) {
        if (project != null) {
            URL projectFileUrl = project.getURL();
            URL projectDirectoryUrl = URLFileSystem.getParent((URL)projectFileUrl);
            return URLFactory.newDirURL((URL)projectDirectoryUrl, (String)"public_html");
        }
        return null;
    }

    public static boolean canFileBeInProjectPublicHtmlDir(Project project, String value) {
        URL publicHtmlDir = McAppUtils.getProjectPublicHtmlDir(project);
        String htmlPath = URLFileSystem.getPath((URL)publicHtmlDir);
        URL fileUrl = URLFactory.newURL((URL)publicHtmlDir, (String)value);
        URL canonFileUrl = URLFileSystem.canonicalize((URL)fileUrl);
        String filePath = URLFileSystem.getPath((URL)canonFileUrl);
        return filePath != null && filePath.startsWith(htmlPath);
    }

    public static URL getFarPublicHtmlDir(URL url) {
        URL farUrl = McAppUtils.getFarUrl(url);
        if (farUrl == null) {
            return null;
        }
        return URLFactory.newJarURL((URL)farUrl, (String)"public_html");
    }

    public static URL getSourceImageDir(Workspace oWorkspace) {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)oWorkspace);
        return URLFactory.newURL((URL)appContent.getSourceURL(), (String)"images");
    }

    public static URL getWorkspaceDir(Workspace oWorkspace) {
        return URLFileSystem.getParent((URL)oWorkspace.getURL());
    }

    public static URL getResourcesDir(Workspace oWorkspace) {
        return URLFactory.newDirURL((URL)McAppUtils.getWorkspaceDir(oWorkspace), (String)"resources");
    }

    public static URL getCacertsFileUrl(Workspace oWorkspace) {
        assert (null != oWorkspace);
        URL securityDirUrl = URLFactory.newDirURL((URL)McAppUtils.getResourcesDir(oWorkspace), (String)"security");
        return URLFactory.newURL((URL)securityDirUrl, (String)"cacerts");
    }

    public static URL getSourceDir(Workspace oWorkspace) {
        oracle.jdeveloper.model.ApplicationContent appContent = oracle.jdeveloper.model.ApplicationContent.getInstance((Workspace)oWorkspace);
        return appContent.getSourceURL();
    }

    public static String getWorkspaceName(Workspace oWorkspace) {
        return URLFileSystem.getName((URL)oWorkspace.getURL());
    }

    public static String getApplicationName(Workspace workspace) {
        return McAppUtils._getApplicationAttribute(workspace, _NAME);
    }

    public static String getApplicationVersion(Workspace workspace) {
        return McAppUtils._getApplicationAttribute(workspace, _VERSION);
    }

    public static String getApplicationUrlScheme(Workspace workspace) {
        return McAppUtils._getApplicationAttribute(workspace, _URL_SCHEME);
    }

    public static String getApplicationId(Workspace workspace) {
        return McAppUtils._getApplicationAttribute(workspace, _ID);
    }

    public static String getApplicationLoadBundleBaseName(Workspace workspace) {
        String applicationBaseName = null;
        try {
            if (null == workspace) {
                workspace = Ide.getActiveWorkspace();
            }
            applicationBaseName = McAppUtils.getXmlElementAttribute(McAppUtils.getApplicationXmlDOM(workspace), "loadBundle", _BASENAME);
        }
        catch (Exception e) {
            applicationBaseName = "";
        }
        return applicationBaseName;
    }

    public static String getFeatureLoadBundleBaseName(URL farUrl, Logger logger) throws IOException {
        Document doc = McAppUtils.getFeatureXmlDom(farUrl, logger);
        return McAppUtils.getXmlElementAttribute(doc, "loadBundle", _BASENAME);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getFeatureXmlDom(URL farUrl, Logger logger) throws IOException {
        InputStream farFeatureXmlStream = null;
        Document farDoc = null;
        if (!URLFileSystem.exists((URL)farUrl)) return farDoc;
        try {
            URL featureXmlUrl = URLFactory.newURL((URL)farUrl, (String)ADFMobileConstants.FEATURE_XML_FAR_PATH);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            farFeatureXmlStream = featureXmlUrl.openStream();
            farDoc = documentBuilder.parse(farFeatureXmlStream);
        }
        catch (SAXException e) {
            try {
                throw new IOException(e);
                catch (ParserConfigurationException e2) {
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(farFeatureXmlStream, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(farFeatureXmlStream, logger);
        return farDoc;
    }

    public static Document getApplicationXmlDOM() throws ParserConfigurationException, IOException, SAXException {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        return McAppUtils.getApplicationXmlDOM(activeWorkspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getApplicationXmlDOM(Workspace workspace) throws ParserConfigurationException, IOException, SAXException {
        Document applicationXmlDOM = null;
        InputStream adfmfApplicationStream = null;
        try {
            URL applicationXmlUrl = McAppUtils.getApplicationXmlURL(workspace);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            adfmfApplicationStream = applicationXmlUrl.openStream();
            Document document = applicationXmlDOM = documentBuilder.parse(adfmfApplicationStream);
            return document;
        }
        finally {
            if (null != adfmfApplicationStream) {
                adfmfApplicationStream.close();
            }
        }
    }

    public static boolean isFeatureArchive(URL url) {
        if (url == null) {
            return false;
        }
        String ext = URLFileSystem.getSuffix((URL)url);
        if (!".jar".equalsIgnoreCase(ext)) {
            return false;
        }
        URL featureXmlUrl = URLFactory.newJarURL((URL)url, (String)ADFMobileConstants.FEATURE_XML_FAR_PATH);
        return URLFileSystem.canRead((URL)featureXmlUrl);
    }

    public static List<URL> getFeatureArchiveURLs(Workspace workspace) {
        return Collections.unmodifiableList(McAppUtils.getFarURLs(workspace));
    }

    public static boolean isFarFileUrl(URL url) {
        URL farUrl = McAppUtils.getFarUrl(url);
        if (farUrl == null) {
            return false;
        }
        URL featureXmlUrl = URLFactory.newJarURL((URL)farUrl, (String)ADFMobileConstants.FEATURE_XML_FAR_PATH);
        return URLFileSystem.canRead((URL)featureXmlUrl);
    }

    public static URL getFarUrl(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URLConnection urlConn = url.openConnection();
            if (urlConn instanceof JarURLConnection) {
                JarURLConnection jarConn = (JarURLConnection)urlConn;
                return jarConn.getJarFileURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<URL> getApplicationLibraryJarUrls(Workspace workspace) {
        ArrayList<URL> includedLibraryList = new ArrayList<URL>();
        ApplicationLibraries appLibs = ApplicationLibraries.getInstance((Workspace)workspace);
        List appLibraryList = appLibs.getLibraryReferences();
        for (JLibrary jLib : appLibraryList) {
            URL[] jarUrls;
            URLPath path = jLib.getClassPath();
            for (URL jarUrl : jarUrls = path.getEntries()) {
                URL fileUrl = JarUtil.getJarFileURL((URL)jarUrl);
                includedLibraryList.add(fileUrl);
            }
        }
        return includedLibraryList;
    }

    public static List<Project> findProjectsWithFeatures(Workspace workspace) {
        ArrayList<Project> projects = new ArrayList<Project>();
        Collection allProjects = workspace.projects();
        for (Project project : allProjects) {
            if (!URLFileSystem.exists((URL)McAppUtils.getProjectFeatureXmlUrl(project))) continue;
            projects.add(project);
        }
        return Collections.unmodifiableList(projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFeatureIdList(Project project) {
        ArrayList<String> featureIdList = new ArrayList<String>();
        URL featureXmlUrl = McAppUtils.getProjectFeatureXmlUrl(project);
        Node node = null;
        if (URLFileSystem.exists((URL)featureXmlUrl)) {
            try {
                node = NodeFactory.findOrCreate((URL)featureXmlUrl);
            }
            catch (Exception e) {
                node = null;
            }
        }
        if (node != null) {
            Context ideContext = Context.newIdeContext((Node)node);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
            XmlModel model = xmlContext.getModel();
            model.acquireReadLock();
            try {
                Element rootNode = model.getDocument().getDocumentElement();
                NodeList childNodes = rootNode.getChildNodes();
                if (childNodes != null) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        String id;
                        org.w3c.dom.Node child = childNodes.item(i);
                        if (!(child instanceof Element) || !"feature".equals(child.getLocalName()) || (id = ((Element)child).getAttributeNS(null, _ID)) == null || id.trim().length() <= 0) continue;
                        featureIdList.add(id);
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return Collections.unmodifiableList(featureIdList);
    }

    public static FeatureXmlSourceNode findOrCreateFeatureXml(Project project) {
        try {
            URL fileUrl = McAppUtils.getProjectFeatureXmlUrl(project);
            FeatureXmlSourceNode node = (FeatureXmlSourceNode)NodeFactory.findOrCreate(FeatureXmlSourceNode.class, (URL)fileUrl);
            if (node != null && node.isNew()) {
                Context context = Context.newIdeContext((Node)node);
                context.setProject(project);
                JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
                XmlModel model = xmlContext.getModel();
                model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, "UTF-8", null));
                new FixedNameTransactionTask("Initialize file contents"){

                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        Document doc = model.getDocument();
                        Element root = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("features"));
                        DomUtils.addXmlns((Element)root, (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
                        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:adfmf", "http://xmlns.oracle.com/adf/mf");
                        doc.appendChild(root);
                    }
                }.run((AbstractModel)model);
                try {
                    node.save();
                }
                catch (Exception e) {
                    _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00012", e));
                }
                project.add((Node)node, PathsConfiguration.JAVA_CONTENT_SET_KEY);
            }
            return node;
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00010", e));
            return null;
        }
    }

    public static FrameworkXmlSourceNode findOrCreateApplicationXml(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        try {
            URL applicationXmlURL = McAppUtils.getApplicationXmlURL(workspace);
            final String appName = McAppUtils.getWorkspaceName(workspace);
            FrameworkXmlSourceNode node = (FrameworkXmlSourceNode)NodeFactory.findOrCreate(FrameworkXmlSourceNode.class, (URL)applicationXmlURL);
            if (node.isNew()) {
                Context context = Context.newIdeContext((Node)node);
                JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
                XmlModel model = xmlContext.getModel();
                model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, "UTF-8", null));
                new FixedNameTransactionTask("Initialize file contents"){

                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        String APPID_PREFIX = "com.company.";
                        Document doc = model.getDocument();
                        Element root = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("application"));
                        DomUtils.addXmlns((Element)root, (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
                        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:adfmf", "http://xmlns.oracle.com/adf/mf");
                        root.setAttributeNS(null, McAppUtils._VERSION, "1.0");
                        root.setAttributeNS(null, McAppUtils._NAME, appName);
                        String appNameNoSpaces = appName.replaceAll("\\s", "");
                        root.setAttributeNS(null, McAppUtils._ID, "com.company." + appNameNoSpaces);
                        doc.appendChild(root);
                    }
                }.run((AbstractModel)model);
                try {
                    node.save();
                }
                catch (Exception e) {
                    _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00501", e));
                }
                ApplicationContent appContent = ApplicationContent.getInstance((PropertyStorage)context.getWorkspace());
                appContent.add((Node)node, oracle.jdeveloper.model.ApplicationContent.APPLICATION_SRC_CONTENT_SET_KEY);
            }
            return node;
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00500", e));
            return null;
        }
    }

    public static void updateAppControllerFolder(FrameworkXmlSourceNode appXmlNode, final Project appControllerProject) {
        if (appXmlNode != null) {
            Context context = Context.newIdeContext((Node)appXmlNode);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
            XmlModel model = xmlContext.getModel();
            new FixedNameTransactionTask("update appControllerFolder attribute"){

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    URL appControllerFolderUrl;
                    Document doc = model.getDocument();
                    Element root = (Element)doc.getFirstChild();
                    if (root != null && (appControllerFolderUrl = McAppUtils.getProjectRootURL(appControllerProject)) != null) {
                        String appControllerFolderName = URLFileSystem.getFileName((URL)appControllerFolderUrl);
                        root.setAttributeNS(null, "appControllerFolder", appControllerFolderName);
                    }
                }
            }.run((AbstractModel)model);
            try {
                appXmlNode.save();
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00501", e));
            }
        }
    }

    public static ADFMobileConfigNode findOrCreateMobileConfigXml(Workspace workspace) {
        try {
            URL skinConfigURL = McAppUtils.getMobileConfigURL(workspace);
            ADFMobileConfigNode node = (ADFMobileConfigNode)NodeFactory.findOrCreate(ADFMobileConfigNode.class, (URL)skinConfigURL);
            if (node.isNew()) {
                Context context = Context.newIdeContext((Node)node);
                JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
                XmlModel model = xmlContext.getModel();
                model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, "UTF-8", null));
                new FixedNameTransactionTask("Initialize file contents"){

                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        Document doc = model.getDocument();
                        Element root = doc.createElementNS("http://xmlns.oracle.com/adf/mf/config", "adfmf-config");
                        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adf/mf/config");
                        doc.appendChild(root);
                        Element skinId = doc.createElementNS("http://xmlns.oracle.com/adf/mf/config", "skin-family");
                        skinId.setTextContent("mobileFusionFx");
                        root.appendChild(skinId);
                        Element genericType = doc.createElementNS("http://xmlns.oracle.com/adf/mf/config", "generic-type");
                        Element conversion = doc.createElementNS("http://xmlns.oracle.com/adf/mf/config", "conversion");
                        Element validated = doc.createElementNS("http://xmlns.oracle.com/adf/mf/config", "validated");
                        validated.setTextContent("false");
                        conversion.appendChild(validated);
                        genericType.appendChild(conversion);
                        root.appendChild(genericType);
                    }
                }.run((AbstractModel)model);
                try {
                    node.save();
                }
                catch (Exception e) {
                    _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00501", "adfmf-config.xml", e));
                }
                ApplicationContent appContent = ApplicationContent.getInstance((PropertyStorage)context.getWorkspace());
                appContent.add((Node)node, oracle.jdeveloper.model.ApplicationContent.APPLICATION_SRC_CONTENT_SET_KEY);
            }
            return node;
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00500", "adfmf-config.xml", e));
            return null;
        }
    }

    public static ADFMobileSkinsNode findOrCreateSkinsXml(Project project) {
        try {
            URL skinsURL = McAppUtils.getSkinsURL(project);
            ADFMobileSkinsNode node = (ADFMobileSkinsNode)NodeFactory.findOrCreate(ADFMobileSkinsNode.class, (URL)skinsURL);
            if (node.isNew()) {
                Context context = Context.newIdeContext((Node)node);
                JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
                XmlModel model = xmlContext.getModel();
                model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, "UTF-8", null));
                new FixedNameTransactionTask("Initialize file contents"){

                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        Document doc = model.getDocument();
                        Element root = doc.createElementNS("http://xmlns.oracle.com/adf/mf/skin", "adfmf-skins");
                        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adf/mf/skin");
                        doc.appendChild(root);
                    }
                }.run((AbstractModel)model);
                try {
                    node.save();
                }
                catch (Exception e) {
                    _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00501", "adfmf-skins.xml", e));
                }
                ApplicationContent appContent = ApplicationContent.getInstance((PropertyStorage)context.getWorkspace());
                appContent.add((Node)node, oracle.jdeveloper.model.ApplicationContent.APPLICATION_SRC_CONTENT_SET_KEY);
            }
            return node;
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00500", "adfmf-skins.xml", e));
            return null;
        }
    }

    public static void addFeatureReference(Workspace workspace, final String featureId) {
        URL appXmlUrl = McAppUtils.getApplicationXmlURL(workspace);
        if (URLFileSystem.exists((URL)appXmlUrl)) {
            Node node = null;
            try {
                node = NodeFactory.findOrCreate(FrameworkXmlSourceNode.class, (URL)appXmlUrl);
                if (node != null) {
                    Context ideContext = Context.newIdeContext((Node)node);
                    JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
                    XmlModel model = xmlContext.getModel();
                    new FixedNameTransactionTask("Add feature reference id"){

                        protected void performTask(AbstractModel model) throws XmlCommitException {
                            Document doc = model.getDocument();
                            Element root = doc.getDocumentElement();
                            NodeList featureRefs = root.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", "featureReference");
                            int count = featureRefs != null ? featureRefs.getLength() : 0;
                            for (int i = 0; i < count; ++i) {
                                Element element = (Element)featureRefs.item(i);
                                String id = element.getAttributeNS(null, McAppUtils._ID);
                                if (id == null || !id.equals(featureId)) continue;
                                _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20505", featureId));
                                return;
                            }
                            Element featureRef = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("featureReference"));
                            featureRef.setAttributeNS(null, McAppUtils._ID, featureId);
                            model.insertNode((org.w3c.dom.Node)featureRef, DomPositionFactory.inside((org.w3c.dom.Node)root), false);
                            _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20502", featureId));
                        }
                    }.run((AbstractModel)model);
                }
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00504", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFeatureCredential(Workspace workspace, String featureId) {
        Element feature;
        Document featureXmlDOM;
        List<Project> projects = McAppUtils.findProjectsWithFeatures(workspace);
        for (Project project : projects) {
            URL featureXmlUrl = McAppUtils.getProjectFeatureXmlUrl(project);
            Node node = null;
            if (URLFileSystem.exists((URL)featureXmlUrl)) {
                try {
                    node = NodeFactory.findOrCreate((URL)featureXmlUrl);
                }
                catch (Exception e) {
                    node = null;
                }
            }
            if (node == null) continue;
            Context ideContext = Context.newIdeContext((Node)node);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
            XmlModel model = xmlContext.getModel();
            model.acquireReadLock();
            try {
                featureXmlDOM = model.getDocument();
                feature = McAppUtils.findFeatureinFeatureDOM(featureId, featureXmlDOM);
                if (feature == null) continue;
                String string = feature.getAttributeNS(null, "credentials");
                return string;
            }
            finally {
                model.releaseReadLock();
            }
        }
        InputStream is = null;
        List<URL> farUrls = McAppUtils.getFeatureArchiveURLs(workspace);
        for (URL farUrl : farUrls) {
            FeatureArchive far = new FeatureArchive(farUrl);
            URL farfeatureXmlUrl = far.getJarFeatureXmlUrl();
            try {
                is = farfeatureXmlUrl.openStream();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                featureXmlDOM = documentBuilder.parse(is);
                feature = McAppUtils.findFeatureinFeatureDOM(featureId, featureXmlDOM);
                if (feature == null) continue;
                String string = feature.getAttributeNS(null, "credentials");
                return string;
            }
            catch (IOException e) {}
            continue;
            catch (ParserConfigurationException e) {}
            continue;
            catch (SAXException e) {}
            continue;
            finally {
                if (null == is) continue;
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    public static Element findFeatureinFeatureDOM(String featureId, Document featureXmlDOM) {
        NodeList features = featureXmlDOM.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", "feature");
        int count = features != null ? features.getLength() : 0;
        for (int i = 0; i < count; ++i) {
            Element element = (Element)features.item(i);
            String id = element.getAttributeNS(null, _ID);
            if (id == null || !id.equals(featureId)) continue;
            return element;
        }
        return null;
    }

    public static URL getURLForRelativePath(XmlContext xmlContext, String value) {
        String path = "../../public_html/" + value;
        return xmlContext.getURLForRelativePath(path);
    }

    public static String getRelativePathForURL(XmlContext xmlContext, URL url) {
        String path = xmlContext.getRelativePathForURL(url);
        if (path.startsWith("../../public_html/")) {
            return path.substring("../../public_html/".length());
        }
        return null;
    }

    public static String getQualifiedName(String element) {
        return "adfmf:" + element;
    }

    public static boolean validateXml(Context ideContext, XMLSourceNode xmlSrcNode, final List<Issue> errorList) {
        XmlModel model;
        if (null == ideContext || null == xmlSrcNode || null == errorList) {
            throw new IllegalArgumentException();
        }
        final ArrayList xmlErrorList = new ArrayList();
        ideContext.setNode((Node)xmlSrcNode);
        final JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)ideContext);
        Boolean isValid = true;
        if (null != xmlContext && null != (model = xmlContext.getModel())) {
            isValid = (Boolean)new ReadOnlyTask<Boolean>(){

                protected Boolean runImpl(AbstractModel model) {
                    IssueList issueList = xmlContext.getIssueList();
                    if (null != issueList) {
                        for (int i = 0; i < issueList.size(); ++i) {
                            Issue currIssue = issueList.getIssueAt(i);
                            Severity severity = currIssue.getSeverity();
                            if (severity != Severity.ERROR && severity != Severity.INCOMPLETE) continue;
                            xmlErrorList.add(issueList.getIssueAt(i));
                        }
                    }
                    if (!xmlErrorList.isEmpty()) {
                        errorList.addAll(xmlErrorList);
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            }.run((AbstractModel)model);
        }
        return isValid;
    }

    public static boolean isMobileApp(Workspace workspace) {
        URL url = McAppUtils.getApplicationXmlURL(workspace);
        if (url != null) {
            return URLFileSystem.exists((URL)url);
        }
        return false;
    }

    public static Project findApplicationControllerProject(Workspace workspace, Logger logger, String applicationControllerFolderName) {
        if (workspace == null) {
            return null;
        }
        Project applicationControllerProject = null;
        int projectCountInAppControllerFolder = 0;
        for (Project currProject : workspace.projects()) {
            URL currProjectUrl = currProject.getURL();
            String currProjectName = URLFileSystem.getFileName((URL)currProjectUrl);
            String currProjectFolderName = URLFileSystem.getFileName((URL)URLFileSystem.getParent((URL)currProjectUrl));
            if (!applicationControllerFolderName.equals(currProjectFolderName)) continue;
            ++projectCountInAppControllerFolder;
            if (!applicationControllerFolderName.equals(currProjectName) && null != applicationControllerProject) continue;
            applicationControllerProject = currProject;
        }
        if (null != logger) {
            if (projectCountInAppControllerFolder > 1) {
                logger.warning(MobileResourceUtils.getMsg("ADF-MBL-12001"));
            }
            if (null == applicationControllerProject) {
                logger.warning(MobileResourceUtils.getMsg("ADF-MBL-12002", applicationControllerFolderName));
            }
        }
        return applicationControllerProject;
    }

    public static Project getApplicationControllerProject(Workspace workspace, Logger logger) {
        return McAppUtils.findApplicationControllerProject(workspace, logger, McAppUtils.getApplicationControllerFolderName(workspace));
    }

    public static String getApplicationControllerFolderName(Workspace workspace) {
        String appControllerFolder = null;
        try {
            appControllerFolder = McAppUtils.getXmlElementAttribute(McAppUtils.getApplicationXmlDOM(workspace), "application", "appControllerFolder");
            if (appControllerFolder.isEmpty()) {
                appControllerFolder = "ApplicationController";
            }
        }
        catch (Exception e) {
            appControllerFolder = "ApplicationController";
        }
        return appControllerFolder;
    }

    public static URL getMobileConfigURL(Workspace oWorkspace) {
        if (oWorkspace != null) {
            return URLFactory.newURL((URL)McAppUtils.getApplicationAdfMetaInfUrl(oWorkspace), (String)"adfmf-config.xml");
        }
        return null;
    }

    public static URL getSkinsURL(Project project) {
        if (project != null) {
            URL projectFileUrl = project.getURL();
            URL projectDirectoryUrl = URLFileSystem.getParent((URL)projectFileUrl);
            URL defaultDirectory = URLFactory.newURL((URL)projectDirectoryUrl, (String)"src/META-INF");
            return URLFactory.newURL((URL)defaultDirectory, (String)"adfmf-skins.xml");
        }
        return null;
    }

    public static URL getDefaultSkinsFolderUrl() {
        URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
        return URLFactory.newDirURL((URL)extensionDirectoryUrl, (String)"skins");
    }

    public static boolean isAmxFile(String filename) {
        return filename != null && filename.endsWith(".amx");
    }

    public static boolean isHtmlFile(String filename) {
        return filename != null && (filename.endsWith(".html") || filename.endsWith(".htm"));
    }

    public static boolean isImageFile(String filename) {
        if (filename != null) {
            for (String ext : _IMAGE_EXT_ARRAY) {
                if (!filename.endsWith(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getImageFileExtensions() {
        return Arrays.copyOf(_IMAGE_EXT_ARRAY, _IMAGE_EXT_ARRAY.length);
    }

    public static boolean isJarAdded(Workspace workspace, URL testjarUrl) {
        ApplicationLibraries appLibs = ApplicationLibraries.getInstance((Workspace)workspace);
        List appLibraryList = appLibs.getLibraryReferences();
        for (JLibrary jLib : appLibraryList) {
            URL[] jarUrls;
            URLPath path = jLib.getClassPath();
            for (URL jarUrl : jarUrls = path.getEntries()) {
                if (!URLFileSystem.equals((URL)jarUrl, (URL)testjarUrl)) continue;
                _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20504", URLFileSystem.getFileName((URL)jarUrl)));
                return true;
            }
        }
        return false;
    }

    public static void addJar(Workspace workspace, URL jarUrl) {
        ApplicationLibraries appLib = ApplicationLibraries.getInstance((Workspace)workspace);
        ApplicationLibraryList appLibDefList = appLib.getLibraryDefinitions();
        List jLibList = appLibDefList.getLibraryList();
        for (Object jLib : jLibList) {
            if (!(jLib instanceof JLibrary) || !((JLibrary)jLib).getClassPath().equals((Object)new URLPath(jarUrl))) continue;
            appLib.addLibraryReference(((JLibrary)jLib).getID());
            return;
        }
        String filename = URLFileSystem.getFileName((URL)jarUrl);
        JLibrary lib = appLibDefList.addLibrary(filename);
        lib.setClassPath(new URLPath(jarUrl));
        lib.setDeployedByDefault(Boolean.valueOf(true));
        appLib.addLibraryReference(lib.getID());
        _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20500", URLFileSystem.getFileName((URL)jarUrl)));
    }

    public static void removeJar(Workspace workspace, URL removeJarUrl) {
        ApplicationLibraries appLibs = ApplicationLibraries.getInstance((Workspace)workspace);
        List appLibraryList = appLibs.getLibraryReferences();
        for (JLibrary jLib : appLibraryList) {
            URL[] jarUrls;
            URLPath path = jLib.getClassPath();
            for (URL jarUrl : jarUrls = path.getEntries()) {
                if (!URLFileSystem.equals((URL)jarUrl, (URL)removeJarUrl)) continue;
                appLibraryList.remove(jLib);
                appLibs.setLibraryReferences(appLibraryList);
                _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20501", URLFileSystem.getFileName((URL)jarUrl)));
                return;
            }
        }
    }

    public static void removeFeatureReference(Workspace workspace, final String featureId) {
        URL appXmlUrl = McAppUtils.getApplicationXmlURL(workspace);
        if (URLFileSystem.exists((URL)appXmlUrl)) {
            Node node = null;
            try {
                node = NodeFactory.findOrCreate(FrameworkXmlSourceNode.class, (URL)appXmlUrl);
                if (node != null) {
                    Context ideContext = Context.newIdeContext((Node)node);
                    JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
                    XmlModel model = xmlContext.getModel();
                    new FixedNameTransactionTask("Remove feature reference by id"){

                        protected void performTask(AbstractModel model) throws XmlCommitException {
                            Document doc = model.getDocument();
                            Element root = doc.getDocumentElement();
                            NodeList childNodes = root.getChildNodes();
                            if (childNodes != null) {
                                for (int i = 0; i < childNodes.getLength(); ++i) {
                                    String id;
                                    org.w3c.dom.Node child = childNodes.item(i);
                                    if (!(child instanceof Element) || !"featureReference".equals(child.getLocalName()) || !featureId.equals(id = ((Element)child).getAttributeNS(null, McAppUtils._ID))) continue;
                                    root.removeChild(child);
                                    _LOGGER.log(Level.INFO, MobileResourceUtils.getMsg("ADF-MBL-20503", id));
                                    return;
                                }
                            }
                        }
                    }.run((AbstractModel)model);
                }
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00505", e));
            }
        }
    }

    public static Workspace newWorkspaceFromNamespace(Namespace data) {
        String KEY_WORKSPACE = "workspace";
        Object workspaceDataObject = data.find("workspace");
        if (null == workspaceDataObject) {
            return null;
        }
        assert (workspaceDataObject instanceof Workspace);
        Workspace workspace = (Workspace)workspaceDataObject;
        return workspace;
    }

    private static String getXmlElementAttribute(Document xmlDocument, String xmlElementName, String xmlAttributeName) {
        String attributeValue = "";
        try {
            Element rootElement = xmlDocument.getDocumentElement();
            if (xmlElementName.equals(rootElement.getLocalName())) {
                attributeValue = rootElement.getAttributeNS(null, xmlAttributeName);
            } else {
                NodeList childNodes = rootElement.getChildNodes();
                if (null != childNodes) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        org.w3c.dom.Node child = childNodes.item(i);
                        if (!(child instanceof Element) || !xmlElementName.equals(child.getLocalName())) continue;
                        attributeValue = ((Element)child).getAttributeNS(null, xmlAttributeName);
                        break;
                    }
                }
            }
            if (null == attributeValue) {
                attributeValue = "";
            }
            attributeValue = attributeValue.trim();
        }
        catch (Exception e) {
            attributeValue = "";
        }
        return attributeValue;
    }

    private static List<URL> getFarURLs(Workspace workspace) {
        ArrayList<URL> farArrayList = new ArrayList<URL>();
        List<URL> jarUrlList = McAppUtils.getApplicationLibraryJarUrls(workspace);
        for (URL jarUrl : jarUrlList) {
            if (!McAppUtils.isFeatureArchive(jarUrl)) continue;
            farArrayList.add(jarUrl);
        }
        return farArrayList;
    }

    private static String _getApplicationAttribute(Workspace workspace, String xmlAttributeName) {
        String appAttribute = null;
        try {
            appAttribute = McAppUtils.getXmlElementAttribute(McAppUtils.getApplicationXmlDOM(workspace), "application", xmlAttributeName);
        }
        catch (IOException e) {
            appAttribute = "";
        }
        catch (ParserConfigurationException e) {
            appAttribute = "";
        }
        catch (SAXException e) {
            appAttribute = "";
        }
        return appAttribute;
    }
}

