/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class JSONProfileUtils {
    public static void createEmptyJsonProfile(URL jsonProfileFileURL) throws IOException, JsonParseException {
        HashMap<String, Object> profileMap = new HashMap<String, Object>();
        JSONProfileUtils._writeJSONProfileFile(jsonProfileFileURL, profileMap);
    }

    public static Object getJsonProfileValue(URL jsonProfileFileURL, String key) throws IOException, JsonParseException {
        Map<String, Object> profileMap = JSONProfileUtils._readJSONProfileFile(jsonProfileFileURL);
        return profileMap.get(key);
    }

    public static void updateJsonProfileKeyValue(URL jsonProfileFileURL, String key, Object value) throws FileNotFoundException, JsonParseException, IOException {
        Map<String, Object> profileMap = JSONProfileUtils._readJSONProfileFile(jsonProfileFileURL);
        profileMap.put(key, value);
        JSONProfileUtils._writeJSONProfileFile(jsonProfileFileURL, profileMap);
    }

    public static void updateJsonProfileListValue(URL jsonProfileFileURL, String listKey, String value) throws FileNotFoundException, JsonParseException, IOException {
        Map<String, Object> profileMap = JSONProfileUtils._readJSONProfileFile(jsonProfileFileURL);
        Object currentValue = profileMap.get(listKey);
        if (null != currentValue && !(currentValue instanceof List)) {
            profileMap.remove(listKey);
            currentValue = null;
        }
        if (null == currentValue) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            profileMap.put(listKey, list);
        } else {
            List list = (List)profileMap.get(listKey);
            if (!list.contains(value)) {
                list.add(value);
                profileMap.put(listKey, list);
            }
        }
        JSONProfileUtils._writeJSONProfileFile(jsonProfileFileURL, profileMap);
    }

    private static Map<String, Object> _readJSONProfileFile(URL jsonProfileFileURL) throws IOException, JsonParseException {
        HashMap<String, Object> userInMap = new HashMap<String, Object>();
        JsonFactory factory = new JsonFactory();
        JsonParser jsonParser = factory.createJsonParser(jsonProfileFileURL);
        JsonToken current = jsonParser.nextToken();
        if (current != JsonToken.START_OBJECT) {
            return userInMap;
        }
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.getCurrentName();
            current = jsonParser.nextToken();
            if (current == JsonToken.VALUE_FALSE) {
                userInMap.put(fieldName, Boolean.FALSE);
                continue;
            }
            if (current == JsonToken.VALUE_TRUE) {
                userInMap.put(fieldName, Boolean.TRUE);
                continue;
            }
            if (current == JsonToken.VALUE_NUMBER_FLOAT) {
                float num = jsonParser.getFloatValue();
                userInMap.put(fieldName, new Float(num));
                continue;
            }
            if (current == JsonToken.VALUE_NUMBER_INT) {
                int num = jsonParser.getIntValue();
                userInMap.put(fieldName, num);
                continue;
            }
            if (current == JsonToken.START_ARRAY) {
                ArrayList<String> list = new ArrayList<String>();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    String fieldValue = jsonParser.getText();
                    list.add(fieldValue);
                }
                userInMap.put(fieldName, list);
                continue;
            }
            if (current == JsonToken.VALUE_STRING) {
                String fieldValue = jsonParser.getText();
                userInMap.put(fieldName, fieldValue);
                jsonParser.skipChildren();
                continue;
            }
            jsonParser.skipChildren();
        }
        return userInMap;
    }

    private static void _writeJSONProfileFile(URL jsonProfileFileURL, Map<String, Object> profileMap) throws FileNotFoundException, JsonParseException, IOException {
        JsonFactory factory = new JsonFactory();
        File jsonFile = new File(jsonProfileFileURL.getPath());
        JsonGenerator generator = factory.createJsonGenerator(jsonFile, JsonEncoding.UTF8);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : profileMap.entrySet()) {
            Number num;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                generator.writeBooleanField(key, boolValue.booleanValue());
                continue;
            }
            if (value instanceof String) {
                generator.writeStringField(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                num = (Integer)value;
                generator.writeNumberField(key, ((Integer)num).intValue());
                continue;
            }
            if (value instanceof Float) {
                num = (Float)value;
                generator.writeNumberField(key, ((Float)num).floatValue());
                continue;
            }
            if (!(value instanceof List)) continue;
            ArrayList list = (ArrayList)value;
            generator.writeArrayFieldStart(key);
            for (String arrayElement : list) {
                generator.writeString(arrayElement);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
        generator.close();
    }
}

