/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.XmlUtils;
import oracle.ide.Ide;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import org.w3c.dom.Document;

public class FileUtils {
    private static final String _ANDROID_PLATFORM_TOOLS_ROOT_DIR = "platform-tools";
    private static final String _ANDROID_PLATFORM_JAR_NAME = "android.jar";
    private static final String _IOS_SDK_SYSTEM_ROOT_DIR = "System";
    private static final String _IOS_XCODEBUILD_ROOT_FILE = "xcodebuild";

    public static URL getJdevDocDirectoryUrl() {
        URL oracleHomeDirectoryUrl = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        return URLFactory.newDirURL((URL)oracleHomeDirectoryUrl, (String)"jdev/doc/studio_doc/ohj");
    }

    public static URL getSupportFilesDirectoryUrl() {
        URL jdevExtensionsDirUrl = FileUtils._getJDevExtensionsDirectoryUrl();
        return URLFactory.newDirURL((URL)jdevExtensionsDirUrl, (String)"oracle.adf.mobile");
    }

    public static URL getUrlFromPath(String directoryPath) {
        URL pathUrl = null;
        if (null != directoryPath && directoryPath.trim().length() > 0 && !URLFileSystem.isDirectory((URL)(pathUrl = URLFactory.newDirURL((String)directoryPath.trim())))) {
            pathUrl = null;
        }
        return pathUrl;
    }

    public static void copyDirectoryInclusive(URL src, URL dest) throws IOException {
        String srcDirName = URLFileSystem.getFileName((URL)src);
        URL destDir = URLFactory.newDirURL((URL)dest, (String)srcDirName);
        FileUtils.copyDirectoryContent(src, destDir);
    }

    public static void copyDirectoryContent(URL src, URL dest) throws IOException {
        if (!URLFileSystem.exists((URL)src)) {
            return;
        }
        if (!URLFileSystem.exists((URL)dest)) {
            URLFileSystem.mkdirs((URL)dest);
        }
        URL[] children = URLFileSystem.list((URL)src);
        for (int i = 0; i < children.length; ++i) {
            if (URLFileSystem.isDirectory((URL)children[i])) {
                String dirName = URLFileSystem.getFileName((URL)children[i]);
                FileUtils.copyDirectory(children[i], URLFactory.newDirURL((URL)dest, (String)dirName));
                continue;
            }
            String suffix = URLFileSystem.getSuffix((URL)children[i]);
            URL destWithSuffix = URLFactory.newURL((URL)dest, (String)(URLFileSystem.getName((URL)children[i]) + suffix));
            URLFileSystem.copy((URL)children[i], (URL)destWithSuffix);
            String childFilePath = children[i].getPath();
            File childFile = new File(childFilePath);
            if (!childFile.canExecute()) continue;
            String destFilePath = destWithSuffix.getPath();
            File destFile = new File(destFilePath);
            destFile.setExecutable(true);
        }
    }

    public static void copyDirectory(URL src, URL dest) throws IOException {
        if (!URLFileSystem.exists((URL)dest)) {
            URLFileSystem.mkdirs((URL)dest);
        }
        URL[] children = URLFileSystem.list((URL)src);
        for (int i = 0; i < children.length; ++i) {
            if (URLFileSystem.isDirectory((URL)children[i])) {
                String dirName = URLFileSystem.getFileName((URL)children[i]);
                FileUtils.copyDirectory(children[i], URLFactory.newDirURL((URL)dest, (String)dirName));
                continue;
            }
            String suffix = URLFileSystem.getSuffix((URL)children[i]);
            URL destWithSuffix = URLFactory.newURL((URL)dest, (String)(URLFileSystem.getName((URL)children[i]) + suffix));
            URLFileSystem.copy((URL)children[i], (URL)destWithSuffix);
        }
    }

    public static void copyFile(URL srcFile, URL destDir, String newFileName) throws IOException {
        if (null != srcFile && URLFileSystem.exists((URL)srcFile) && null != destDir) {
            String destFileName = null != newFileName ? newFileName : URLFileSystem.getFileName((URL)srcFile);
            URL destWithSuffix = URLFactory.newURL((URL)destDir, (String)destFileName);
            URLFileSystem.copy((URL)srcFile, (URL)destWithSuffix);
            String childFilePath = srcFile.getPath();
            File childFile = new File(childFilePath);
            if (childFile.canExecute()) {
                String destFilePath = destWithSuffix.getPath();
                File destFile = new File(destFilePath);
                destFile.setExecutable(true);
            }
        }
    }

    public static void deleteDirectory(URL directory) throws IOException {
        if (URLFileSystem.exists((URL)directory)) {
            URL[] children = URLFileSystem.list((URL)directory);
            for (int i = 0; i < children.length; ++i) {
                if (URLFileSystem.isDirectory((URL)children[i])) {
                    FileUtils.deleteDirectory(children[i]);
                    continue;
                }
                URLFileSystem.deleteEx((URL)children[i]);
            }
            URLFileSystem.deleteEx((URL)directory);
        }
    }

    public static void deleteFile(URL file) throws IOException {
        if (URLFileSystem.exists((URL)file)) {
            URLFileSystem.deleteEx((URL)file);
        }
    }

    public static boolean isDiagnosticLoggingEnabled() {
        String isDiagnosticLoggingEnabled = System.getProperty("adfmfenableDiagnosticLogging");
        return isDiagnosticLoggingEnabled != null && isDiagnosticLoggingEnabled.equalsIgnoreCase("true");
    }

    public static boolean doesFileExist(String filePath) {
        if (!ModelUtil.hasLength((String)filePath)) {
            return false;
        }
        String newFilePath = filePath.replaceAll("\"", "");
        String platformSpecificPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)newFilePath));
        return URLFileSystem.exists((URL)URLFactory.newFileURL((String)platformSpecificPath));
    }

    public static boolean doesUrlResourceExist(String urlSpec) {
        if (!ModelUtil.hasLength((String)urlSpec)) {
            return false;
        }
        URL fileUrl = URLFactory.newURL((String)urlSpec, (boolean)false, (boolean)false);
        if (fileUrl == null) {
            return false;
        }
        boolean exists = URLFileSystem.exists((URL)fileUrl);
        return exists;
    }

    public static String getFileExtension(String fileName) {
        int i = fileName.lastIndexOf(".");
        if (i > 0 && i < fileName.length() - 1) {
            return "." + fileName.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String buildCommaDelimitedStringFromMapKeys(Map<String, ?> map) {
        if (null == map || map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> currEntry : map.entrySet()) {
            sb.append(currEntry.getKey());
            sb.append(",");
            sb.append(" ");
        }
        String retVal = sb.toString();
        if (ModelUtil.hasLength((String)retVal)) {
            retVal = retVal.substring(0, retVal.length() - 2);
        }
        return retVal;
    }

    public static String[] buildStringArrayFromMapKeys(Map<String, ?> map) {
        if (null == map || map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, ?> currEntry : map.entrySet()) {
            stringArray[i++] = currEntry.getKey();
        }
        return stringArray;
    }

    public static String getProjectRelativeFilePath(URL absoluteUrl, URL projectUrl) {
        if (null != absoluteUrl) {
            return URLFileSystem.toRelativeSpec((URL)absoluteUrl, (URL)projectUrl, (boolean)true);
        }
        return "";
    }

    public static boolean createDirectory(URL directoryUrl) {
        boolean bDirCreationSucceeded = true;
        if (!URLFileSystem.exists((URL)directoryUrl)) {
            bDirCreationSucceeded = URLFileSystem.mkdirs((URL)directoryUrl);
        }
        return bDirCreationSucceeded;
    }

    public static boolean isAndroidSdkDirValid(String sdkDirectoryPath) {
        if (sdkDirectoryPath != null && sdkDirectoryPath.trim().length() > 0) {
            String platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)(sdkDirectoryPath + ADFMobileConstants.PATH_SEP + _ANDROID_PLATFORM_TOOLS_ROOT_DIR)));
            return URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)platformDependentPath));
        }
        return false;
    }

    public static boolean areBuildToolsInPlatformToolsForSdk(String sdkDirectoryPath) {
        if (sdkDirectoryPath != null && sdkDirectoryPath.trim().length() > 0) {
            String platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)(sdkDirectoryPath.trim() + ADFMobileConstants.PATH_SEP + _ANDROID_PLATFORM_TOOLS_ROOT_DIR)));
            return FileUtils.isAndroidBuildToolsDirValid(platformDependentPath);
        }
        return false;
    }

    public static boolean isAndroidPlatformDirValid(String platformDirectoryPath) {
        String androidJarPath;
        String platformDependentPath;
        if (platformDirectoryPath != null && platformDirectoryPath.trim().length() > 0 && URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)(platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)platformDirectoryPath))))) && URLFileSystem.exists((URL)URLFactory.newFileURL((String)(androidJarPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)(platformDependentPath + ADFMobileConstants.PATH_SEP + _ANDROID_PLATFORM_JAR_NAME))))))) {
            return FileUtils._isAndroidPlatformDirVersionValid(platformDirectoryPath);
        }
        return false;
    }

    public static boolean isAndroidBuildToolsDirValid(String buildToolsDirectoryPath) {
        String platformDependentPath;
        if (buildToolsDirectoryPath != null && buildToolsDirectoryPath.trim().length() > 0 && URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)(platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)buildToolsDirectoryPath.trim())))))) {
            String aaptExeName = PlatformUtils.isWindows() ? "aapt.exe" : "aapt";
            String androidJarPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)(platformDependentPath + ADFMobileConstants.PATH_SEP + aaptExeName)));
            if (URLFileSystem.exists((URL)URLFactory.newFileURL((String)androidJarPath))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isiOSiTunesDirValid(String iTunesDir) {
        if (iTunesDir != null && iTunesDir.trim().length() > 0) {
            String platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)iTunesDir));
            return URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)platformDependentPath));
        }
        return false;
    }

    public static boolean isiOSSdkDirValid(String sdkDir) {
        if (sdkDir != null && sdkDir.trim().length() > 0) {
            String platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)(sdkDir + ADFMobileConstants.PATH_SEP + _IOS_SDK_SYSTEM_ROOT_DIR)));
            return URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)platformDependentPath));
        }
        return false;
    }

    public static boolean isiOSSdkVersionValid(String sdkDir) {
        if (sdkDir != null && sdkDir.trim().length() > 0) {
            String iPhoneSimulator = "iPhoneSimulator";
            String sdkVersionNumber = null;
            int index = sdkDir.lastIndexOf("iPhoneSimulator");
            if (index != -1 && sdkDir.length() > index + "iPhoneSimulator".length()) {
                sdkVersionNumber = sdkDir.substring(index + "iPhoneSimulator".length()).trim();
            }
            if (null != sdkVersionNumber) {
                VersionNumber minSdkVersionNumber = new VersionNumber("6.0");
                VersionNumber chosenVersionNumber = new VersionNumber(sdkVersionNumber);
                return minSdkVersionNumber.isBefore(chosenVersionNumber, true);
            }
        }
        return false;
    }

    public static boolean isiOSxcodebuildDirValid(String xcodebuildDir) {
        String platformDependentPath;
        if (xcodebuildDir != null && xcodebuildDir.trim().length() > 0 && URLFileSystem.isDirectory((URL)URLFactory.newDirURL((String)(platformDependentPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)xcodebuildDir)))))) {
            String iOSxcodebuildPath = URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)(platformDependentPath + ADFMobileConstants.PATH_SEP + _IOS_XCODEBUILD_ROOT_FILE)));
            return URLFileSystem.exists((URL)URLFactory.newFileURL((String)iOSxcodebuildPath));
        }
        return false;
    }

    public static String getAbsoluteLocation(Workspace workspace, String sRelativeLocation) {
        String sAbsoluteLocation = "";
        try {
            if (ModelUtil.hasLength((String)sRelativeLocation)) {
                File oFile = new File(sRelativeLocation);
                if (!oFile.isAbsolute()) {
                    URL oAbsoluteURL = new URL(McAppUtils.getAppRootURL(workspace), sRelativeLocation);
                    if (null != oAbsoluteURL) {
                        sAbsoluteLocation = URLFileSystem.getPlatformPathName((URL)oAbsoluteURL);
                    }
                } else {
                    sAbsoluteLocation = sRelativeLocation;
                }
            }
        }
        catch (MalformedURLException e) {
            sAbsoluteLocation = sRelativeLocation;
        }
        return sAbsoluteLocation;
    }

    public static String getIOSExePath(String ideDir) {
        URL jdeDirectoryUrl = URLFactory.newURL((String)ideDir);
        return URLFileSystem.getPlatformPathName((URL)jdeDirectoryUrl);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        URL encodedUrl = URLFactory.encodeURL((URL)url);
        return encodedUrl.toURI();
    }

    public static void writeXmlFile(Document document, URL destinationUrl) throws Exception {
        String xmlContent = XmlUtils.toXmlString(document);
        URI destinationFileUri = FileUtils.toURI(destinationUrl);
        FileUtils.writeStringToFile(xmlContent, destinationFileUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String content, URI fileUri) throws IOException {
        File file = new File(fileUri);
        boolean APPEND_OPTION = false;
        FileOutputStream outputStream = new FileOutputStream(file, false);
        try {
            outputStream.write(content.getBytes());
        }
        finally {
            FileUtils.closeStream(outputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void zipDirectory(URL srcDirectoryURL, URL toZipURL, boolean includeEmptyDirs) throws IOException {
        ZipOutputStream zos = null;
        try {
            File directory = new File(srcDirectoryURL.getFile());
            assert (directory.isDirectory());
            File zipFile = new File(toZipURL.getFile());
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            FileUtils.zip(directory, directory, zos, includeEmptyDirs);
        }
        finally {
            if (null != zos) {
                zos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zip(File directory, File initialDir, ZipOutputStream zipOutputStream, boolean includeEmptyDirs) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        if (files.length == 0 && includeEmptyDirs) {
            int dirContentIndex = initialDir.getPath().length() + 1;
            String dirContentName = directory.getPath().substring(dirContentIndex) + "/";
            ZipEntry entry = new ZipEntry(dirContentName);
            zipOutputStream.putNextEntry(entry);
            return;
        }
        String BACKSLASH_REGEX = "\\\\";
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.zip(files[i], initialDir, zipOutputStream, includeEmptyDirs);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            try {
                int dirContentIndex = initialDir.getPath().length() + 1;
                String dirContentName = files[i].getPath().substring(dirContentIndex);
                String entryPath = dirContentName.replaceAll("\\\\", "/");
                ZipEntry entry = new ZipEntry(entryPath);
                zipOutputStream.putNextEntry(entry);
                while (-1 != (read = in.read(buffer))) {
                    zipOutputStream.write(buffer, 0, read);
                }
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(URL sourceFileUrl, URL destinationUrl) throws FileNotFoundException, IOException {
        block10: {
            ZipFile zipFile = null;
            try {
                TreeSet<String> dirsCreated = new TreeSet<String>();
                String destinationName = destinationUrl.getPath();
                FileUtils.createDirectory(destinationUrl);
                String sourceFileName = sourceFileUrl.getPath();
                if (ModelUtil.hasLength((String)destinationName) && ModelUtil.hasLength((String)sourceFileName)) {
                    zipFile = new ZipFile(sourceFileName);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        FileUtils.getFile(zipEntry, dirsCreated, zipFile, destinationUrl);
                    }
                    break block10;
                }
                String msg = MobileResourceUtils.getMsg("ADF-MBL-00002", sourceFileName, destinationName);
                throw new FileNotFoundException(msg);
            }
            finally {
                if (null != zipFile) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void getFile(ZipEntry zipEntry, SortedSet<String> dirsMade, ZipFile zipFile, URL destinationURL) throws IOException {
        File directory;
        URL dirURL;
        String dirName;
        String zipName = zipEntry.getName();
        if (zipName.startsWith("/")) {
            zipName = zipName.substring(1);
        }
        if (zipName.endsWith("/")) {
            return;
        }
        int index = zipName.lastIndexOf("/");
        if (!(index <= 0 || dirsMade.contains(dirName = (dirURL = URLFactory.newDirURL((URL)destinationURL, (String)zipName.substring(0, index))).getPath()) || (directory = new File(dirName)).exists() && directory.isDirectory())) {
            if (!directory.mkdirs()) {
                String msg = MobileResourceUtils.getMsg("ADF-MBL-00062", directory);
                throw new IOException(msg);
            }
            dirsMade.add(dirName);
        }
        InputStream inoutStream = null;
        try {
            URL destURL = FileUtils.newFileUrl(destinationURL, zipName);
            inoutStream = zipFile.getInputStream(zipEntry);
            URLFileSystem.copy((InputStream)inoutStream, (URL)destURL);
        }
        finally {
            if (null != inoutStream) {
                try {
                    inoutStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromZip(ZipFile archiveFile, ZipEntry zipEntry, URL destinationUrl) throws IOException {
        if (zipEntry.isDirectory()) {
            FileUtils.createDirectory(destinationUrl);
        } else {
            URL parentDirUrl = URLFileSystem.getParent((URL)destinationUrl);
            FileUtils.createDirectory(parentDirUrl);
            InputStream inStream = null;
            try {
                inStream = archiveFile.getInputStream(zipEntry);
                URLFileSystem.copy((InputStream)inStream, (URL)destinationUrl);
            }
            finally {
                FileUtils.closeStream(inStream, null);
            }
        }
    }

    public static URL getLibraryZipFileUrl(URL folderURL, String zipFileName) {
        URL zipFileUrl = URLFactory.newDirURL((URL)folderURL, (String)zipFileName);
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(FileReader fileReader) throws IOException {
        BufferedReader br = new BufferedReader(fileReader);
        StringBuilder result = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                result.append(line);
                result.append(ADFMobileConstants.LINE_SEP);
                line = br.readLine();
            }
        }
        finally {
            FileUtils.closeStream(br, null);
        }
        return result.toString();
    }

    public static void closeStream(Closeable closeable, Logger logger) {
        block3: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException ioe) {
                    if (null == logger) break block3;
                    logger.warning(MobileResourceUtils.getMsg("ADF-MBL-10012", ioe.getMessage()));
                }
            }
        }
    }

    public static void initializeURLChooser(URL rootUrl, URLChooser urlChooser) {
        urlChooser.setSelectionMode(1);
        urlChooser.setSelectionScope(1);
        urlChooser.removeShortcutButtons();
        urlChooser.clearChooseableURLFilters();
        urlChooser.setRoots(new URL[]{rootUrl});
        URL currentUrl = urlChooser.getSelectedURL();
        URL initialUrl = rootUrl;
        if (currentUrl != null && URLFileSystem.exists((URL)currentUrl) && URLFileSystem.isDirectory((URL)currentUrl) && URLFileSystem.isBaseURLFor((URL)rootUrl, (URL)currentUrl)) {
            initialUrl = currentUrl;
        }
        urlChooser.setSelectedURL(initialUrl);
    }

    public static boolean areFileSizesEqual(URL fileUrl1, URL fileUrl2) {
        if (null == fileUrl1 || null == fileUrl2) {
            throw new IllegalArgumentException();
        }
        if (URLFileSystem.exists((URL)fileUrl1) && URLFileSystem.exists((URL)fileUrl2)) {
            File file1 = new File(fileUrl1.getPath());
            File file2 = new File(fileUrl2.getPath());
            if (!file1.isFile() || !file2.isFile()) {
                throw new IllegalArgumentException();
            }
            if (URLFileSystem.getLength((URL)fileUrl1) == URLFileSystem.getLength((URL)fileUrl2)) {
                return true;
            }
        }
        return false;
    }

    public static void logCommand(Logger logger, String destPath, List<String> cmdList) {
        StringBuilder command = new StringBuilder();
        for (String cmd : cmdList) {
            command.append(" ");
            command.append(cmd);
        }
        if (null != destPath) {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20025", destPath));
        }
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20002", command.toString()));
    }

    private static boolean _isAndroidPlatformDirVersionValid(String platformDirectoryPath) {
        String versionChosen;
        VersionNumber chosenVersionNumber;
        VersionNumber minVersionNumber;
        int versionIndex;
        return platformDirectoryPath != null && platformDirectoryPath.trim().length() > 0 && (versionIndex = platformDirectoryPath.lastIndexOf("-")) > -1 && versionIndex < platformDirectoryPath.length() && (minVersionNumber = new VersionNumber("9")).isBefore(chosenVersionNumber = new VersionNumber(versionChosen = platformDirectoryPath.substring(versionIndex + 1)), true);
    }

    private static URL _getJDevExtensionsDirectoryUrl() {
        URL oracleHomeDirectoryUrl = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        return URLFactory.newDirURL((URL)oracleHomeDirectoryUrl, (String)"jdev/extensions");
    }

    public static URL newFileUrl(URL folderUrl, String fileName) {
        String PATH_FORMAT = "%s%s%s";
        String filePath = String.format("%s%s%s", URLFileSystem.getPlatformPathName((URL)folderUrl), ADFMobileConstants.PATH_SEP, fileName);
        return URLFactory.newFileURL((String)filePath);
    }

    public static String stripSuffixFromString(String source, String suffix) {
        if (source.endsWith(suffix)) {
            int amountToRemove = source.length() - Math.min(source.length(), suffix.length());
            String result = source.substring(0, amountToRemove);
            return result;
        }
        return source;
    }
}

