/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;

public class DTWebServer
implements Runnable {
    private static final int REQUEST_BACKLOG = 0;
    private int m_port;
    private HttpServer m_server;
    private String m_webRoot = "";
    private Thread m_serverThread = null;
    private static final Logger s_logger = Logger.getLogger(DTWebServer.class.getName());

    public DTWebServer(String rootFolder) {
        this.m_webRoot = rootFolder;
    }

    @Override
    public void run() {
        try {
            this.m_server = this.createHttpServer();
            this.m_server.createContext("/", new DTHttpHandler());
            this.m_server.setExecutor(Executors.newCachedThreadPool());
            this.m_server.start();
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00037", e));
        }
    }

    private HttpServer createHttpServer() throws Exception {
        int START_PORT = 6001;
        int END_PORT = 49151;
        for (int portNumber = 6001; portNumber <= 49151; ++portNumber) {
            try {
                InetSocketAddress addr = new InetSocketAddress(portNumber);
                HttpServer server = HttpServer.create(addr, 0);
                this.m_port = portNumber;
                return server;
            }
            catch (BindException bindException) {
                if (portNumber < 49151) continue;
                throw bindException;
            }
        }
        return null;
    }

    public int getPort() {
        return this.m_port;
    }

    public void start() {
        if (this.m_server == null) {
            this.m_serverThread = new Thread(this);
            this.m_serverThread.setPriority(1);
            this.m_serverThread.start();
        }
    }

    public void stop() {
        if (this.m_server != null) {
            this.m_server.stop(0);
        }
    }

    private class DTHttpHandler
    implements HttpHandler {
        private static final String GET_REQUEST = "GET";
        private static final String CONTENT_TYPE = "Content-Type";
        private static final String CONTENT_PLAIN_TEXT = "text/plain";
        private static final String FILE_EXTENSION_JS = ".js";
        private static final String CONTENT_APPLICATION_JAVASCRIPT = "application/javascript";
        private static final String FILE_EXTENSION_CSS = ".css";
        private static final String CONTENT_TEXT_CSS = "text/css";
        private static final String FILE_EXTENSION_HTML = ".html";
        private static final String CONTENT_TEXT_HTML = "text/html";
        private static final String FILE_EXTENSION_PNG = ".png";
        private static final String CONTENT_IMAGE_PNG = "image/png";
        private static final String FILE_EXTENSION_XML = ".xml";
        private static final String CONTENT_TEXT_XML = "text/xml";
        private static final String CHARSET_UTF_8 = "charset=UTF-8";
        private static final int STATUS_FILE_NOT_FOUND = 404;
        private static final int STATUS_OK = 200;

        private DTHttpHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            block10: {
                String requestMethod = httpExchange.getRequestMethod();
                InputStreamReader requestedFile = null;
                OutputStream outputStream = null;
                try {
                    if (!GET_REQUEST.equalsIgnoreCase(requestMethod)) break block10;
                    Headers resHeaders = httpExchange.getResponseHeaders();
                    String contentType = this.getContentType(httpExchange.getRequestURI().getPath());
                    resHeaders.set(CONTENT_TYPE, contentType);
                    try {
                        requestedFile = new FileReader(DTWebServer.this.m_webRoot + httpExchange.getRequestURI().getPath());
                    }
                    catch (FileNotFoundException e) {
                        httpExchange.sendResponseHeaders(404, 0L);
                        outputStream = httpExchange.getResponseBody();
                        outputStream.write(0);
                        if (requestedFile != null) {
                            requestedFile.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        return;
                    }
                    String response = FileUtils.readFileToString((FileReader)requestedFile);
                    httpExchange.sendResponseHeaders(200, response.length());
                    outputStream = httpExchange.getResponseBody();
                    outputStream.write(response.getBytes());
                    outputStream.flush();
                }
                finally {
                    if (requestedFile != null) {
                        requestedFile.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }

        private String getContentType(String requestPath) {
            String contentType = CONTENT_PLAIN_TEXT;
            if (requestPath.endsWith(FILE_EXTENSION_JS)) {
                contentType = CONTENT_APPLICATION_JAVASCRIPT;
            } else if (requestPath.endsWith(FILE_EXTENSION_CSS)) {
                contentType = CONTENT_TEXT_CSS;
            } else if (requestPath.endsWith(FILE_EXTENSION_HTML)) {
                contentType = CONTENT_TEXT_HTML;
            } else if (requestPath.endsWith(FILE_EXTENSION_PNG)) {
                contentType = CONTENT_IMAGE_PNG;
            } else if (requestPath.endsWith(FILE_EXTENSION_XML)) {
                contentType = CONTENT_TEXT_XML;
            }
            contentType = contentType + ";charset=UTF-8";
            return contentType;
        }
    }
}

