/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.webapp.utils.WebDocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ADFMobileResourceBundleUtils {
    public static final String BASENAME_ATTR = "basename";
    public static final String VAR_ATTR = "var";
    private static final String _BUNDLE = "Bundle";
    private static final String _LOAD_BUNDLE_TAG = "loadBundle";

    private ADFMobileResourceBundleUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getVarFromLoadBundle(AbstractModel model, String bundleId) {
        String varValue = null;
        model.acquireReadLock();
        try {
            String namespace = model.getDocument().getDocumentElement().getNamespaceURI();
            Iterator nIt = WebDocumentUtil.findNodes((AbstractModel)model, (String)_LOAD_BUNDLE_TAG, (String)namespace);
            Node loadBundleNode = null;
            Node loadBundleNodeAtt = null;
            while (nIt.hasNext()) {
                loadBundleNode = (Node)nIt.next();
                if (loadBundleNode.getAttributes() == null || (loadBundleNodeAtt = loadBundleNode.getAttributes().getNamedItemNS(null, BASENAME_ATTR)) == null || !loadBundleNodeAtt.getNodeValue().equals(bundleId) || (loadBundleNodeAtt = loadBundleNode.getAttributes().getNamedItemNS(null, VAR_ATTR)) == null) continue;
                varValue = loadBundleNodeAtt.getNodeValue();
                break;
            }
        }
        finally {
            model.releaseReadLock();
        }
        return varValue;
    }

    public static String checkAddBundleEntry(AbstractModel model, String bundleId) throws Throwable {
        String varValue = ADFMobileResourceBundleUtils._getVarFromLoadBundle(model, bundleId);
        if (varValue == null) {
            varValue = ADFMobileResourceBundleUtils._insertLoadBundleTag(model, bundleId);
        }
        return varValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Element> findApplicableLoadBundles(XmlModel model, Set<String> possibleBundleVars) {
        ArrayList<Element> loadBundles = new ArrayList<Element>();
        model.acquireReadLock();
        try {
            String namespace = model.getDocument().getDocumentElement().getNamespaceURI();
            NodeList nodes = model.getDocument().getElementsByTagNameNS(namespace, _LOAD_BUNDLE_TAG);
            Node node = null;
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String var;
                    node = nodes.item(i);
                    if (node.getNodeType() != 1 || (var = ((Element)node).getAttributeNS(null, VAR_ATTR)) == null || var.isEmpty() || !possibleBundleVars.contains(var)) continue;
                    loadBundles.add((Element)node);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return loadBundles;
    }

    private static String _insertLoadBundleTag(AbstractModel model, String bundleId) throws Throwable {
        String varValue = null;
        model.startTransaction("insert loadBundle tag...");
        try {
            String namespace = model.getDocument().getDocumentElement().getNamespaceURI();
            Element element = model.getDocument().createElementNS(namespace, _LOAD_BUNDLE_TAG);
            element.setAttributeNS(null, BASENAME_ATTR, bundleId);
            varValue = ADFMobileResourceBundleUtils._getNewVarName(model, namespace);
            element.setAttributeNS(null, VAR_ATTR, varValue);
            DomPosition cursor = DomPositionFactory.beforeFirstChildOrInside((Node)model.getDocument().getDocumentElement());
            model.insertNode((Node)element, cursor, false);
            model.commitTransaction();
        }
        catch (Throwable e) {
            model.rollbackTransaction();
            throw e;
        }
        return varValue;
    }

    private static String _getNewVarName(AbstractModel model, String namespace) {
        JDevXmlContext xmlContext = (JDevXmlContext)model.getContext();
        XMLSourceNode node = xmlContext.getIdeDocument();
        Workspace storageNode = node instanceof FrameworkXmlSourceNode ? xmlContext.getWorkspace() : xmlContext.getProject();
        Iterator nIt = WebDocumentUtil.findNodes((AbstractModel)model, (String)_LOAD_BUNDLE_TAG, (String)namespace);
        Node loadBundleNode = null;
        Node loadBundleNodeAtt = null;
        HashSet<String> varNameHashSet = new HashSet<String>();
        while (nIt.hasNext()) {
            loadBundleNode = (Node)nIt.next();
            if (loadBundleNode.getAttributes() == null || (loadBundleNodeAtt = loadBundleNode.getAttributes().getNamedItemNS(null, BASENAME_ATTR)) == null || (loadBundleNodeAtt = loadBundleNode.getAttributes().getNamedItemNS(null, VAR_ATTR)) == null) continue;
            varNameHashSet.add(loadBundleNodeAtt.getNodeValue());
        }
        return ADFMobileResourceBundleUtils._getUniqueVarName(varNameHashSet, (HashStructureNode)storageNode);
    }

    private static String _getUniqueVarName(HashSet<String> varNameHashSet, HashStructureNode storageNode) {
        String defaultBundleName;
        String newVarName = defaultBundleName = ADFMobileResourceBundleUtils._getDefaultBundleName(storageNode);
        int i = 0;
        while (varNameHashSet.contains(newVarName)) {
            newVarName = defaultBundleName + ++i;
        }
        return newVarName;
    }

    private static String _getDefaultBundleName(HashStructureNode storageNode) {
        String shortLabel = storageNode.getShortLabel().toLowerCase();
        int index = shortLabel.indexOf(".jpr");
        if (index == -1) {
            index = shortLabel.indexOf(".jws");
        }
        if (index != -1) {
            shortLabel = shortLabel.substring(0, index);
        }
        if (shortLabel.contains(".")) {
            shortLabel = shortLabel.replace(".", "_");
        }
        String defaultBundleName = shortLabel + _BUNDLE;
        return defaultBundleName;
    }
}

