/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.tagdoc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class XsdExpander {
    private String _inputFile = "";
    private String _outputFile = "";
    private String _includeRoot = "";
    private static final String _INCLUDE_ELEM = ".*xsd:include.*";
    private static final String _SCHEMA_LOCATION = "schemaLocation";
    private static final String _CLOSING_INCLUDE_TAG = "</xsd:include>";
    private static final String _TERMINATED_TAG = "/>";
    private static final String _XSD_FILE_HEADER = ".*<\\?xml.*\\?>.*";
    private static final String _QUOTE = "\"";
    private static final String _GREATER_THAN = ">";
    private static final String _CARRIAGE_RETURN = "\r";
    private static final String _NEW_LINE = "\n";
    private static final String _FORWARD_SLASH = "/";

    public static void main(String[] args) {
        XsdExpander xsdExpander = new XsdExpander();
        if (args.length > 0) {
            xsdExpander.setRoot(args[0]);
        }
        if (args.length > 1) {
            xsdExpander.setIn(args[1]);
        }
        if (args.length > 2) {
            xsdExpander.setOut(args[2]);
        }
        xsdExpander.expand();
    }

    public void setRoot(String root) {
        this._includeRoot = root;
    }

    public void setIn(String inputFile) {
        this._inputFile = inputFile;
    }

    public void setOut(String outputFile) {
        this._outputFile = outputFile;
    }

    public void expand() {
        List<String> expandedFile = this._getFileContents(this._inputFile);
        for (int fileIndex = 0; fileIndex < expandedFile.size(); ++fileIndex) {
            String include = expandedFile.get(fileIndex);
            if (!include.matches(_INCLUDE_ELEM)) continue;
            int start = include.indexOf(_SCHEMA_LOCATION) + _SCHEMA_LOCATION.length() + 2;
            int end = include.indexOf(_QUOTE, start);
            String includeFile = this._includeRoot + _FORWARD_SLASH + include.substring(start, end);
            List<String> fileContent = this._getFileContents(includeFile);
            ArrayList<String> modifiedFileContent = new ArrayList<String>();
            for (String line : fileContent) {
                if (line.matches(_XSD_FILE_HEADER)) continue;
                modifiedFileContent.add(line);
            }
            modifiedFileContent.add(_CLOSING_INCLUDE_TAG);
            String modI = include.replace(_TERMINATED_TAG, _GREATER_THAN);
            expandedFile.set(fileIndex, modI);
            expandedFile.addAll(fileIndex + 1, modifiedFileContent);
            fileIndex += modifiedFileContent.size();
        }
        this._writeOut(expandedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _getFileContents(String fileName) {
        BufferedReader in = null;
        ArrayList<String> buff = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                buff.add(line);
                line = in.readLine();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening input file: " + fileName);
        }
        catch (Exception e) {
            System.out.println("Error while reading input file contents.");
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                System.out.println("Error closing BufferedReader.");
            }
        }
        return buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeOut(List<String> fileContent) {
        OutputStreamWriter out = null;
        try {
            out = new FileWriter(this._outputFile);
            for (String line : fileContent) {
                out.write(line);
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            System.out.println("Error opening output file.");
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception e) {
                System.out.println("Error flushing FileWriter.");
            }
            try {
                out.close();
            }
            catch (Exception e) {
                System.out.println("Error closing FileWriter.");
            }
        }
    }
}

