/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.audit.transform;

import java.util.Set;
import oracle.adfdt.model.ide.navigator.nodes.DataControlConfigurationNode;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.amx.dt.editor.AmxAddIdModelAdapter;
import oracle.adfmf.amx.skins.ADFMobileSkinsNode;
import oracle.adfmf.amx.skins.SkinsAddIdModelAdapter;
import oracle.adfmf.common.AddIdModelAdapter;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.editor.ApplicationAddIdModelAdapter;
import oracle.adfmf.framework.dt.editor.FrameworkXmlEditorConstants;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.adfmf.framework.dt.editor.feature.FeatureAddIdModelAdapter;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.AbstractModel;
import oracle.ide.model.Node;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public final class AddIdTransform
extends Transform {
    public AddIdTransform() {
        super((TransformAdapter)new XmlTransformAdapter());
    }

    public boolean isApplicable(XmlTransformContext ctx, Element element) {
        return !FrameworkXmlEditorConstants.isFeatureReferenceElement(element);
    }

    public boolean isApplicable(XmlTransformContext ctx, Attr attr) {
        return !FrameworkXmlEditorConstants.isFeatureReferenceElement(attr.getOwnerElement());
    }

    public void apply(XmlTransformContext ctx, Attr attr) throws Exception {
        this.apply(ctx, attr.getOwnerElement());
    }

    public void apply(XmlTransformContext ctx, Element element) throws Exception {
        final Node node = ctx.getModel().getNode();
        if (node == null) {
            return;
        }
        AddIdModelAdapter addIdAdapter = null;
        if (node instanceof FrameworkXmlSourceNode) {
            addIdAdapter = new ApplicationAddIdModelAdapter();
        } else if (node instanceof FeatureXmlSourceNode) {
            addIdAdapter = new FeatureAddIdModelAdapter(ctx.getWorkspace());
        } else if (node instanceof ADFMobileSkinsNode) {
            addIdAdapter = new SkinsAddIdModelAdapter();
        } else if (node instanceof AMXSourceNode) {
            addIdAdapter = new AmxAddIdModelAdapter();
        } else if (node instanceof DataControlConfigurationNode) {
            addIdAdapter = new AddIdModelAdapter(){

                @Override
                protected boolean isNodeSupported(XMLSourceNode xmlSourceNode) {
                    return node instanceof DataControlConfigurationNode;
                }
            };
        }
        if (addIdAdapter != null && !((AddIdModelAdapter)addIdAdapter).isExcludedElement(element)) {
            Set<String> ids = XmlUtils.gatherIds((AbstractModel)ctx.getXmlModel());
            addIdAdapter.populateId(element, ids);
        }
    }
}

