/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.audit.analyzer;

import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class NamespaceAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.adfmf.invalid-namespace")
    private Rule _invalidNamespaceRule;

    public void enter(AuditContext context, Document document) {
        if (this._invalidNamespaceRule.isEnabled() && document != null && document.getDocumentElement() != null) {
            NamedNodeMap attributes = document.getDocumentElement().getAttributes();
            for (int index = 0; index < attributes.getLength(); ++index) {
                String namespace;
                Attr attr = (Attr)attributes.item(index);
                String attrName = attr.getName();
                if (!attrName.startsWith("xmlns") || !MobileResourceUtils.isOldNamespace(namespace = attr.getValue())) continue;
                ViolationReport violationReport = context.report(this._invalidNamespaceRule, (Object)attr);
                violationReport.addParameter(null, (Object)namespace);
                violationReport.addParameter(null, (Object)MobileResourceUtils.getNewNamespace(namespace));
            }
        }
        this.setEnabled(false);
    }

    public boolean isApplicationContentSupported() {
        return true;
    }
}

