/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.audit.analyzer;

import java.net.URL;
import java.util.HashSet;
import oracle.adfdt.model.ide.navigator.nodes.DataControlConfigurationNode;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.amx.skins.ADFMobileSkinsNode;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.editor.FrameworkXmlEditorConstants;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class IdAnalyzer
extends Analyzer {
    private XmlMetadataResolver _xmlResolver;
    private HashSet<String> _seenIdsSet;
    @ExtensionResource(value="oracle.adfmf.error-duplicate-id-found")
    private Rule _errorDuplicateIdFoundRule;
    @ExtensionResource(value="oracle.adfmf.error-empty-id-found")
    private Rule _errorNoIdFoundRule;
    @ExtensionResource(value="oracle.adfmf.warning-empty-id-found")
    private Rule _warningNoIdFoundRule;

    public void enter(AuditContext context, Document document) {
        Node node = context.getModel().getNode();
        if (node == null) {
            return;
        }
        if (this.isMobile(node, context.getWorkspace())) {
            JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)context.getIdeContext());
            this._xmlResolver = xmlContext.getModel().getXmlMetadataResolver();
            if (this._seenIdsSet == null) {
                this._seenIdsSet = new HashSet();
            } else {
                this._seenIdsSet.clear();
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void enter(AuditContext context, Element element) {
        ViolationReport report;
        Rule rule;
        if ("springboardFeatureReference".equals(element.getLocalName())) {
            return;
        }
        String id = element.getAttributeNS(null, "id");
        if (id != null && !(id = id.trim()).isEmpty()) {
            if (this._seenIdsSet.contains(id.toLowerCase())) {
                rule = this.getDuplicateIdRule(element);
                if (rule.isEnabled()) {
                    report = context.report(rule, (Object)element.getAttributeNodeNS(null, "id"));
                    report.addParameter("message", this.getDuplicateIdMessage(element));
                }
            } else {
                this._seenIdsSet.add(id.toLowerCase());
            }
        }
        if ((id == null || id.isEmpty()) && XmlUtils.isAttributeSupported(this._xmlResolver, element, "id") && (rule = this.getNoIdRule(element)).isEnabled()) {
            report = context.report(rule, (Object)element);
            report.addParameter("message", this.getNoIdMessage(element));
        }
    }

    public void exit(AuditContext context, Document document) {
        this._xmlResolver = null;
    }

    public boolean isApplicationContentSupported() {
        return true;
    }

    private boolean isMobile(Node node, Workspace workspace) {
        URL applicationXmlUrl;
        if (node instanceof FrameworkXmlSourceNode || node instanceof FeatureXmlSourceNode || node instanceof AMXSourceNode || node instanceof ADFMobileSkinsNode) {
            return true;
        }
        return node instanceof DataControlConfigurationNode && URLFileSystem.exists((URL)(applicationXmlUrl = McAppUtils.getApplicationXmlURL(workspace)));
    }

    private Rule getDuplicateIdRule(Element element) {
        return this._errorDuplicateIdFoundRule;
    }

    private Rule getNoIdRule(Element element) {
        if (XmlUtils.isAttributeRequired(this._xmlResolver, element, "id")) {
            return this._errorNoIdFoundRule;
        }
        return this._warningNoIdFoundRule;
    }

    private Object getDuplicateIdMessage(Element element) {
        String elemName = element.getLocalName();
        if (FrameworkXmlEditorConstants.isFeatureReferenceElement(element)) {
            return MobileResourceUtils.getText("DUPLICATE_FEATURE_REFERENCE_ID_FOUND");
        }
        return MobileResourceUtils.getText("DUPLICATE_ID_FOUND", elemName);
    }

    private Object getNoIdMessage(Element element) {
        String elemName = element.getLocalName();
        if (FrameworkXmlEditorConstants.isFeatureReferenceElement(element)) {
            return MobileResourceUtils.getText("NO_FEATURE_REFERENCE_ID_FOUND");
        }
        return MobileResourceUtils.getText("NO_ID_FOUND", elemName);
    }
}

