/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LabeledTextFieldDocument
extends PlainDocument {
    private static final int TEXT_CTRL_NO_MAX_LENGTH = 0;
    private final int maxLen;
    private final boolean upperCaseOnly;
    private final boolean alphaNumericalCharactersOnly;
    private boolean ignoreRules;
    private static final String NON_ALPHA_NUMERIC_CHAR_REGULAR_EXPRESS = "[^a-zA-Z0-9]";

    public LabeledTextFieldDocument(int maxLen, boolean upperCaseOnly, boolean alphaNumericalCharactersOnly) {
        this.maxLen = maxLen;
        this.upperCaseOnly = upperCaseOnly;
        this.alphaNumericalCharactersOnly = alphaNumericalCharactersOnly;
        this.ignoreRules = false;
    }

    @Override
    public void insertString(int offset, String text, AttributeSet attributeSet) throws BadLocationException {
        if (null == text) {
            return;
        }
        if (this.ignoreRules) {
            super.insertString(offset, text, attributeSet);
            return;
        }
        if (this.maxLen != 0 && this.getLength() + text.length() > this.maxLen) {
            return;
        }
        if (this.alphaNumericalCharactersOnly && text.matches(NON_ALPHA_NUMERIC_CHAR_REGULAR_EXPRESS)) {
            return;
        }
        if (this.upperCaseOnly) {
            text = text.toUpperCase();
        }
        super.insertString(offset, text, attributeSet);
    }

    public void setIgnoreRules(boolean ignoreRules) {
        this.ignoreRules = ignoreRules;
    }
}

