/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ModelUtil;

public class DelayedListComboBox
extends JComboBox {
    private final transient ListCreator _listCreator;
    private final transient ProgressMonitorProperties _progressMonitorProperties;
    private final transient DelayedListPopupMenuListener _delayedListPopupMenuListener;
    private final Component _uiParent;
    private static final long serialVersionUID = 1L;

    public DelayedListComboBox(Component uiParent, ProgressMonitorProperties progressMonitorProperties, ListCreator listCreator) throws IllegalArgumentException {
        if (null == listCreator || null == uiParent || null == progressMonitorProperties) {
            throw new IllegalArgumentException();
        }
        this._progressMonitorProperties = new ProgressMonitorProperties(progressMonitorProperties.getUiParent(), progressMonitorProperties.getMonitorTitle(), progressMonitorProperties.getMonitorMessage(), progressMonitorProperties.getMonitorNote(), progressMonitorProperties.getCancelMonitorMessage());
        this._progressMonitorProperties.setMillisToBeVisible(progressMonitorProperties.getMillisToBeVisible());
        this._progressMonitorProperties.setMillisToPopup(progressMonitorProperties.getMillisToPopup());
        this._progressMonitorProperties.setMillisToSleep(progressMonitorProperties.getMillisToSleep());
        this._listCreator = listCreator;
        this._uiParent = uiParent;
        this._delayedListPopupMenuListener = new DelayedListPopupMenuListener();
        this.addPopupMenuListener(this._delayedListPopupMenuListener);
    }

    private final class GetListValuesWorker
    extends SwingWorker<GetListValuesReturn, Void>
    implements ChangeListener {
        private final IndeterminateProgressMonitor _progressMonitor;
        private final Runnable _uiTasksWhenDone;
        private final String _cancelMessage;
        private final long _millisToSleep;
        private final long _millisToBeVisible;

        public GetListValuesWorker(ProgressMonitorProperties monitorProperties, Runnable uiTasksWhenDone) throws IllegalArgumentException {
            if (null == uiTasksWhenDone || null == monitorProperties) {
                throw new IllegalArgumentException();
            }
            this._uiTasksWhenDone = uiTasksWhenDone;
            this._progressMonitor = new IndeterminateProgressMonitor(monitorProperties.getUiParent(), monitorProperties.getMonitorTitle(), (Object)monitorProperties.getMonitorMessage(), monitorProperties.getMonitorNote());
            this._progressMonitor.setMillisToPopup(monitorProperties.getMillisToPopup());
            this._millisToSleep = monitorProperties.getMillisToSleep();
            this._millisToBeVisible = monitorProperties.getMillisToBeVisible();
            this._cancelMessage = monitorProperties.getCancelMonitorMessage();
            if (ModelUtil.hasLength((String)this._cancelMessage)) {
                this._progressMonitor.addCancellationListener((ChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetListValuesReturn doInBackground() {
            boolean monitorCanceled = false;
            long startTimeMs = this._getCurrentTimeMs();
            ArrayList<String> completeList = new ArrayList<String>();
            try {
                this._progressMonitor.start();
                List<String> clientProvidedList = DelayedListComboBox.this._listCreator.createItemList(this._progressMonitor);
                if (null != clientProvidedList) {
                    completeList.addAll(clientProvidedList);
                }
                this._ensureDialogVisibleForMinimumTime(startTimeMs);
                monitorCanceled = this._progressMonitor.isCanceled();
            }
            finally {
                this._progressMonitor.finish();
            }
            return new GetListValuesReturn(monitorCanceled, completeList);
        }

        @Override
        public void done() {
            super.done();
            this._uiTasksWhenDone.run();
        }

        private void _ensureDialogVisibleForMinimumTime(long startTimeMs) {
            long popupTimeMs = this._progressMonitor.getMillisToPopup();
            if (!this._progressMonitor.isCanceled() && popupTimeMs < this._getCurrentTimeMs() - startTimeMs) {
                this._progressMonitor.removeCancellationListener((ChangeListener)this);
                long elapsedTimeMs = this._getCurrentTimeMs() - (startTimeMs + popupTimeMs);
                while (!this._progressMonitor.isCanceled() && elapsedTimeMs < this._millisToBeVisible) {
                    try {
                        Thread.sleep(this._millisToSleep);
                        elapsedTimeMs = this._getCurrentTimeMs() - (startTimeMs + popupTimeMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this._progressMonitor.getPanel().setNote(this._cancelMessage);
        }

        private long _getCurrentTimeMs() {
            return Calendar.getInstance().getTimeInMillis();
        }
    }

    private static final class GetListValuesReturn {
        private final List<String> _list;
        private final boolean _monitorCanceled;

        public GetListValuesReturn(boolean monitorCanceled, List<String> comboBoxList) {
            this._list = new ArrayList<String>(comboBoxList);
            this._monitorCanceled = monitorCanceled;
        }

        public List<String> getList() {
            return new ArrayList<String>(this._list);
        }

        public boolean getIsMonitorCanceled() {
            return this._monitorCanceled;
        }
    }

    private final class DelayedListPopupMenuListener
    implements PopupMenuListener {
        private GetListValuesWorker _getListValuesWorker = null;

        private DelayedListPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent menuPopupEvent) {
            DelayedListComboBox.this.removePopupMenuListener(DelayedListComboBox.this._delayedListPopupMenuListener);
            DelayedListComboBox.this._uiParent.setCursor(Cursor.getPredefinedCursor(3));
            Runnable listUpdateRunable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object comboListObject = DelayedListPopupMenuListener.this._getListValuesWorker.get();
                        if (null == comboListObject) {
                            return;
                        }
                        assert (comboListObject instanceof GetListValuesReturn);
                        GetListValuesReturn returnValue = (GetListValuesReturn)comboListObject;
                        if (!returnValue.getIsMonitorCanceled()) {
                            List<String> fullItemList = returnValue.getList();
                            DelayedListComboBox.this._listCreator.setItemList(fullItemList);
                            DelayedListComboBox.this.showPopup();
                        } else {
                            DelayedListComboBox.this.addPopupMenuListener(DelayedListComboBox.this._delayedListPopupMenuListener);
                        }
                    }
                    catch (Exception e) {
                        DelayedListComboBox.this.addPopupMenuListener(DelayedListComboBox.this._delayedListPopupMenuListener);
                    }
                    finally {
                        DelayedListComboBox.this._uiParent.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this._getListValuesWorker = new GetListValuesWorker(DelayedListComboBox.this._progressMonitorProperties, listUpdateRunable);
            this._getListValuesWorker.execute();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent menuPopupEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent menuPopupEvent) {
        }
    }

    public static final class ProgressMonitorProperties {
        private final Component _uiParent;
        private final String _monitorTitle;
        private final String _monitorMessage;
        private final String _monitorNote;
        private int _millisToPopup;
        private int _millisToBeVisible;
        private int _millisToSleep;
        private final String _cancelMonitorMessage;
        private static final int _DEFAULT_POPUP_WAIT_TIME_MS = 0;
        private static final int _DEFAULT_MINIMUM_PROGRESS_MONITOR_DIALOG_VISIBLILITY_MS = 1000;
        private static final int _DEFAULT_MILLIS_TO_SLEEP = 100;

        public ProgressMonitorProperties(Component uiParent, String monitorTitle, String monitorMessage, String monitorNote, String cancelMonitorMessage) throws IllegalArgumentException {
            if (null == uiParent || !ModelUtil.hasLength((String)monitorTitle) || !ModelUtil.hasLength((String)monitorMessage) || null == monitorNote || null == cancelMonitorMessage) {
                throw new IllegalArgumentException();
            }
            this._uiParent = uiParent;
            this._monitorTitle = monitorTitle;
            this._monitorMessage = monitorMessage;
            this._monitorNote = monitorNote;
            this._cancelMonitorMessage = cancelMonitorMessage;
            this._millisToPopup = 0;
            this._millisToBeVisible = 1000;
            this._millisToSleep = 100;
        }

        public Component getUiParent() {
            return this._uiParent;
        }

        public String getMonitorTitle() {
            return this._monitorTitle;
        }

        public String getMonitorMessage() {
            return this._monitorMessage;
        }

        public String getMonitorNote() {
            return this._monitorNote;
        }

        public int getMillisToPopup() {
            return this._millisToPopup;
        }

        public void setMillisToPopup(int millisToPopup) throws IllegalArgumentException {
            if (0 > millisToPopup) {
                throw new IllegalArgumentException();
            }
            this._millisToPopup = millisToPopup;
        }

        public String getCancelMonitorMessage() {
            return this._cancelMonitorMessage;
        }

        public void setMillisToBeVisible(int millisToBeVisible) {
            if (0 > millisToBeVisible) {
                throw new IllegalArgumentException();
            }
            this._millisToBeVisible = millisToBeVisible;
        }

        public int getMillisToBeVisible() {
            return this._millisToBeVisible;
        }

        public void setMillisToSleep(int millisToSleep) throws IllegalArgumentException {
            if (0 > millisToSleep) {
                throw new IllegalArgumentException();
            }
            this._millisToSleep = millisToSleep;
        }

        public int getMillisToSleep() {
            return this._millisToSleep;
        }
    }

    public static interface ListCreator {
        public List<String> createItemList(IndeterminateProgressMonitor var1);

        public void setItemList(List<String> var1);
    }
}

