/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import oracle.adfmf.common.DelayedListComboBox;
import oracle.adfmf.common.LabeledTextFieldDocument;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ComponentWithHint;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public class ControlGroupPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private int m_leftIndentPixelLen = 0;
    private int m_topIndentPixelLen = 0;
    private int m_bottomIndentPixelLen = 6;
    private double m_weightX = 0.0;

    public ControlGroupPanel() {
        this.setLayout(new GridBagLayout());
    }

    public JRadioButton addRadioButton(String buttonLabel, boolean selected, int gridColumn, int gridRow) {
        JRadioButton button = new JRadioButton(buttonLabel, selected);
        ResourceUtils.resButton((AbstractButton)button, (String)buttonLabel);
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, 0, 1, 1.0, 0.0, 22, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(button, constraints);
        return button;
    }

    public JTextField addLabeledTextField(String label, int maxLength, int gridColumn, int gridRow, boolean upperCaseOnly, boolean alignVertically, boolean alphaNumericalCharactersOnly) {
        JTextField textField = new JTextField();
        JLabel labelForTextField = new JLabel(label);
        textField.setDocument(new LabeledTextFieldDocument(maxLength, upperCaseOnly, alphaNumericalCharactersOnly));
        ResourceUtils.resLabel((JLabel)labelForTextField, (Component)textField, (String)label);
        this.addToPanel(labelForTextField, alignVertically ? 0 : 1, textField, alignVertically ? 0 : 1, gridColumn, gridRow, alignVertically);
        return textField;
    }

    public JTextField addLabeledTextField(String label, int maxLength, int gridColumn, int gridRow, boolean upperCaseOnly, boolean alignVertically) {
        return this.addLabeledTextField(label, maxLength, gridColumn, gridRow, upperCaseOnly, alignVertically, false);
    }

    public JCheckBox addCheckbox(String checkBoxLabel, int gridColumn, int gridRow, boolean selected) {
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, 1, 1, this.m_weightX, 0.0, 22, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        JCheckBox checkBox = new JCheckBox(checkBoxLabel, selected);
        ResourceUtils.resButton((AbstractButton)checkBox, (String)checkBoxLabel);
        this.add(checkBox, constraints);
        return checkBox;
    }

    public JComboBox addComboBox(Object[] comboBoxItems, int gridColumn, int gridRow) {
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, 1, 1, this.m_weightX, 0.0, 21, 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        JComboBox<Object> comboBox = new JComboBox<Object>(comboBoxItems);
        this.add(comboBox, constraints);
        return comboBox;
    }

    public JPasswordField addLabeledPasswordTextField(String passwordFieldLabel, int maxLength, int gridColumn, int gridRow, boolean alignVertically) {
        JPasswordField passwordTextField = new JPasswordField();
        passwordTextField.setDocument(new LabeledTextFieldDocument(maxLength, false, false));
        JLabel labelForTextField = new JLabel(passwordFieldLabel);
        ResourceUtils.resLabel((JLabel)labelForTextField, (Component)passwordTextField, (String)passwordFieldLabel);
        this.addToPanel(labelForTextField, alignVertically ? 0 : 1, passwordTextField, alignVertically ? 0 : 1, gridColumn, gridRow, alignVertically);
        return passwordTextField;
    }

    public JComboBox addLabeledComboBox(String sLabelText, Object[] sArComboBoxItems, int gridColumn, int gridRow, boolean makeEditable) {
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, 1, 1, 0.0, 0.0, 21, 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        JLabel label = new JLabel(sLabelText);
        JComboBox<Object> comboBox = null;
        comboBox = null != sArComboBoxItems ? new JComboBox<Object>(sArComboBoxItems) : new JComboBox();
        ResourceUtils.resLabel((JLabel)label, comboBox, (String)sLabelText);
        comboBox.setEditable(makeEditable);
        this.add(label, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.left = 8;
        this.add(comboBox, constraints);
        return comboBox;
    }

    public JComboBox addLabeledComboBox(String sLabelText, Object[] sArComboBoxItems, int gridColumn, int gridRow) {
        return this.addLabeledComboBox(sLabelText, sArComboBoxItems, gridColumn, gridRow, false);
    }

    public JWrappedLabel addJWrappedLabel(String labelText, int gridColumn, int gridRow, int gridWidth, boolean fillHorizontally) {
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, gridWidth, 1, 1.0, 0.0, 22, fillHorizontally ? 2 : 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        JWrappedLabel label = new JWrappedLabel(labelText);
        this.add((Component)label, constraints);
        return label;
    }

    private void addToPanel(JLabel textFieldLabel, int labelWidth, JTextField textField, int textFieldWidth, int gridX, int gridY, boolean alignVertically) {
        double weightx = this.m_weightX;
        if (alignVertically) {
            weightx = 1.0;
        }
        GridBagConstraints constraints = this.gbc(gridX, gridY, labelWidth, 1, weightx, 0.0, 17, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(textFieldLabel, constraints);
        constraints.gridwidth = textFieldWidth;
        if (alignVertically) {
            ++constraints.gridy;
        } else {
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.insets.set(0, 8, 6, 0);
        }
        this.add(textField, constraints);
    }

    private void addTextFieldWithHintToPanel(JLabel textFieldLabel, String hint, int labelWidth, JTextField textField, int textFieldWidth, int gridX, int gridY, boolean alignVertically) {
        double weightx = this.m_weightX;
        if (alignVertically) {
            weightx = 1.0;
        }
        GridBagConstraints constraints = this.gbc(gridX, gridY, labelWidth, 1, weightx, 0.0, 17, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(textFieldLabel, constraints);
        constraints.gridwidth = textFieldWidth;
        if (alignVertically) {
            ++constraints.gridy;
        } else {
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.insets.set(0, 8, 6, 0);
        }
        ComponentWithHint compWHint = new ComponentWithHint((Component)textField, hint);
        this.add((Component)compWHint, constraints);
    }

    public TitledSeparator addLabeledSeparator(String separatorTitle, int gridX, int gridY) {
        TitledSeparator hSeparator = new TitledSeparator(separatorTitle);
        GridBagConstraints constraints = this.gbc(gridX, gridY, 0, 1, 0.0, this.m_weightX, 21, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add((Component)hSeparator, constraints);
        return hSeparator;
    }

    public RichHintLabel addHintLabel(String hintText, int gridX, int gridY, int gridWidth) {
        RichHintLabel hintLabel = new RichHintLabel();
        hintLabel.setHtmlText(hintText);
        GridBagConstraints constraints = this.gbc(gridX, gridY, gridWidth, 1, this.m_weightX, 0.0, 17, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add((Component)hintLabel, constraints);
        return hintLabel;
    }

    public void setLeftIndentPixelSize(int leftIndentPixelLen) {
        this.m_leftIndentPixelLen = leftIndentPixelLen;
    }

    public void setTopIndentPixelSize(int topIndentPixelLen) {
        this.m_topIndentPixelLen = topIndentPixelLen;
    }

    public void setBottomIndentPixelSize(int bottomIndentPixelLen) {
        this.m_bottomIndentPixelLen = bottomIndentPixelLen;
    }

    public void setWeightX(double weightX) {
        this.m_weightX = weightX;
    }

    public JButton addButton(int gridX, int gridY, String label) {
        JButton button = new JButton();
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        GridBagConstraints constraints = this.gbc(gridX, gridY, 1, 1, this.m_weightX, 0.0, 17, 0, new Insets(0, 8, 6, 0));
        this.add(button, constraints);
        return button;
    }

    public JButton addIconButtonWithToolTip(int gridX, int gridY, Icon icon, String toolTipText) {
        JButton button = new JButton();
        Border buttonBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        IconicButtonUI.install((AbstractButton)button);
        button.setContentAreaFilled(false);
        button.setBorder(buttonBorder);
        button.setIcon(icon);
        button.setToolTipText(toolTipText);
        GridBagConstraints constraints = this.gbc(gridX, gridY, 1, 1, this.m_weightX, 0.0, 17, 0, new Insets(0, 8, this.m_bottomIndentPixelLen, 0));
        this.add(button, constraints);
        return button;
    }

    public JButton addButton(int gridX, int gridY, Icon icon) {
        return this.addIconButtonWithToolTip(gridX, gridY, icon, MobileResourceUtils.getText("BROWSE_ICON_LABEL"));
    }

    public JButton addImageIconButtonWithToolTip(ImageIcon image, Border border, int gridX, int gridY, String toolTipText) {
        JButton button = this.addButton(gridX, gridY, image);
        button.setBorder(border);
        button.setContentAreaFilled(true);
        button.setBorderPainted(true);
        button.setToolTipText(toolTipText);
        return button;
    }

    public void addPanel(ControlGroupPanel ctrlPanel, int gridX, int gridY) {
        GridBagConstraints constraints = this.gbc(gridX, gridY, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add((Component)((Object)ctrlPanel), constraints);
    }

    public JSpinner addLabeledNumberSpinner(String label, SpinnerNumberModel spinnerModel, int gridWidth, int padX, int gridX, int gridY) {
        JSpinner numberSpinner = new JSpinner(spinnerModel);
        JLabel labelForSpinner = new JLabel(label);
        ResourceUtils.resLabel((JLabel)labelForSpinner, (Component)numberSpinner.getEditor(), (String)label);
        GridBagConstraints constraints = this.gbc(gridX, gridY, gridWidth, 1, 0.0, 0.0, 21, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(labelForSpinner, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.set(0, 8, 6, 0);
        constraints.ipadx = padX;
        constraints.fill = 0;
        constraints.anchor = 17;
        this.add(numberSpinner, constraints);
        return numberSpinner;
    }

    public TabbedWindow addTabbedWindow(List<String> tabTitleList, List<String> toolTipList, List<ControlGroupPanel> panelList, int gridX, int gridY) {
        TabbedWindow tabbedWindow = new TabbedWindow();
        int index = 0;
        if (null == tabTitleList || null == panelList || tabTitleList.size() != panelList.size()) {
            throw new IllegalArgumentException();
        }
        if (null != toolTipList && toolTipList.size() != panelList.size()) {
            throw new IllegalArgumentException();
        }
        for (ControlGroupPanel currPanel : panelList) {
            if (null != toolTipList) {
                tabbedWindow.add(tabTitleList.get(index), null, (Component)((Object)currPanel), toolTipList.get(index), null);
            } else {
                tabbedWindow.add(tabTitleList.get(index), null, (Component)((Object)currPanel), null, null);
            }
            ++index;
        }
        GridBagConstraints constraints = this.gbc(gridX, gridY, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        tabbedWindow.setActive((Component)((Object)panelList.get(0)));
        this.add((Component)tabbedWindow, constraints);
        return tabbedWindow;
    }

    public final void addGlue(int gridX, int gridY) {
        this.add(Box.createGlue(), this.gbc(gridX, gridY, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }

    public final void addVerticalStrut(int gridX, int gridY, int height) {
        this.add(Box.createVerticalStrut(height), this.gbc(gridX, gridY, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }

    public JList addLabeledJList(int gridX, int gridY, int gridWidth, String listLabel, String[] listElementArray, int listPixelWidth, int listPixelHeight, Color listBorderColor, int selectionMode) {
        JList<String> jList = new JList<String>(listElementArray);
        jList.setSelectionMode(selectionMode);
        jList.setMinimumSize(new Dimension(listPixelWidth, listPixelHeight));
        jList.setMaximumSize(new Dimension(listPixelWidth, listPixelHeight));
        jList.setPreferredSize(new Dimension(listPixelWidth, listPixelHeight));
        Border border = BorderFactory.createLineBorder(listBorderColor);
        jList.setBorder(border);
        JLabel labelForJList = new JLabel(listLabel);
        ResourceUtils.resLabel((JLabel)labelForJList, jList, (String)listLabel);
        GridBagConstraints constraints = this.gbc(gridX, gridY, gridWidth, 1, this.m_weightX, 0.0, 17, 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(labelForJList, constraints);
        ++constraints.gridy;
        this.add(jList, constraints);
        return jList;
    }

    public JList addScrollableLabeledObjectJList(int gridX, int gridY, int gridWidth, String listLabel, Object[] listElementArray, int listPixelWidth, int listPixelHeight, Color listBorderColor, int selectionMode) {
        JList<Object> jList = new JList<Object>(listElementArray);
        jList.setSelectionMode(selectionMode);
        jList.setMinimumSize(new Dimension(listPixelWidth, listPixelHeight));
        jList.setMaximumSize(new Dimension(listPixelWidth, listPixelHeight));
        jList.setPreferredSize(new Dimension(listPixelWidth, listPixelHeight));
        Border border = BorderFactory.createLineBorder(listBorderColor);
        jList.setBorder(border);
        JLabel labelForJList = new JLabel(listLabel);
        ResourceUtils.resLabel((JLabel)labelForJList, jList, (String)listLabel);
        GridBagConstraints constraints = this.gbc(gridX, gridY, gridWidth, 1, this.m_weightX, 0.0, 17, 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        this.add(labelForJList, constraints);
        ++constraints.gridy;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(jList);
        this.add(scrollPane, constraints);
        return jList;
    }

    public CompletionTextField addLabeledCompletionTextField(String label, String hint, int labelWidth, int textFieldWidth, int maxLength, int gridColumn, int gridRow, boolean upperCaseOnly, boolean alignVertically, boolean alphaNumericalCharactersOnly) {
        JLabel labelForTextField = new JLabel(label);
        CompletionTextField textField = new CompletionTextField();
        textField.setDocument((Document)new LabeledTextFieldDocument(maxLength, upperCaseOnly, alphaNumericalCharactersOnly));
        ResourceUtils.resLabel((JLabel)labelForTextField, (Component)textField, (String)label);
        if (ModelUtil.hasLength((String)hint)) {
            this.addTextFieldWithHintToPanel(labelForTextField, hint, labelWidth, (JTextField)textField, textFieldWidth, gridColumn, gridRow, alignVertically);
        } else {
            this.addToPanel(labelForTextField, labelWidth, (JTextField)textField, textFieldWidth, gridColumn, gridRow, alignVertically);
        }
        return textField;
    }

    public DelayedListComboBox addLabeledDelayedListComboBox(String labelText, int gridColumn, int gridRow, Component uiParent, DelayedListComboBox.ProgressMonitorProperties progressMonitorProperties, DelayedListComboBox.ListCreator listCreator, boolean editable) {
        GridBagConstraints constraints = this.gbc(gridColumn, gridRow, 1, 1, 0.0, 0.0, 21, 0, new Insets(this.m_topIndentPixelLen, this.m_leftIndentPixelLen, this.m_bottomIndentPixelLen, 0));
        JLabel label = new JLabel(labelText);
        DelayedListComboBox comboBox = new DelayedListComboBox(uiParent, progressMonitorProperties, listCreator);
        comboBox.setEditable(editable);
        ResourceUtils.resLabel((JLabel)label, (Component)comboBox, (String)labelText);
        this.add(label, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.left = 8;
        this.add(comboBox, constraints);
        return comboBox;
    }
}

