/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adfmf.common.UniqueValueGenerator;
import oracle.adfmf.common.util.XmlUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AddIdModelAdapter
extends XmlModelAdapter {
    private static final String _TXN_NAME = "ADFMF populating unique id";

    public void modelChanged(XmlModelEvent event) {
        if (event == null) {
            return;
        }
        if (event.isInUndoOrRedo()) {
            return;
        }
        NodeChangeDetails nodeChangeDetails = event.getNodeChangeDetails();
        if (nodeChangeDetails == null || NodeChangeDetails.NO_DETAILS_AVAILABLE.equals(nodeChangeDetails)) {
            return;
        }
        AbstractModel model = event.getModel();
        JDevXmlContext context = (JDevXmlContext)model.getContext();
        XMLSourceNode sourceNode = context.getIdeDocument();
        if (!this.isNodeSupported(sourceNode)) {
            return;
        }
        Set<Node> addedNodes = this.getAddedNodes(nodeChangeDetails);
        if (addedNodes.isEmpty()) {
            return;
        }
        XmlMetadataResolver xmlResolver = model.getXmlMetadataResolver();
        final ArrayList<Element> toAddIdElements = new ArrayList<Element>();
        this.getElementsToAddId(addedNodes, toAddIdElements, xmlResolver);
        if (toAddIdElements.isEmpty()) {
            return;
        }
        final Set<String> ids = XmlUtils.gatherIds(model);
        new FixedNameTransactionTask(_TXN_NAME){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                for (Element elem : toAddIdElements) {
                    AddIdModelAdapter.this.populateId(elem, ids);
                }
            }
        }.run(model);
    }

    public void populateId(Element elem, Set<String> ids) {
        String id = this.generateUniqueId(elem, ids);
        elem.setAttributeNS(null, "id", id);
        ids.add(id);
    }

    public boolean isExcludedElement(Element elem) {
        return false;
    }

    protected abstract boolean isNodeSupported(XMLSourceNode var1);

    protected String generateUniqueId(Element elem, Set<String> ids) {
        String localName = elem.getLocalName();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < localName.length(); ++i) {
            char theChar = localName.charAt(i);
            if (i != 0 && !Character.isUpperCase(theChar)) continue;
            sb.append(Character.toLowerCase(theChar));
        }
        UniqueValueGenerator valueGenerator = new UniqueValueGenerator(sb.toString(), ids);
        return valueGenerator.getUniqueValue();
    }

    private boolean isNodeEligibleToAddId(Node node, XmlMetadataResolver xmlResolver) {
        return 1 == node.getNodeType() && !this.isExcludedElement((Element)node) && !((Element)node).hasAttributeNS(null, "id") && XmlUtils.isAttributeSupported(xmlResolver, (Element)node, "id");
    }

    private void getElementsToAddId(Set<Node> addedNodes, List<Element> addedElements, XmlMetadataResolver xmlResolver) {
        for (Node node : addedNodes) {
            NodeList childNodes;
            int numOfChildNodes;
            if (this.isNodeEligibleToAddId(node, xmlResolver)) {
                addedElements.add((Element)node);
            }
            if ((numOfChildNodes = (childNodes = node.getChildNodes()).getLength()) <= 0) continue;
            HashSet<Node> childAddedNodes = new HashSet<Node>(numOfChildNodes);
            for (int i = 0; i < numOfChildNodes; ++i) {
                childAddedNodes.add(childNodes.item(i));
            }
            this.getElementsToAddId(childAddedNodes, addedElements, xmlResolver);
        }
    }

    private Set<Node> getAddedNodes(NodeChangeDetails nodeChangeDetails) {
        Set addedNodes = nodeChangeDetails.getAddedNodes();
        Set removedNodes = nodeChangeDetails.getRemovedNodes();
        HashSet<Node> addedNodesCopy = new HashSet<Node>(addedNodes);
        if (!addedNodes.isEmpty() && !removedNodes.isEmpty()) {
            block0: for (Node addNode : addedNodes) {
                for (Node remNode : removedNodes) {
                    if (!remNode.isEqualNode(addNode)) continue;
                    addedNodesCopy.remove(addNode);
                    continue block0;
                }
            }
        }
        return addedNodesCopy;
    }
}

