/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.common.util.FileUtils;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.jdeveloper.el.ELType;
import oracle.jdeveloper.el.ELUtils;
import oracle.jdeveloper.el.Property;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.webapp.faces.backingfile.introspection.DesigntimeIntrospectionUtils;
import oracle.jdevimpl.webapp.faces.backingfile.introspection.PropertyDescriptor;

public final class AMXUtils {
    private static final String _BOOLEAN_TYPE_NAME = "boolean";
    private static final String _VOID_TYPE_NAME = "void";
    private static final String _GET_METHOD_PREFIX = "get";
    private static final String _HAS_METHOD_PREFIX = "has";
    private static final String _IS_METHOD_PREFIX = "is";
    private static List<String> _CLASS_LOADER_JARS = Arrays.asList("juel-api-2.2.4-SNAPSHOT.jar", "JavaFramework.jar");

    private AMXUtils() {
    }

    public static boolean isSupportedNode(Node node) {
        return node != null && node instanceof AMXSourceNode;
    }

    public static URLClassLoader getJavaFrameworkClassLoader() {
        URLClassLoader javaFrameworkClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(AMXUtils._getClassLoaderUrls(), AMXUtils.class.getClassLoader());
            }
        });
        return javaFrameworkClassLoader;
    }

    public static Set<Method> getPropertyMethods(URLClassLoader classLoader, String className, boolean getDeclaredMethods) {
        HashSet<Method> methodsSet = new HashSet<Method>();
        Method[] methods = null;
        try {
            Class<?> cls = Class.forName(className, true, classLoader);
            methods = getDeclaredMethods ? cls.getDeclaredMethods() : cls.getMethods();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (methods != null) {
            for (Method method : methods) {
                int modifiers = method.getModifiers();
                String methodName = method.getName();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || !(methodName.startsWith(_GET_METHOD_PREFIX) && methodName.length() > _GET_METHOD_PREFIX.length() || methodName.startsWith(_HAS_METHOD_PREFIX) && methodName.length() > _HAS_METHOD_PREFIX.length()) && (!methodName.startsWith(_IS_METHOD_PREFIX) || methodName.length() <= _IS_METHOD_PREFIX.length())) continue;
                methodsSet.add(method);
            }
        }
        return Collections.unmodifiableSet(methodsSet);
    }

    public static boolean isPropertyAccessor(Method method) {
        String methodName = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        if (returnType == null) {
            return false;
        }
        return methodName.startsWith(_HAS_METHOD_PREFIX) && methodName.length() > _HAS_METHOD_PREFIX.length() || methodName.startsWith(_IS_METHOD_PREFIX) && methodName.length() > _IS_METHOD_PREFIX.length() ? parameters.length == 0 && (returnType.getName().equals(_BOOLEAN_TYPE_NAME) || returnType.getName().equals(Boolean.class.getName())) : methodName.startsWith(_GET_METHOD_PREFIX) && methodName.length() > _GET_METHOD_PREFIX.length() && parameters.length == 0 && !returnType.getName().equals(_VOID_TYPE_NAME);
    }

    public static String getPropertyName(String methodName) {
        if (methodName.startsWith(_HAS_METHOD_PREFIX) && methodName.length() > _HAS_METHOD_PREFIX.length()) {
            return AMXUtils._convertPropertyName(methodName.substring(_HAS_METHOD_PREFIX.length()));
        }
        if (methodName.startsWith(_GET_METHOD_PREFIX) && methodName.length() > _GET_METHOD_PREFIX.length()) {
            return AMXUtils._convertPropertyName(methodName.substring(_GET_METHOD_PREFIX.length()));
        }
        if (methodName.startsWith(_IS_METHOD_PREFIX) && methodName.length() > _IS_METHOD_PREFIX.length()) {
            return AMXUtils._convertPropertyName(methodName.substring(_IS_METHOD_PREFIX.length()));
        }
        return methodName;
    }

    public static String[] getJavaTypesAsStrings(Class[] javaClasses) {
        String[] results = new String[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            if (javaClasses[i] == null) continue;
            results[i] = javaClasses[i].getName();
        }
        return results;
    }

    public static String getClassNameFromExpression(Context context, Object location, String expression) {
        String className = null;
        try {
            Property prop = ELUtils.getPropertyFromExpression((Context)context, (Object)location, (ELType)ELType.JSF, (String)expression);
            if (prop != null) {
                String dataHintType = prop.getComponentType();
                if (dataHintType == null) {
                    dataHintType = prop.getType();
                }
                if (dataHintType != null) {
                    className = dataHintType;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return className;
    }

    public static List<Object> getClassNameBasedAttributes(Project project, String className) {
        ArrayList<Object> classNameBasedAttributes = new ArrayList<Object>();
        if (className == null || "".equals(className)) {
            return classNameBasedAttributes;
        }
        try {
            PropertyDescriptor[] descriptors;
            JavaClass jotClass;
            JavaManager manager = JavaManager.getJavaManager((Project)project);
            if (manager != null && (jotClass = manager.getClass(className)) != null && (descriptors = DesigntimeIntrospectionUtils.getPropertyDescriptors((JavaClass)jotClass, (JavaManager)manager)) != null) {
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor pd = descriptors[i];
                    JavaMethod method = pd.getReadMethod();
                    if ("class".equals(pd.getName()) || pd.isExpert() || pd.isHidden() || method == null || method.getReturnType().isArray()) continue;
                    classNameBasedAttributes.add(pd.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classNameBasedAttributes;
    }

    private static String _convertPropertyName(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty()) {
            if (propertyName.length() < 3) {
                return propertyName.toLowerCase();
            }
            return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        }
        return propertyName;
    }

    private static URL[] _getClassLoaderUrls() {
        URL extFolderUrl = FileUtils.getSupportFilesDirectoryUrl();
        URL libFolderUrl = URLFactory.newDirURL((URL)extFolderUrl, (String)"lib");
        ArrayList<URL> classLoaderJarUrls = new ArrayList<URL>();
        for (String classLoaderJar : _CLASS_LOADER_JARS) {
            classLoaderJarUrls.add(URLFactory.newURL((URL)libFolderUrl, (String)classLoaderJar));
        }
        return classLoaderJarUrls.toArray(new URL[classLoaderJarUrls.size()]);
    }
}

