/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.skins.audit;

import java.net.URL;
import java.util.List;
import oracle.adfmf.amx.skins.ADFMobileSkinsNode;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.editor.ADFMobileConfigNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SkinAnalyzer
extends Analyzer {
    private List<org.w3c.dom.Node> _definedSkins = null;
    @ExtensionResource(value="oracle.adfmf.invalid-skin-family")
    private Rule _invalidSkinFamilyRule;
    @ExtensionResource(value="oracle.adfmf.invalid-skin-version")
    private Rule _invalidSkinVersionRule;

    public boolean isApplicationContentSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(AuditContext context, Document document) {
        Node node = context.getModel().getNode();
        if (!(node instanceof ADFMobileConfigNode)) {
            this.setEnabled(false);
            return;
        }
        Workspace workspace = context.getIdeContext().getWorkspace();
        Project project = McAppUtils.getApplicationControllerProject(workspace, null);
        if (project == null) {
            this.setEnabled(false);
            return;
        }
        ADFMobileSkinsNode skinsNode = McAppUtils.findOrCreateSkinsXml(project);
        if (skinsNode != null) {
            Context skinsContext = Context.newIdeContext((Node)skinsNode);
            skinsContext.setProject(project);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)skinsContext);
            XmlModel model = xmlContext.getModel();
            model.acquireReadLock();
            try {
                Document skinsDocument = model.getDocument();
                org.w3c.dom.Node adfmfSkinsNode = XmlUtils.getFirstNamedChildElement(skinsDocument, "http://xmlns.oracle.com/adf/mf/skin", "adfmf-skins");
                if (adfmfSkinsNode != null) {
                    this._definedSkins = XmlUtils.getNamedChildElements((Element)adfmfSkinsNode, "skin");
                }
            }
            finally {
                model.releaseReadLock();
            }
            URL skinsUrl = McAppUtils.getSkinsURL(project);
            if (skinsUrl != null) {
                FileDependency dependency = new FileDependency(skinsUrl, project, workspace);
                context.addDependency((Dependency)dependency);
            }
        }
    }

    public void exit(AuditContext context, Document document) {
        this._definedSkins = null;
    }

    public void enter(AuditContext context, Element element) {
        if (this._invalidSkinFamilyRule.isEnabled() && "skin-family".equals(element.getLocalName())) {
            this._validateSkinFamily(context, element);
        }
        if (this._invalidSkinVersionRule.isEnabled() && "skin-version".equals(element.getLocalName())) {
            this._validateSkinVersion(context, element);
        }
    }

    private void _validateSkinFamily(AuditContext context, Element element) {
        boolean isInvalidSkinFamily = false;
        String referencedFamily = element.getTextContent();
        if (!"mobileFusionFx".equals(referencedFamily)) {
            boolean bl = isInvalidSkinFamily = !this._findSkinNode(referencedFamily, null);
        }
        if (isInvalidSkinFamily) {
            ViolationReport violationReport = context.report(this._invalidSkinFamilyRule, (Object)element);
            violationReport.addParameter(null, (Object)referencedFamily);
        }
    }

    private void _validateSkinVersion(AuditContext context, Element element) {
        org.w3c.dom.Node parent;
        org.w3c.dom.Node skinFamilyNode;
        boolean isInvalidSkinVersion = true;
        String referencedVersion = element.getTextContent();
        if (referencedVersion != null && !referencedVersion.isEmpty() && (skinFamilyNode = XmlUtils.getFirstChildNode((Element)(parent = element.getParentNode()), "skin-family")) != null) {
            String skinFamilyName = skinFamilyNode.getTextContent();
            boolean bl = isInvalidSkinVersion = !this._findSkinNode(skinFamilyName, referencedVersion);
        }
        if (isInvalidSkinVersion) {
            ViolationReport violationReport = context.report(this._invalidSkinVersionRule, (Object)element);
            violationReport.addParameter(null, (Object)referencedVersion);
        }
    }

    private boolean _findSkinNode(String skinFamily, String skinVersion) {
        if (this._definedSkins == null || skinFamily == null || skinFamily.isEmpty()) {
            return false;
        }
        boolean matchSkinVersion = skinVersion != null && !skinVersion.isEmpty();
        for (org.w3c.dom.Node definedSkin : this._definedSkins) {
            String declaredFamily;
            org.w3c.dom.Node familyNode = XmlUtils.getFirstChildNode((Element)definedSkin, "family");
            if (familyNode == null || (declaredFamily = familyNode.getTextContent()) == null || !declaredFamily.equals(skinFamily) || matchSkinVersion && !this._findSkinVersionNode(definedSkin, skinVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean _findSkinVersionNode(org.w3c.dom.Node skinNode, String skinVersion) {
        String declaredVersionName;
        org.w3c.dom.Node nameNode;
        org.w3c.dom.Node versionNode;
        return skinNode != null && (versionNode = XmlUtils.getFirstChildNode((Element)skinNode, "version")) != null && (nameNode = XmlUtils.getFirstChildNode((Element)versionNode, "name")) != null && (declaredVersionName = nameNode.getTextContent()) != null && skinVersion.equals(declaredVersionName);
    }
}

