/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.skins;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.amx.dt.editor.PreviewEditor;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ADFMobileSkins {
    private static final Logger _logger = Logger.getLogger(PreviewEditor.class.getName());
    private String _defaultFamily;
    private String _defaultVersion;
    private final Workspace _workspace;
    private final Context _context;
    private Map<String, Map<String, ADFMobileSkin>> _skins = new HashMap<String, Map<String, ADFMobileSkin>>();
    private Map<String, ADFMobileSkin> _allSkins = new HashMap<String, ADFMobileSkin>();
    private Map<String, ADFMobileSkinAddition> _skinAdditions = new HashMap<String, ADFMobileSkinAddition>();
    private List<String> _orderedSkinIds = new ArrayList<String>();
    private static final String _NO_VERSION = "noversion";
    private static final String _NO_PLATFORM = "noplatform";
    private static final String _DEFAULT_VERSION = "defaultversion";
    private static final String _KEY_SEPERATOR = "__";

    public ADFMobileSkins(Context context) {
        this._context = context;
        this._workspace = context.getWorkspace();
        this._initialize();
    }

    public Stack<String> getSkinStylesheets(String model, String os) {
        ADFMobileSkinAddition skinAddition;
        Stack<String> stylesheets = new Stack<String>();
        ADFMobileSkin mobileSkin = null;
        if (model != null && !model.isEmpty()) {
            mobileSkin = this._getConfiguredSkin(model);
        }
        if (mobileSkin == null) {
            mobileSkin = this._getConfiguredSkin(os);
        }
        if (mobileSkin == null) {
            mobileSkin = this._getConfiguredSkin(null);
        }
        if (mobileSkin == null) {
            return stylesheets;
        }
        String skinId = mobileSkin.getSkinId();
        if (this._skinAdditions.containsKey(skinId) && (skinAddition = this._skinAdditions.get(skinId)).getSkinStylesheet() != null) {
            stylesheets.push(skinAddition.getSkinStylesheet());
        }
        if (mobileSkin.getSkinStylesheet() != null) {
            stylesheets.push(mobileSkin.getSkinStylesheet());
        }
        String currentSkinId = mobileSkin.getSkinParent();
        while (currentSkinId != null) {
            ADFMobileSkinAddition skinAddition2;
            if (this._skinAdditions.containsKey(currentSkinId) && (skinAddition2 = this._skinAdditions.get(currentSkinId)).getSkinStylesheet() != null) {
                stylesheets.push(skinAddition2.getSkinStylesheet());
            }
            if (this._allSkins.containsKey(currentSkinId)) {
                ADFMobileSkin currentSkin = this._allSkins.get(currentSkinId);
                if (currentSkin.getSkinStylesheet() != null) {
                    stylesheets.push(currentSkin.getSkinStylesheet());
                }
                currentSkinId = currentSkin.getSkinParent();
                continue;
            }
            _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00092", currentSkinId));
            break;
        }
        return stylesheets;
    }

    private void _initialize() {
        this._parseAdfMfConfig();
        this._parseAdfMfSkins();
        this._addDefaultSkinIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseAdfMfConfig() {
        URL mobileConfigUrl = McAppUtils.getMobileConfigURL(this._workspace);
        if (mobileConfigUrl == null) {
            _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00087"));
            return;
        }
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)this._context);
        XmlModel model = xmlContext.getRelatedXmlModel(mobileConfigUrl);
        if (model != null) {
            model.acquireReadLock();
            try {
                Element rootElement = model.getDocument().getDocumentElement();
                NodeList childNodes = rootElement.getChildNodes();
                if (childNodes != null) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if ("skin-family".equals(child.getLocalName())) {
                            this._defaultFamily = child.getTextContent();
                            continue;
                        }
                        if (!"skin-version".equals(child.getLocalName())) continue;
                        this._defaultVersion = child.getTextContent();
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseAdfMfSkins() {
        block16: {
            URL skinUrl = McAppUtils.getSkinsURL(McAppUtils.getApplicationControllerProject(this._workspace, _logger));
            if (skinUrl == null) {
                _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00088"));
                return;
            }
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)this._context);
            XmlModel model = xmlContext.getRelatedXmlModel(skinUrl);
            if (model != null) {
                model.acquireReadLock();
                try {
                    Element rootElement = model.getDocument().getDocumentElement();
                    NodeList childNodes = rootElement.getChildNodes();
                    if (childNodes == null) break block16;
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        NodeList skinAdditionNodes;
                        int index;
                        Node child = childNodes.item(i);
                        if ("skin".equals(child.getLocalName())) {
                            NodeList skinNodes = child.getChildNodes();
                            if (skinNodes == null) continue;
                            ADFMobileSkin skin = new ADFMobileSkin();
                            for (index = 0; index < skinNodes.getLength(); ++index) {
                                Node skinChild = skinNodes.item(index);
                                if ("id".equals(skinChild.getLocalName())) {
                                    skin.setSkinId(skinChild.getTextContent());
                                    continue;
                                }
                                if ("family".equals(skinChild.getLocalName())) {
                                    skin.setSkinFamily(skinChild.getTextContent());
                                    continue;
                                }
                                if ("extends".equals(skinChild.getLocalName())) {
                                    skin.setSkinParent(skinChild.getTextContent());
                                    continue;
                                }
                                if ("version".equals(skinChild.getLocalName())) {
                                    NodeList versionNodes = skinChild.getChildNodes();
                                    for (int vi = 0; vi < versionNodes.getLength(); ++vi) {
                                        Node versionChild = versionNodes.item(vi);
                                        if ("name".equals(versionChild.getLocalName())) {
                                            skin.setSkinVersion(versionChild.getTextContent());
                                            continue;
                                        }
                                        if (!"default".equals(versionChild.getLocalName())) continue;
                                        skin.setIsDefaultVersion(versionChild.getTextContent().equalsIgnoreCase("true"));
                                    }
                                    continue;
                                }
                                if (!"style-sheet-name".equals(skinChild.getLocalName())) continue;
                                skin.setSkinStylesheet(this._addAppControllerHtmlFolderPrefix(skinChild.getTextContent()));
                            }
                            this._addSkin(skin);
                            continue;
                        }
                        if (!"skin-addition".equals(child.getLocalName()) || (skinAdditionNodes = child.getChildNodes()) == null) continue;
                        ADFMobileSkinAddition skinAddition = new ADFMobileSkinAddition();
                        for (index = 0; index < skinAdditionNodes.getLength(); ++index) {
                            Node skinAdditionChild = skinAdditionNodes.item(index);
                            if ("skin-id".equals(skinAdditionChild.getLocalName())) {
                                skinAddition.setSkinId(skinAdditionChild.getTextContent());
                                continue;
                            }
                            if (!"style-sheet-name".equals(skinAdditionChild.getLocalName())) continue;
                            skinAddition.setSkinStylesheet(this._addAppControllerHtmlFolderPrefix(skinAdditionChild.getTextContent()));
                        }
                        this._skinAdditions.put(skinAddition.getSkinId(), skinAddition);
                    }
                }
                finally {
                    model.releaseReadLock();
                }
            }
        }
    }

    private String _addAppControllerHtmlFolderPrefix(String file) {
        URL appControllerUrl = McAppUtils.getProjectPublicHtmlDir(McAppUtils.getApplicationControllerProject(this._workspace, _logger));
        return URLFactory.newURL((URL)appControllerUrl, (String)file).toString();
    }

    private void _addSkin(ADFMobileSkin skin) {
        String skinId;
        String platformVersionKey;
        Map<String, ADFMobileSkin> familySkins;
        String platform;
        String family = skin.getSkinFamily();
        String version = skin.getSkinVersion();
        if (version == null) {
            version = _NO_VERSION;
        }
        if ((platform = skin.getSkinPlatform()) == null) {
            platform = _NO_PLATFORM;
        }
        if ((familySkins = this._skins.get(family)) == null) {
            familySkins = new HashMap<String, ADFMobileSkin>();
            this._skins.put(family, familySkins);
        }
        if (!familySkins.containsKey(platformVersionKey = platform + _KEY_SEPERATOR + version)) {
            familySkins.put(platformVersionKey, skin);
        }
        String platformDefVersionKey = platform + _KEY_SEPERATOR + _DEFAULT_VERSION;
        if (skin.getIsDefaultVersion() && !familySkins.containsKey(platformDefVersionKey)) {
            familySkins.put(platformDefVersionKey, skin);
        }
        if (!this._allSkins.containsKey(skinId = skin.getSkinId())) {
            this._allSkins.put(skinId, skin);
        }
        this._orderedSkinIds.add(skinId);
    }

    private boolean _skinExists(String skinId, String family) {
        Map<String, ADFMobileSkin> familySkins = this._skins.get(family);
        if (familySkins == null) {
            return false;
        }
        return familySkins.containsKey(skinId);
    }

    private String _createSkinId(String parent, String skinName) {
        if (parent == null) {
            return skinName;
        }
        return parent + "." + skinName;
    }

    private void _adddefaultFamilySkins(String platform) {
        String platformSkinId;
        String family = this._createSkinId(null, "mobileFusionFx");
        String familySkinId = family;
        if (!this._skinExists(familySkinId, family)) {
            ADFMobileSkin skin = new ADFMobileSkin(familySkinId);
            skin.setSkinFamily(family);
            this._addSkin(skin);
        }
        if (!this._skinExists(platformSkinId = this._createSkinId("mobileFusionFx", platform), family)) {
            ADFMobileSkin skin = new ADFMobileSkin(platformSkinId);
            skin.setSkinFamily(family);
            skin.setSkinParent(familySkinId);
            this._addSkin(skin);
        }
        for (String model : FormFactorsConstants.getPlatformModels(platform)) {
            String modelSkinId = this._createSkinId(familySkinId, model);
            if (this._skinExists(modelSkinId, family)) continue;
            ADFMobileSkin skin = new ADFMobileSkin(modelSkinId);
            skin.setSkinFamily(family);
            skin.setSkinParent(platformSkinId);
            this._addSkin(skin);
        }
    }

    private void _addDefaultSkinIds() {
        for (String platform : FormFactorsConstants.getPlatforms()) {
            this._adddefaultFamilySkins(platform);
        }
    }

    private ADFMobileSkin _getConfiguredSkin(String platform) {
        Map<String, ADFMobileSkin> skins = this._skins.get(this._defaultFamily);
        ADFMobileSkin mobileSkin = null;
        if (platform == null || platform.trim().isEmpty()) {
            platform = _NO_PLATFORM;
        }
        String defaultVersion = _DEFAULT_VERSION;
        if (this._defaultVersion != null) {
            defaultVersion = this._defaultVersion;
        }
        if (skins != null && !skins.isEmpty()) {
            mobileSkin = skins.get(platform + _KEY_SEPERATOR + defaultVersion);
        }
        if (_DEFAULT_VERSION.equals(defaultVersion) && mobileSkin == null) {
            for (String skinId : this._orderedSkinIds) {
                ADFMobileSkin skin;
                if (!skinId.endsWith(platform) || !this._defaultFamily.equals((skin = this._allSkins.get(skinId)).getSkinFamily())) continue;
                return skin;
            }
        }
        return mobileSkin;
    }

    private static final class ADFMobileSkinAddition {
        private String _skinId;
        private String _stylesheet;

        public void setSkinId(String id) {
            this._skinId = id;
        }

        public void setSkinStylesheet(String stylesheet) {
            this._stylesheet = stylesheet;
        }

        public String getSkinId() {
            return this._skinId;
        }

        public String getSkinStylesheet() {
            return this._stylesheet;
        }
    }

    private static final class ADFMobileSkin {
        private String _skinId;
        private String _skinVersion;
        private boolean _isDefault;
        private String _skinFamily;
        private String _skinParent;
        private String _stylesheet;

        public ADFMobileSkin() {
        }

        public ADFMobileSkin(String id) {
            this.setSkinId(id);
        }

        public void setSkinId(String id) {
            this._skinId = id;
        }

        public void setSkinVersion(String version) {
            this._skinVersion = version;
        }

        public void setIsDefaultVersion(boolean isDefault) {
            this._isDefault = isDefault;
        }

        public void setSkinFamily(String family) {
            this._skinFamily = family;
        }

        public void setSkinParent(String parent) {
            this._skinParent = parent;
        }

        public void setSkinStylesheet(String stylesheet) {
            this._stylesheet = stylesheet;
        }

        public String getSkinId() {
            return this._skinId;
        }

        public String getSkinPlatform() {
            if (this._skinId == null) {
                return null;
            }
            String[] parts = this._skinId.split("\\.");
            if (parts.length > 1) {
                return parts[parts.length - 1];
            }
            return null;
        }

        public String getSkinVersion() {
            return this._skinVersion;
        }

        public boolean getIsDefaultVersion() {
            return this._isDefault;
        }

        public String getSkinFamily() {
            return this._skinFamily;
        }

        public String getSkinParent() {
            return this._skinParent;
        }

        public String getSkinStylesheet() {
            return this._stylesheet;
        }
    }
}

