/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.dependency;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.adfdt.view.unified.id.ScopedId;
import oracle.adfdt.view.unified.id.ScopedIdContext;
import oracle.adfdt.view.unified.id.ScopedIdUtils;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdContext;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdTraversalHandler;
import oracle.adfmf.amx.dt.metadata.dependency.AMXScopedIdDeclaration;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.bali.xml.model.dependency.XmlReference;
import oracle.bali.xml.model.traversal.TraversalData;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMXScopedIdReference
extends XmlReference {
    private final String _scopedIdReference;

    public AMXScopedIdReference(XmlContext xmlContext, String scopedIdRef, Node node, int start, int end) {
        super(xmlContext, node, start, end);
        this._scopedIdReference = scopedIdRef;
    }

    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        return ValidationResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Declaration findDeclaration(DependencyContext context) {
        XmlContext xmlContext = this.getXmlContext(context);
        XmlModel model = xmlContext.getModel();
        model.acquireReadLock();
        try {
            TraversalData data = context.getTraversalData(xmlContext);
            Attr attr = (Attr)this.getNode(context);
            Map references = (Map)data.get((Object)"__scoped_id_references");
            if (references == null) {
                Declaration declaration = null;
                return declaration;
            }
            Collection idRefs = (Collection)references.get(attr);
            if (idRefs == null || idRefs.isEmpty()) {
                Declaration declaration = null;
                return declaration;
            }
            AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference idRef = null;
            for (AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference checkIdRef : idRefs) {
                if (!this._scopedIdReference.equals(checkIdRef.getRef())) continue;
                idRef = checkIdRef;
                break;
            }
            if (idRef == null) {
                Iterator i$ = null;
                return i$;
            }
            AMXScopedIdContext idContext = new AMXScopedIdContext(xmlContext);
            ScopedId declId = ScopedIdUtils.resolveScopedId((ScopedIdContext)idContext, (ScopedId)idRef.getScopedId(), (String)idRef.getRef(), null);
            if (declId == null) {
                Declaration declaration = null;
                return declaration;
            }
            Element ownerDecl = declId.getOwnerElement();
            Attr idAttr = ownerDecl.getAttributeNodeNS(null, "id");
            if (idAttr == null) {
                Declaration declaration = null;
                return declaration;
            }
            XmlContext owningContext = xmlContext;
            AMXScopedIdDeclaration aMXScopedIdDeclaration = new AMXScopedIdDeclaration(owningContext, idAttr, 0, idAttr.getValue().length());
            return aMXScopedIdDeclaration;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public String getScopedIdReference() {
        return this._scopedIdReference;
    }

    protected String getDisplayNameImpl(DependencyContext context) {
        return String.format("Scoped id reference: %s", this.getValue(context));
    }
}

