/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.dependency;

import java.util.Collection;
import java.util.Map;
import oracle.adfdt.view.unified.id.ScopedId;
import oracle.adfdt.view.unified.id.ScopedIdContext;
import oracle.adfdt.view.unified.id.ScopedIdUtils;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdContext;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdTraversalHandler;
import oracle.adfmf.amx.dt.metadata.dependency.AMXScopedIdReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.XmlDeclaration;
import oracle.bali.xml.model.traversal.TraversalData;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AMXScopedIdDeclaration
extends XmlDeclaration {
    public AMXScopedIdDeclaration(XmlContext xmlContext, Node node, int start, int end) {
        super(xmlContext, node, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findUsages(DependencyContext context, FindUsagesCallback callback) {
        XmlContext xmlContext = this.getXmlContext(context);
        XmlModel model = xmlContext.getModel();
        AMXScopedIdContext idContext = new AMXScopedIdContext(xmlContext);
        model.acquireReadLock();
        try {
            TraversalData data = context.getTraversalData(xmlContext);
            Attr attr = (Attr)this.getNode(context);
            Map declarations = (Map)data.get((Object)"__scoped_id_declarations");
            if (declarations == null) {
                return;
            }
            Map references = (Map)data.get((Object)"__scoped_id_references");
            if (references == null || references.isEmpty()) {
                return;
            }
            ScopedId declId = (ScopedId)declarations.get(attr);
            for (Map.Entry e : references.entrySet()) {
                Collection refs = (Collection)e.getValue();
                for (AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference ref : refs) {
                    String bit = ref.getRef();
                    if (!this._isReferenceMatch(idContext, declId, ref, true)) continue;
                    Attr refAttr = (Attr)e.getKey();
                    String value = refAttr.getNodeValue();
                    String declLocalId = declId.getLocalId();
                    int start = value.indexOf(bit);
                    AMXScopedIdReference scopedIdRef = new AMXScopedIdReference(xmlContext, bit, refAttr, start += bit.indexOf(declLocalId), start + declLocalId.length());
                    callback.addReference((Reference)scopedIdRef);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected String getDisplayNameImpl(DependencyContext context) {
        return String.format("Scoped id declaration: %s", this.getValue(context));
    }

    private boolean _isReferenceMatch(ScopedIdContext idContext, ScopedId decl, AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference sitr, boolean includeIntermediateMatches) {
        int loc;
        String ref = sitr.getRef().trim();
        String declLocalId = decl.getLocalId();
        if (includeIntermediateMatches && !ref.endsWith(declLocalId) && (loc = ref.indexOf(declLocalId)) != -1) {
            ref = ref.substring(0, loc + declLocalId.length());
        }
        ScopedId target = ScopedIdUtils.resolveScopedId((ScopedIdContext)idContext, (ScopedId)sitr.getScopedId(), (String)ref);
        return decl.equals(target);
    }
}

