/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import java.util.List;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class QuadrantListItemCreator
extends ListItemCreator {
    private static final String _ROW_SPAN = "2";
    private static final String _START_OUTPUT_TEXT_CELL_FORMAT_WIDTH = "60%";
    private static final String _UPPER_START_OUTPUT_TEXT_CELL_FORMAT_HEIGHT = "28px";
    private static final String _END_OUTPUT_TEXT_CELL_FORMAT_WIDTH = "40%";
    private static final String _LOWER_START_OUTPUT_TEXT_CELL_FORMAT_HEIGHT = "12px";

    public QuadrantListItemCreator(Document document) {
        super(document);
    }

    @Override
    protected void addListItemChildren(Node parent, List<Node> listItemChildren, boolean isImageSupported) {
        Node upperRowLayout = this.createRowLayout();
        Node lowerRowLayout = this.createRowLayout();
        if (!isImageSupported) {
            assert (listItemChildren.size() == 4);
            upperRowLayout.appendChild(this.createHorizontalFillerCellFormat(_ROW_SPAN));
        } else {
            assert (listItemChildren.size() == 5);
            upperRowLayout.appendChild(this.createImageCellFormat(listItemChildren.get(listItemChildren.size() - 1), _ROW_SPAN));
        }
        int index = 0;
        upperRowLayout.appendChild(this.createOutputTextCellFormat(listItemChildren.get(index++), _START_OUTPUT_TEXT_CELL_FORMAT_WIDTH, _UPPER_START_OUTPUT_TEXT_CELL_FORMAT_HEIGHT, null));
        upperRowLayout.appendChild(this.createHorizontalFillerCellFormat(_ROW_SPAN));
        upperRowLayout.appendChild(this.createOutputTextCellFormat(listItemChildren.get(index++), _END_OUTPUT_TEXT_CELL_FORMAT_WIDTH, null, "end"));
        lowerRowLayout.appendChild(this.createOutputTextCellFormat(listItemChildren.get(index++), _START_OUTPUT_TEXT_CELL_FORMAT_WIDTH, _LOWER_START_OUTPUT_TEXT_CELL_FORMAT_HEIGHT, null));
        lowerRowLayout.appendChild(this.createOutputTextCellFormat(listItemChildren.get(index++), _END_OUTPUT_TEXT_CELL_FORMAT_WIDTH, null, "end"));
        parent.appendChild(upperRowLayout);
        parent.appendChild(lowerRowLayout);
    }
}

