/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import java.awt.Component;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.adfmf.amx.dt.editor.databinding.AMXDesignTimeContext;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListViewCreationDelegate;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListViewCreationPanel;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListViewGalleryPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.NodeCreator;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ListViewNodeCreator
implements NodeCreator {
    private static final String _LIST_VIEW_GALLERY_UI_FIRST_HELP_ID = "f1_adfmf_clv_ui_first_html";
    private static final String _LIST_VIEW_CREATION_HELP_ID = "f1_adfmf_create_listview_html";
    private static final int _LIST_VIEW_CREATION_WIZARD_WIDTH = 600;
    private static final int _LIST_VIEW_CREATION_WIZARD_HEIGHT = 450;
    private static final Logger _LOGGER = Logger.getLogger(ListViewNodeCreator.class.getName());

    public Node createNode(XmlContext context, XmlKey key, DomPosition insertPosition, Node prototypeNode) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this._createListViewGalleryPanel(context, properties)) {
            return this._createListViewCreationPanel(context, properties);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createListViewGalleryPanel(XmlContext context, Map<String, Object> properties) {
        ListViewGalleryPanel galleryPanel = new ListViewGalleryPanel(context);
        galleryPanel.initialize();
        HelpSystem.getHelpSystem().registerTopic((JComponent)galleryPanel, _LIST_VIEW_GALLERY_UI_FIRST_HELP_ID);
        JEWTDialog galleryDialog = new JEWTDialog((Frame)Ide.getMainWindow(), galleryPanel.getCustomDialogTitle(), 7);
        galleryDialog.setResizable(true);
        galleryDialog.setContent((Component)galleryPanel);
        boolean ok = WizardLauncher.runDialog((JDialog)galleryDialog);
        if (!ok) {
            galleryDialog.dispose();
            return false;
        }
        try {
            properties.put("listFormat", galleryPanel.getListViewFormatVariation());
            properties.put("style", galleryPanel.getListViewStyle());
        }
        finally {
            galleryDialog.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _createListViewCreationPanel(XmlContext context, Map<String, Object> properties) {
        JDevXmlContext jdevXmlContext = (JDevXmlContext)context;
        TransactionToken transToken = jdevXmlContext.getTransactionToken();
        if (transToken == null) {
            transToken = jdevXmlContext.createTransactionToken();
            jdevXmlContext.setTransactionToken(transToken);
        }
        JEWTDialog dialog = null;
        try {
            ListViewCreationDelegate delegate = new ListViewCreationDelegate(context.getModel().getDocument(), new AMXDesignTimeContext(context), properties);
            ListViewCreationPanel listViewCreationPanel = new ListViewCreationPanel(delegate, JDevXmlContext.createContext((JDevXmlContext)jdevXmlContext));
            HelpSystem.getHelpSystem().registerTopic((JComponent)listViewCreationPanel, _LIST_VIEW_CREATION_HELP_ID);
            dialog = new JEWTDialog((Frame)Ide.getMainWindow(), listViewCreationPanel.getCustomDialogTitle(), 7);
            dialog.setResizable(false);
            dialog.setContent((Component)listViewCreationPanel);
            dialog.setPreferredSize(600, 450);
            boolean ok = WizardLauncher.runDialog((JDialog)dialog);
            if (!ok) {
                dialog.dispose();
                Node node = null;
                return node;
            }
            listViewCreationPanel.commit();
            Element element = listViewCreationPanel.getElement();
            return element;
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, e.getMessage(), e);
            Node node = null;
            return node;
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
    }
}

