/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.standalone.BinderGui;
import oracle.adfdt.view.common.binding.standalone.BinderGuiFactory;
import oracle.adfdt.view.common.binding.utils.Two;
import oracle.adfdt.view.ui.editor.DefinitionValidator;
import oracle.adfmf.amx.dt.editor.databinding.AMXModelProviderFactory;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.adfmf.amx.dt.editor.databinding.collection.AmxListViewCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.util.ListViewBindingUtils;
import oracle.adfmf.amx.dt.metadata.creators.CollectionCreationDelegate;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemContentPanel;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreatorFactory;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.binding.meta.NamedDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ListViewCreationDelegate
extends CollectionCreationDelegate {
    private final String _listViewFormatVariation;
    private final String _listViewStyle;
    private boolean _isDataCollectionProvided = false;
    private ListItemContentPanel _listItemContentPanel;
    private BinderGui _listViewBinderGui;
    private final ListViewDefinitionValidator _listViewDefVal = new ListViewDefinitionValidator();
    private final AMXModelProviderFactory _amxModelProviderFactory = new AMXModelProviderFactory();

    public ListViewCreationDelegate(Document document, JDevDesignTimeContext dtContext, Map<String, Object> properties) {
        super(document, dtContext, properties);
        this._listViewFormatVariation = (String)this.getProperties().get("listFormat");
        this._listViewStyle = (String)this.getProperties().get("style");
    }

    @Override
    public void clearDynamicState() {
        this._listViewBinderGui = null;
    }

    @Override
    public boolean hasDynamicState() {
        return this._listViewBinderGui != null;
    }

    @Override
    public DefinitionValidator getDefinitionValidator() {
        return this._listViewDefVal;
    }

    @Override
    public JPanel createDefaultCollectionPanel(boolean isDataCollectionProvided, List<Object> attrDefinitions) {
        this._isDataCollectionProvided = isDataCollectionProvided ? attrDefinitions.size() != 0 : false;
        this._recreateElement();
        List<AMXPrimitiveDefinition> itemsArrayList = this._getCollectionItems(isDataCollectionProvided, attrDefinitions);
        AMXPrimitiveCollection defCollection = ListViewBindingUtils.createDefinitionCollection(CreationContext.getCreationContext((ADFDesignTimeContext)this.getDesignTimeContext()), null, "", attrDefinitions, ListViewBindingUtils.getDefaultInclusionContext(), itemsArrayList);
        AmxListViewCollectionDecorator decorator = new AmxListViewCollectionDecorator((ADFDesignTimeContext)this.getDesignTimeContext(), defCollection, MobileResourceUtils.getText("LISTVIEW_EDITOR_DESCRIPTION"));
        if (!this._isDataCollectionProvided) {
            decorator.setValueHeader(MobileResourceUtils.getText("LISTVIEW_EDITOR_VALUE_COLUMN_HEADER"));
            decorator.treatValueAsText(true);
        }
        this._listItemContentPanel = new ListItemContentPanel(this.getElement(), decorator, defCollection, this._listViewFormatVariation, this._listViewStyle, this._isDataCollectionProvided);
        return this._listItemContentPanel;
    }

    @Override
    public JComponent createNewCollectionPanel(Object newBinding) {
        this._recreateElement();
        if (newBinding instanceof Two) {
            Two binding = (Two)newBinding;
            this._listViewBinderGui = BinderGuiFactory.getBinderGui((ADFDesignTimeContext)this.getDesignTimeContext(), (DataControl)((DataControl)binding.getTwo()), (NamedDefinition)((NamedDefinition)binding.getOne()), (Element)this.getElement(), this.getProperties(), (String)ListViewBindingUtils.getCreatorPattern(this._listViewFormatVariation));
            if (this.getCollectionCreationPanel() != null) {
                this.getCollectionCreationPanel().disableElementTypeEditor();
            }
            return this._listViewBinderGui.getGui();
        }
        if (this.getCollectionCreationPanel() != null) {
            return this.getCollectionCreationPanel().createNewCollectionPanelImpl(newBinding);
        }
        return new JPanel();
    }

    @Override
    public void commit(String dataCollectionValue) throws Exception {
        if (this._listViewBinderGui != null) {
            this._listViewBinderGui.commit();
            this._listViewBinderGui.runConfigurations();
        } else {
            this._commitListItemContentChanges(dataCollectionValue);
        }
    }

    private void _recreateElement() {
        this.setElement(this.getDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx", "listView"));
    }

    private List<AMXPrimitiveDefinition> _getCollectionItems(boolean isDataCollectionProvided, List<Object> attrDefinitions) {
        List<String> components;
        ArrayList<AMXPrimitiveDefinition> itemsArrayList = new ArrayList<AMXPrimitiveDefinition>();
        if (this._listViewFormatVariation != null && (components = ListViewBindingUtils.getSupportedComponents(this._listViewFormatVariation)) != null) {
            for (String component : components) {
                Object value = null;
                value = !isDataCollectionProvided ? ListViewBindingUtils.getComponentValue(component) : (attrDefinitions.size() > 0 ? attrDefinitions.get(0) : "");
                AMXPrimitiveDefinition defItem = new AMXPrimitiveDefinition(CreationContext.getCreationContext((ADFDesignTimeContext)this.getDesignTimeContext()), null, ListViewBindingUtils.getInclusionContext(component), AMXCollectionDecorator.DEFAULT_LABEL_MARKER, value);
                defItem.setComponent(component);
                itemsArrayList.add(defItem);
                if (isDataCollectionProvided) continue;
                attrDefinitions.add(value);
            }
        }
        return itemsArrayList;
    }

    private void _commitListItemContentChanges(String dataCollectionValue) {
        ListItemCreator listItemCreator;
        this._listItemContentPanel.commit();
        this.getElement().setAttributeNS(null, "var", "row");
        if (dataCollectionValue != null && !dataCollectionValue.isEmpty()) {
            this.getElement().setAttributeNS(null, "value", dataCollectionValue);
        }
        if ((listItemCreator = ListItemCreatorFactory.createListItemCreator(this._listViewFormatVariation, this.getElement().getOwnerDocument())) != null) {
            this.getElement().appendChild(listItemCreator.createListItem(this.createListItemChildren(), this._listViewFormatVariation, this._listViewStyle));
        }
    }

    private List<Node> createListItemChildren() {
        List collectionItems = this._listItemContentPanel.getDefinitionCollection().getItems();
        Document document = this.getElement().getOwnerDocument();
        boolean isImageSupportedFormat = ListViewBindingUtils.isImageSupported(this._listViewFormatVariation);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        int size = collectionItems.size();
        for (int index = 0; index < size; ++index) {
            AMXPrimitiveDefinition collectionItem = (AMXPrimitiveDefinition)((Object)collectionItems.get(index));
            boolean isImage = isImageSupportedFormat && index == size - 1;
            Node childNode = ListViewBindingUtils.createListItemChild(collectionItem, document, !this._isDataCollectionProvided, isImage);
            childNodes.add(childNode);
        }
        return Collections.unmodifiableList(childNodes);
    }

    private final class ListViewDefinitionValidator
    implements DefinitionValidator {
        private ListViewDefinitionValidator() {
        }

        public boolean validateDefinition(NamedDefinition namedDefinition) {
            return ListViewCreationDelegate.this._amxModelProviderFactory.getApplicableBindingsTypes(namedDefinition).contains(AMXModelProviderFactory.ADF_MOBILE_LIST_VIEW);
        }

        public String generateReason(NamedDefinition namedDefinition) {
            return MobileResourceUtils.getText("LISTVIEW_EDITOR_BAD_DEF_REASON");
        }
    }
}

