/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.MainSubListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.QuadrantListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.SimpleListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.StartEndListItemCreator;
import org.w3c.dom.Document;

public final class ListItemCreatorFactory {
    private static final String _SIMPLE = "SIMPLE";
    private static final String _MAINSUB = "MAINSUB";
    private static final String _STARTEND = "STARTEND";
    private static final String _QUADRANT = "QUADRANT";

    public static ListItemCreator createListItemCreator(String listViewFormat, Document document) {
        if (listViewFormat == null) {
            return null;
        }
        ListItemCreator listItemCreator = null;
        if (listViewFormat.startsWith(_SIMPLE)) {
            listItemCreator = new SimpleListItemCreator(document);
        } else if (listViewFormat.startsWith(_MAINSUB)) {
            listItemCreator = new MainSubListItemCreator(document);
        } else if (listViewFormat.startsWith(_STARTEND)) {
            listItemCreator = new StartEndListItemCreator(document);
        } else if (listViewFormat.startsWith(_QUADRANT)) {
            listItemCreator = new QuadrantListItemCreator(document);
        }
        return listItemCreator;
    }
}

