/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import java.util.List;
import oracle.adfmf.amx.dt.editor.databinding.util.ListViewBindingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ListItemCreator {
    private final Document _document;
    private static final String _FILLER_CELL_FORMAT_WIDTH = "10px";
    private static final String _IMAGE_CELL_FORMAT_WIDTH = "40px";

    public ListItemCreator(Document document) {
        this._document = document;
    }

    public Node createListItem(List<Node> listItemChildren, String listViewFormat, String listViewStyle) {
        Element listItem = this._document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "amx:listItem");
        if (!ListViewBindingUtils.isChevronSupported(listViewStyle)) {
            listItem.setAttributeNS(null, "showLinkIcon", "false");
        }
        Node tableLayout = null;
        if (ListViewBindingUtils.isTableLayoutRequired(listViewFormat)) {
            tableLayout = this._createTableLayout();
        }
        Node parent = tableLayout == null ? listItem : tableLayout;
        this.addListItemChildren(parent, listItemChildren, ListViewBindingUtils.isImageSupported(listViewFormat));
        if (tableLayout != null) {
            listItem.appendChild(tableLayout);
        }
        return listItem;
    }

    protected abstract void addListItemChildren(Node var1, List<Node> var2, boolean var3);

    protected Node createRowLayout() {
        return this._document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "rowLayout");
    }

    protected Node createHorizontalFillerCellFormat(String rowSpan) {
        Element fillerCellFormat = this.createCellFormat(_FILLER_CELL_FORMAT_WIDTH);
        this._setCellFormatAttribute(fillerCellFormat, "rowSpan", rowSpan);
        return fillerCellFormat;
    }

    protected Element createImageCellFormat(Node imageNode, String rowSpan) {
        Element imageCellFormat = this.createCellFormat(_IMAGE_CELL_FORMAT_WIDTH);
        this._setCellFormatAttribute(imageCellFormat, "halign", "center");
        this._setCellFormatAttribute(imageCellFormat, "rowSpan", rowSpan);
        imageCellFormat.appendChild(imageNode);
        return imageCellFormat;
    }

    protected Element createOutputTextCellFormat(Node outputTextNode, String width, String height, String halign) {
        Element outputTextCellFormat = this.createCellFormat(width);
        this._setCellFormatAttribute(outputTextCellFormat, "height", height);
        this._setCellFormatAttribute(outputTextCellFormat, "halign", halign);
        outputTextCellFormat.appendChild(outputTextNode);
        return outputTextCellFormat;
    }

    protected Element createCellFormat(String width) {
        Element cellFormat = this._document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "cellFormat");
        this._setCellFormatAttribute(cellFormat, "width", width);
        return cellFormat;
    }

    private Node _createTableLayout() {
        Element tableLayout = this._document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "tableLayout");
        tableLayout.setAttributeNS(null, "width", "100%");
        return tableLayout;
    }

    private void _setCellFormatAttribute(Element cellFormat, String attrName, String attrValue) {
        if (attrValue != null && !attrValue.isEmpty()) {
            cellFormat.setAttributeNS(null, attrName, attrValue);
        }
    }
}

