/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators.listview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.adfdt.common.ui.util.InterfaceUtils;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXListViewCollectionSummaryPanel;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.util.ListViewBindingUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.javatools.ui.RichHintLabel;
import org.w3c.dom.Element;

public final class ListItemContentPanel
extends JPanel {
    private transient Element _listViewElement;
    private transient AMXCollectionDecorator _decorator;
    private transient AMXPrimitiveCollection _defCollection;
    private String _listViewFormatVariation;
    private String _listViewStyle;
    private JComboBox _dividerAttribute;
    private JLabel _dividerAttributeLabel;
    private JComboBox _dividerMode;
    private JLabel _dividerModeLabel;
    private static final String _COMBO_PROTOTYPE_DISPLAY_VALUE = "XXXXXXXXXXXXXXXXXXXX";
    private static final int _LABEL_COLUMN_WIDTH = 15;
    private static final int _ELEMENT_COLUMN_WIDTH = 150;
    private static final int _DIVIDER_ATTR_LABEL_HOR_SPACE = 28;
    private static final int _DIVIDER_MODE_LABEL_HOR_SPACE = 45;
    private static final int _LABEL_VGAP = 4;
    private static final String _NO_DIVIDER = MobileResourceUtils.getText("LISTVIEW_EDITOR_NO_DIVIDER_VALUE");
    private static final String[] _DIVIDER_MODE_VALUES = new String[]{MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_MODE_FIRST_ALL"), MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_MODE_FIRST_LETTER")};
    private static final Map<String, ImageIcon> _CACHED_IMAGES = new HashMap<String, ImageIcon>();
    private static final long serialVersionUID = 1L;

    public ListItemContentPanel(Element listViewElement, AMXCollectionDecorator decorator, AMXPrimitiveCollection defCollection, String listViewFormatVariation, String listViewStyle, boolean enableDividerAttribute) {
        this._listViewElement = listViewElement;
        this._decorator = decorator;
        this._defCollection = defCollection;
        this._listViewFormatVariation = listViewFormatVariation;
        this._listViewStyle = listViewStyle;
        this.setLayout(new BorderLayout());
        this._addCollectionSummaryPanel();
        this._addIcon();
        this._createOptionsPanel(enableDividerAttribute);
    }

    public AMXPrimitiveCollection getDefinitionCollection() {
        return this._defCollection;
    }

    public void commit() {
        String dividerAttributeValue = this._dividerAttribute.getSelectedItem().toString();
        if (!_NO_DIVIDER.equals(dividerAttributeValue)) {
            this._listViewElement.setAttributeNS(null, "dividerAttribute", dividerAttributeValue);
            String selectedValue = this._dividerMode.getSelectedItem().toString();
            String dividerModeValue = "all";
            if (MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_MODE_FIRST_LETTER").equals(selectedValue)) {
                dividerModeValue = "firstLetter";
            }
            this._listViewElement.setAttributeNS(null, "dividerMode", dividerModeValue);
        }
        if (ListViewBindingUtils.isInsetSupported(this._listViewStyle)) {
            this._listViewElement.setAttributeNS(null, "styleClass", "adfmf-listView-insetList");
        }
    }

    public String getDividerAttributeValue() {
        String dividerAttributeValue = _NO_DIVIDER;
        if (this._dividerAttribute != null && this._dividerAttribute.getSelectedItem() != null) {
            dividerAttributeValue = this._dividerAttribute.getSelectedItem().toString();
        }
        return dividerAttributeValue;
    }

    private void _addCollectionSummaryPanel() {
        AMXListViewCollectionSummaryPanel summaryPanel = new AMXListViewCollectionSummaryPanel(this._defCollection, this._decorator);
        summaryPanel.moveColumn(1, 2);
        summaryPanel.resizeColumn(0, 15);
        summaryPanel.resizeColumn(1, 150);
        this.add((Component)((Object)summaryPanel));
    }

    private void _addIcon() {
        ImageIcon icon;
        String iconPath = ListViewBindingUtils.getListViewFormatIconPath(this._listViewFormatVariation);
        if (iconPath != null && (icon = ListItemContentPanel._getIcon(iconPath)) != null) {
            JPanel iconPanel = new JPanel(new BorderLayout());
            iconPanel.add((Component)new JLabel(icon), "North");
            JPanel spacerPanel = new JPanel(new BorderLayout());
            spacerPanel.add(Box.createHorizontalStrut(16), "East");
            JPanel combinedPanel = new JPanel(new BorderLayout());
            combinedPanel.add((Component)iconPanel, "West");
            combinedPanel.add((Component)spacerPanel, "East");
            this.add((Component)combinedPanel, "West");
        }
    }

    private static ImageIcon _getIcon(String iconPath) {
        if (_CACHED_IMAGES.containsKey(iconPath)) {
            return _CACHED_IMAGES.get(iconPath);
        }
        ImageIcon icon = new ImageIcon(ListItemContentPanel.class.getResource(iconPath));
        _CACHED_IMAGES.put(iconPath, icon);
        return icon;
    }

    private void _createOptionsPanel(boolean enableDividerAttribute) {
        JPanel divAttrPanel = this._createDividerAttributePanel(enableDividerAttribute);
        JPanel divModePanel = this._createDividerModePanel();
        if (this._dividerAttribute.getItemCount() > 1 && ListViewBindingUtils.isDividerAttributeSupported(this._listViewFormatVariation)) {
            this._dividerAttribute.setSelectedIndex(1);
        }
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, 1));
        options.add(Box.createVerticalStrut(10));
        options.add(divAttrPanel);
        options.add(Box.createVerticalStrut(6));
        options.add(divModePanel);
        this.add((Component)options, "South");
    }

    private JPanel _createDividerAttributePanel(boolean enableDividerAttribute) {
        ArrayList<String> dividerAttributeValues = new ArrayList<String>();
        dividerAttributeValues.add(_NO_DIVIDER);
        if (enableDividerAttribute) {
            Collection<Object> definitions = this._defCollection.getDefinitions();
            for (Object definition : definitions) {
                dividerAttributeValues.add(this._defCollection.getDefinitionDisplayName(definition));
            }
        }
        this._dividerAttribute = new JComboBox<Object>(dividerAttributeValues.toArray());
        this._dividerAttribute.addActionListener(new ComboBoxListener());
        this._dividerAttributeLabel = InterfaceUtils.createLabel((String)MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_ATTRIBUTE_OPTION"));
        this._dividerAttributeLabel.setEnabled(enableDividerAttribute);
        return this._addDividerCombobox(this._dividerAttributeLabel, 28, this._dividerAttribute, enableDividerAttribute, 8, MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_ATTRIBUTE_DESC"));
    }

    private JPanel _createDividerModePanel() {
        this._dividerMode = new JComboBox<String>(_DIVIDER_MODE_VALUES);
        this._dividerModeLabel = InterfaceUtils.createLabel((String)MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_MODE_OPTION"));
        this._dividerModeLabel.setEnabled(false);
        return this._addDividerCombobox(this._dividerModeLabel, 45, this._dividerMode, false, 8, MobileResourceUtils.getText("LISTVIEW_EDITOR_DIVIDER_MODE_DESC"));
    }

    private JPanel _addDividerCombobox(JLabel comboboxLabel, int labelHorSpace, JComboBox combobox, boolean isEnabled, int descHorSpace, String descriptionText) {
        JPanel dividerPanel = new JPanel();
        dividerPanel.setLayout(new BoxLayout(dividerPanel, 0));
        dividerPanel.add(comboboxLabel);
        dividerPanel.add(Box.createHorizontalStrut(labelHorSpace));
        combobox.setEditable(false);
        combobox.setPrototypeDisplayValue(_COMBO_PROTOTYPE_DISPLAY_VALUE);
        combobox.setEnabled(isEnabled);
        dividerPanel.add(combobox);
        dividerPanel.add(Box.createHorizontalStrut(descHorSpace));
        RichHintLabel description = new RichHintLabel();
        description.setHtmlText(descriptionText);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(Box.createVerticalStrut(4));
        labelPanel.add((Component)description);
        dividerPanel.add(labelPanel);
        return dividerPanel;
    }

    private final class ComboBoxListener
    implements ActionListener {
        private ComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ListItemContentPanel.this._dividerAttribute) {
                boolean isDividerModeEnabled = !_NO_DIVIDER.equals(ListItemContentPanel.this._dividerAttribute.getSelectedItem().toString());
                ListItemContentPanel.this._dividerMode.setEnabled(isDividerModeEnabled);
                ListItemContentPanel.this._dividerModeLabel.setEnabled(isDividerModeEnabled);
            }
        }
    }
}

