/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.metadata.creators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfdt.common.ui.util.InterfaceUtils;
import oracle.adfdt.view.common.binding.utils.Two;
import oracle.adfdt.view.ui.editor.ExpressionOrDefinitionPicker;
import oracle.adfdt.view.unified.binding.util.ExpressionUtils;
import oracle.adfdtinternal.model.ide.controls.DataControlTreeNode;
import oracle.adfmf.amx.dt.metadata.creators.CollectionCreationDelegate;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.jdev.controls.ClassPickerPanel;
import oracle.binding.meta.NamedDefinition;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JComboCardPanel;
import oracle.javatools.dialogs.MessageDialog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CollectionCreationPanel
extends JPanel {
    private final transient CollectionCreationDelegate _delegate;
    private final transient Context _ideContext;
    private String _lastKnownExpression;
    private boolean _inMiddleOfRebind = false;
    private String _classHint;
    private transient List<Object> _classHintBasedAttributes = new ArrayList<Object>();
    private transient ExpressionOrDefinitionPicker _picker;
    private transient Object _rawDataValue;
    private JCheckBox _bindToData;
    private boolean _setBindToDataAfterConfirmDialog = false;
    private JTextField _dataCollection;
    private JButton _dataCollectionButton;
    private boolean _dataCollectionTextChangedSinceLastReset = false;
    private ClassPickerPanel _elementType;
    private Component _elementTypeButton;
    private JTextField _elementTypeTextField;
    private JPanel _collectionPanel;
    private static final long serialVersionUID = 1L;

    public CollectionCreationPanel(CollectionCreationDelegate delegate, Context ideContext) {
        if (delegate == null) {
            throw new NullPointerException("The collection creation delegate cannot be null");
        }
        this._delegate = delegate;
        this._delegate.setCollectionCreationPanel(this);
        this._ideContext = ideContext;
        this._populate();
        this._setEnabledBindDataNowComponents(this._bindToData.isSelected());
    }

    public Element getElement() {
        return this._delegate.getElement();
    }

    public void commit() throws Exception {
        this._delegate.commit(this._dataCollection.getText());
    }

    public void disableElementTypeEditor() {
        this._elementType.setEnabled(false);
        this._elementTypeButton.setEnabled(false);
        this._elementType.setClassName("");
        this._elementTypeTextField.setText("");
    }

    public JComponent createNewCollectionPanelImpl(Object newBinding) {
        String expression = (String)newBinding;
        String className = AMXUtils.getClassNameFromExpression(this._ideContext, this._delegate.getElement(), expression);
        if (className != null) {
            this._elementType.setClassName(className);
        } else {
            this._elementType.setClassName("");
            this._elementTypeTextField.setText("");
        }
        List<Object> attributes = this._getClassHintBasedAttributes(className);
        return this._delegate.createDefaultCollectionPanel(true, attributes);
    }

    protected CollectionCreationDelegate getDelegate() {
        return this._delegate;
    }

    protected abstract String getCustomDialogTitle();

    protected abstract String getDataCollectionLabel();

    protected abstract String getHeaderDescription();

    protected abstract boolean enableBindToDataByDefault();

    protected abstract Dimension getCollectionPanelDimension();

    protected abstract String getExpressionOrDefinitionPickerTitle();

    private void _populate() {
        JPanel bindToDataContents = InterfaceUtils.createLabelFieldButtonPanel();
        this._createDataCollectionFields(bindToDataContents);
        this._createElementTypeFields(bindToDataContents);
        Box contentPane = Box.createVerticalBox();
        contentPane.add(this._createHeader());
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(this._createBindDataComboCardPanel(bindToDataContents));
        contentPane.add(Box.createVerticalStrut(16));
        contentPane.add(this._createDefaultCollectionPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)contentPane, "Center");
        this.add(Box.createVerticalStrut(10), "North");
        this.add(Box.createHorizontalStrut(10), "West");
        this.add(Box.createHorizontalStrut(10), "East");
    }

    private JComponent _createDefaultCollectionPanel() {
        this._collectionPanel = new JPanel(new BorderLayout());
        this._collectionPanel.add((Component)this._delegate.createDefaultCollectionPanel(false, new ArrayList<Object>()), "Center");
        this._collectionPanel.setPreferredSize(this.getCollectionPanelDimension());
        return this._collectionPanel;
    }

    private void _createDataCollectionFields(JPanel bindToDataContents) {
        JLabel dataCollectionLabel = InterfaceUtils.createLabel((String)this.getDataCollectionLabel());
        bindToDataContents.add(InterfaceUtils.indentComponent((Component)dataCollectionLabel, (boolean)true));
        this._dataCollection = new JTextField();
        this._dataCollection.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CollectionCreationPanel.this._dataCollectionTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CollectionCreationPanel.this._dataCollectionTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CollectionCreationPanel.this._dataCollectionTextChanged();
            }
        });
        this._dataCollection.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && CollectionCreationPanel.this.isEnabled() && CollectionCreationPanel.this._dataCollectionTextChangedSinceLastReset && CollectionCreationPanel.this._delegate.hasDynamicState()) {
                    if (!CollectionCreationPanel.this._confirmChangeBinding()) {
                        CollectionCreationPanel.this._dataCollection.setText(CollectionCreationPanel.this._lastKnownExpression);
                        CollectionCreationPanel.this._dataCollectionTextChangedSinceLastReset = false;
                        SwingUtilities.invokeLater(new FocusGrabber(CollectionCreationPanel.this._dataCollection));
                    } else {
                        CollectionCreationPanel.this._handleNewDataCollectionChanges(CollectionCreationPanel.this._dataCollection.getText());
                    }
                }
            }
        });
        dataCollectionLabel.setLabelFor(this._dataCollection);
        this._dataCollectionButton = InterfaceUtils.createButton((String)MobileResourceUtils.getText("BROWSE_BUTTON_LABEL"), (boolean)false);
        this._dataCollectionButton.addActionListener(new DataCollectionButtonListener());
        bindToDataContents.add(this._dataCollection);
        bindToDataContents.add(InterfaceUtils.indentComponent((Component)this._dataCollectionButton, (boolean)false));
    }

    private void _createElementTypeFields(JPanel bindToDataContents) {
        JLabel elementTypeLabel = InterfaceUtils.createLabel((String)MobileResourceUtils.getText("ELEMENT_TYPE_LABEL"));
        this._elementType = new ClassPickerPanel(this._ideContext.getProject(), null);
        this._elementType.addPropertyChangeListener((PropertyChangeListener)new ElementTypeListener());
        elementTypeLabel.setLabelFor((Component)this._elementType);
        this._elementTypeButton = this._elementType.getButtonComponent();
        this._elementTypeTextField = (JTextField)this._elementType.getLabelComponent();
        this._elementTypeTextField.setEditable(false);
        bindToDataContents.add(InterfaceUtils.indentComponent((Component)elementTypeLabel, (boolean)true));
        bindToDataContents.add(this._elementTypeTextField);
        bindToDataContents.add(InterfaceUtils.indentComponent((Component)this._elementTypeButton, (boolean)false));
    }

    private JPanel _createHeader() {
        JLabel headerLabel = new JLabel(this.getHeaderDescription());
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)headerLabel, "Center");
        return headerPanel;
    }

    private JPanel _createBindDataComboCardPanel(JPanel bindToDataContents) {
        String bindToDataLabel = MobileResourceUtils.getText("BIND_DATA_CHECKBOX_LABEL");
        this._bindToData = InterfaceUtils.createCheckBox((String)bindToDataLabel, (boolean)this.enableBindToDataByDefault());
        this._bindToData.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)bindToDataLabel));
        this._bindToData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && !CollectionCreationPanel.this._setBindToDataAfterConfirmDialog) {
                    if (CollectionCreationPanel.this._bindToDataConfirmChangeBinding()) {
                        CollectionCreationPanel.this._bindToData.setSelected(false);
                        CollectionCreationPanel.this._handleBindDataNow(false);
                    } else {
                        CollectionCreationPanel.this._bindToData.setSelected(true);
                    }
                    CollectionCreationPanel.this._setBindToDataAfterConfirmDialog = false;
                } else if (e.getStateChange() == 1) {
                    CollectionCreationPanel.this._handleBindDataNow(true);
                }
            }
        });
        JComboCardPanel ccp = new JComboCardPanel(null, (JComponent)this._bindToData);
        ccp.showSubPanel((JComponent)bindToDataContents);
        JPanel northContainer = new JPanel(new BorderLayout());
        northContainer.add((Component)ccp, "Center");
        return ccp;
    }

    private void _setDefaultCollectionPanel() {
        this._clearState();
        this._setNewCollectionPanel(this._delegate.createDefaultCollectionPanel(false, new ArrayList<Object>()));
    }

    private List<Object> _getClassHintBasedAttributes(String className) {
        if (this._classHint != null && this._classHint.equals(className)) {
            return this._classHintBasedAttributes;
        }
        this._classHint = className;
        this._classHintBasedAttributes = new ArrayList<Object>();
        if ("".equals(this._classHint) || this._classHint == null) {
            return this._classHintBasedAttributes;
        }
        this._classHintBasedAttributes = AMXUtils.getClassNameBasedAttributes(this._ideContext.getProject(), className);
        return this._classHintBasedAttributes;
    }

    private void _handleBindDataNow(boolean enabled) {
        if (!enabled) {
            this._rawDataValue = null;
            this._dataCollection.setText("");
            this._elementType.setClassName("");
            this._elementTypeTextField.setText("");
            this._setDefaultCollectionPanel();
        }
        this._setEnabledBindDataNowComponents(enabled);
    }

    private boolean _bindToDataConfirmChangeBinding() {
        if (this._delegate.hasDynamicState() || this._rawDataValue != null && !this._rawDataValue.toString().isEmpty()) {
            this._setBindToDataAfterConfirmDialog = true;
            return this._confirmChangeBinding();
        }
        return true;
    }

    private boolean _confirmChangeBinding() {
        boolean confirmChangeBinding = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)MobileResourceUtils.getText("CNF_LOSE_CHANGES_TEXT"), (String)MobileResourceUtils.getText("CNF_LOSE_CHANGES_TITLE"), null, (boolean)true);
        return confirmChangeBinding;
    }

    private void _setEnabledBindDataNowComponents(boolean enabled) {
        this._dataCollection.setEnabled(enabled);
        this._dataCollectionButton.setEnabled(enabled);
        this._elementType.setEnabled(enabled);
        this._elementTypeButton.setEnabled(enabled);
    }

    private void _handleExpressionFromBindingEditor() {
        Object newValue = this._launchBindingEditor();
        if (newValue == null || newValue.equals(this._rawDataValue)) {
            return;
        }
        this._handleNewDataCollectionChanges(newValue);
    }

    private Object _launchBindingEditor() {
        ExpressionOrDefinitionPicker picker = this._getPicker();
        Object oldState = this._rawDataValue;
        if (oldState instanceof String) {
            picker.setELExpression((String)oldState);
        }
        if (picker.launch()) {
            Object value = picker.getValue();
            if (value instanceof DataControlTreeNode) {
                DataControlTreeNode node = (DataControlTreeNode)value;
                return new Two((Object)node.getDefinition(), (Object)node.getDataControl());
            }
            return value;
        }
        return null;
    }

    private ExpressionOrDefinitionPicker _getPicker() {
        if (this._picker == null) {
            this._picker = new ExpressionOrDefinitionPicker(this.getExpressionOrDefinitionPickerTitle(), this._ideContext, (Node)this._delegate.getElement(), null, this._delegate.getDefinitionValidator(), ExpressionOrDefinitionPicker.Mode.ALL);
        }
        return this._picker;
    }

    private void _handleNewDataCollectionChanges(Object newValue) {
        this._rawDataValue = newValue;
        this._clearState();
        this._dataCollection.setText(this._getELExpressionForValue(newValue));
        this._setNewCollectionPanel(this._delegate.createNewCollectionPanel(newValue));
    }

    private void _clearState() {
        this._delegate.clearDynamicState();
        this._lastKnownExpression = null;
        this._dataCollectionTextChangedSinceLastReset = false;
        this._setEnabledBindDataNowComponents(true);
    }

    private void _dataCollectionTextChanged() {
        if (!this._inMiddleOfRebind) {
            this._rawDataValue = this._dataCollection.getText();
            this._dataCollectionTextChangedSinceLastReset = true;
        }
    }

    private String _getELExpressionForValue(Object newBinding) {
        if (newBinding instanceof Two) {
            String defName = ((NamedDefinition)((Two)newBinding).getOne()).getName();
            this._lastKnownExpression = ExpressionUtils.createBaseExpression((String)defName, (String)"collectionModel");
            return this._lastKnownExpression;
        }
        return (String)newBinding;
    }

    private void _setNewCollectionPanel(JComponent component) {
        this._collectionPanel.removeAll();
        this._collectionPanel.add(component);
        this._collectionPanel.validate();
    }

    private static final class FocusGrabber
    implements Runnable {
        private JComponent _component;

        public FocusGrabber(JComponent component) {
            this._component = component;
        }

        @Override
        public void run() {
            this._component.grabFocus();
        }
    }

    private final class ElementTypeListener
    implements PropertyChangeListener {
        private ElementTypeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("className".equals(pce.getPropertyName())) {
                if (CollectionCreationPanel.this._inMiddleOfRebind) {
                    return;
                }
                Object newValue = pce.getNewValue();
                if (newValue != null && newValue instanceof String && ((String)newValue).length() > 0) {
                    List attributes = CollectionCreationPanel.this._getClassHintBasedAttributes((String)newValue);
                    CollectionCreationPanel.this._setNewCollectionPanel(CollectionCreationPanel.this._delegate.createDefaultCollectionPanel(true, attributes));
                }
            }
        }
    }

    private final class DataCollectionButtonListener
    implements ActionListener {
        private DataCollectionButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            CollectionCreationPanel.this._inMiddleOfRebind = true;
            try {
                CollectionCreationPanel.this._handleExpressionFromBindingEditor();
            }
            finally {
                CollectionCreationPanel.this._inMiddleOfRebind = false;
            }
        }
    }
}

