/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector.scopedid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.adfdt.common.util.StringUtils;
import oracle.adfdt.view.unified.id.ScopedId;
import oracle.adfdt.view.unified.id.ScopedIdContext;
import oracle.adfdt.view.unified.id.ScopedIdTraversalHandler;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdContext;
import oracle.adfmf.amx.dt.metadata.dependency.AMXScopedIdReference;
import oracle.adfmf.amx.dt.metadata.dependency.AMXScopedIdReferenceFactory;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.ide.model.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AMXScopedIdTraversalHandler
extends ScopedIdTraversalHandler {
    public static final String SCOPED_ID_DECLARATIONS = "__scoped_id_declarations";
    public static final String SCOPED_ID_REFERENCES = "__scoped_id_references";

    public static Map<Attr, ScopedId> getScopedIdDeclarationsMap(XmlModel model) {
        Map scopeIdDeclarationsMap = (Map)model.getTraversalData().get((Object)SCOPED_ID_DECLARATIONS);
        return scopeIdDeclarationsMap;
    }

    public static Map<Attr, Collection<AMXScopedIdTraversalReference>> getScopedIdReferencesMap(XmlModel model) {
        Map scopeIdReferencesMap = (Map)model.getTraversalData().get((Object)SCOPED_ID_REFERENCES);
        return scopeIdReferencesMap;
    }

    protected ScopedIdContext createIdContext(XmlContext xmlContext) {
        return new AMXScopedIdContext(xmlContext);
    }

    protected boolean isSupportedNode(XmlModel model, Node sourceNode) {
        JDevXmlContext xmlContext = (JDevXmlContext)model.getContext();
        if (AMXUtils.isSupportedNode(sourceNode)) {
            return AMXScopedIdTraversalHandler._containsGrammarForNamespace((XmlContext)xmlContext, "http://xmlns.oracle.com/adf/mf/amx");
        }
        return false;
    }

    protected void handle(XmlModel model, MutableTraversalData data, Element elem, ScopedId id) {
        String idValue;
        Attr idAttr = elem.getAttributeNodeNS(null, "id");
        if (idAttr != null && StringUtils.isNotEmpty((String)(idValue = idAttr.getNodeValue()))) {
            this._addToDeclaration(data, idAttr, id);
        }
        AMXMetadataResolver resolver = (AMXMetadataResolver)model.getXmlMetadataResolver();
        XmlContext xmlContext = model.getContext();
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrValue = attr.getNodeValue();
            if (!StringUtils.isNotEmpty((String)attrValue)) continue;
            Collection<Reference> refs = null;
            Boolean isScopedIdHolder = resolver.isScopedIdHolder(attr);
            if (isScopedIdHolder != null && isScopedIdHolder.booleanValue()) {
                refs = AMXScopedIdReferenceFactory.__getReferences(xmlContext, attr, attrValue);
            }
            if (refs == null) continue;
            for (Reference siRef : refs) {
                this._addToReferences(data, attr, id, (AMXScopedIdReference)siRef);
            }
        }
    }

    private void _addToDeclaration(MutableTraversalData data, Attr a, ScopedId id) {
        HashMap<Attr, ScopedId> scopedIdMap = (HashMap<Attr, ScopedId>)data.get((Object)SCOPED_ID_DECLARATIONS);
        if (scopedIdMap == null) {
            scopedIdMap = new HashMap<Attr, ScopedId>();
            data.put((Object)SCOPED_ID_DECLARATIONS, scopedIdMap);
        }
        scopedIdMap.put(a, id);
    }

    private void _addToReferences(MutableTraversalData data, Attr attr, ScopedId id, AMXScopedIdReference ref) {
        ArrayList<AMXScopedIdTraversalReference> refs;
        HashMap<Attr, ArrayList<AMXScopedIdTraversalReference>> scopedIdMap = (HashMap<Attr, ArrayList<AMXScopedIdTraversalReference>>)data.get((Object)SCOPED_ID_REFERENCES);
        if (scopedIdMap == null) {
            scopedIdMap = new HashMap<Attr, ArrayList<AMXScopedIdTraversalReference>>();
            data.put((Object)SCOPED_ID_REFERENCES, scopedIdMap);
        }
        if ((refs = (ArrayList<AMXScopedIdTraversalReference>)scopedIdMap.get(attr)) == null) {
            refs = new ArrayList<AMXScopedIdTraversalReference>();
            scopedIdMap.put(attr, refs);
        }
        refs.add(new AMXScopedIdTraversalReference(id, ref.getScopedIdReference()));
    }

    private static boolean _containsGrammarForNamespace(XmlContext context, String namespace) {
        GrammarResolver gp = context.getGrammarResolver();
        return gp.getGrammarForNamespace(namespace) != null;
    }

    public static final class AMXScopedIdTraversalReference {
        private final ScopedId _id;
        private final String _ref;

        AMXScopedIdTraversalReference(ScopedId id, String ref) {
            this._id = id;
            this._ref = ref;
        }

        public ScopedId getScopedId() {
            return this._id;
        }

        public String getRef() {
            return this._ref;
        }
    }
}

