/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector.scopedid;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.view.unified.id.ScopedIdContext;
import oracle.adfdt.view.unified.id.ScopedIdContributorFactory;
import oracle.adfdt.view.unified.id.ScopedIdTraversalContributorFactory;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMXScopedIdContext
extends ScopedIdContext {
    private final AMXMetadataResolver _resolver;

    public AMXScopedIdContext(XmlContext xmlContext) {
        this._resolver = (AMXMetadataResolver)xmlContext.getModel().getXmlMetadataResolver();
    }

    public boolean isIndeterminateNode(XmlKey key, Node node) {
        return false;
    }

    public boolean isNamingContainer(XmlKey key, Node node) {
        return false;
    }

    public boolean isUiComponent(XmlKey key, Node node) {
        return this._resolver.isUIComponent(node);
    }

    public boolean isRootNamingContainer(Element element) {
        return "http://xmlns.oracle.com/adf/mf/amx".equals(element.getNamespaceURI()) && "view".equals(element.getLocalName());
    }

    public Element getTreeRoot(XmlModel model) {
        return AMXScopedIdContext._findFirstElement(model.getTreeTraversal(), model.getDocument().getDocumentElement(), QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/adf/mf/amx", (String)"view"));
    }

    public List<ScopedIdContributorFactory> getScopedIdContributorFactories() {
        return new ArrayList<ScopedIdContributorFactory>();
    }

    public List<ScopedIdTraversalContributorFactory> getScopedIdTraversalContributorFactories() {
        return new ArrayList<ScopedIdTraversalContributorFactory>();
    }

    private static Element _findFirstElement(TreeTraversal traversal, Element root, QualifiedName qName) {
        if (root == null) {
            return null;
        }
        if (AMXScopedIdContext._matchesQname(root, qName)) {
            return root;
        }
        Node node = traversal.getFirstChild((Node)root);
        while (node != null) {
            if (node.getNodeType() == 1 && AMXScopedIdContext._matchesQname(node, qName)) {
                return (Element)node;
            }
            node = traversal.getNextNode(node);
        }
        return null;
    }

    private static boolean _matchesQname(Node node, QualifiedName qName) {
        String elementNS = node.getNamespaceURI();
        String qnameNS = qName.getNamespace();
        if (elementNS == null && qnameNS != null || elementNS != null && qnameNS == null) {
            return false;
        }
        if (!DomUtils.getLocalName((Node)node).equals(qName.getName())) {
            return false;
        }
        if (elementNS == null && qnameNS == null) {
            return true;
        }
        return elementNS != null && elementNS.equals(qnameNS);
    }
}

