/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfmf.amx.dt.inspector.AmxDefaultAttributeValueProvider;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import org.w3c.dom.Node;

public final class TypeAttributeValueProvider
extends AmxDefaultAttributeValueProvider {
    private static final List<AttributeValueItem> _gestureValues;

    @Override
    public List<AttributeValueItem> getAttributeValueItems() {
        XmlModel model = this.getJDevXmlContext().getModel();
        XmlMetadataResolver xmlResolver = model.getXmlMetadataResolver();
        ArrayList<AttributeValueItem> typeValueList = new ArrayList<AttributeValueItem>(_gestureValues);
        Node parent = this.context.getOwnerNode().getParentNode();
        if (parent != null) {
            List<String> listenerList = this._getListeners(parent, xmlResolver);
            for (String listenerAttr : listenerList) {
                String type = listenerAttr.substring(0, listenerAttr.indexOf("Listener"));
                typeValueList.add((AttributeValueItem)new DefaultAttributeValueItem(type));
            }
        }
        return Collections.unmodifiableList(typeValueList);
    }

    @Override
    public boolean isConstrainedToEnumeration() {
        return false;
    }

    private List<String> _getListeners(Node node, XmlMetadataResolver xmlResolver) {
        ElementDef elemDef;
        ArrayList<String> listenerList = new ArrayList<String>();
        if (1 == node.getNodeType() && (elemDef = (ElementDef)xmlResolver.getGrammarComponent(node)) != null) {
            Collection attrDefCollection = elemDef.getAttributeDefs();
            for (AttributeDef attrDef : attrDefCollection) {
                String attrName = attrDef.getName();
                if (!attrName.endsWith("Listener")) continue;
                listenerList.add(attrName);
            }
        }
        return Collections.unmodifiableList(listenerList);
    }

    static {
        ArrayList<DefaultAttributeValueItem> gestureValueList = new ArrayList<DefaultAttributeValueItem>();
        gestureValueList.add(new DefaultAttributeValueItem("swipeRight"));
        gestureValueList.add(new DefaultAttributeValueItem("swipeLeft"));
        gestureValueList.add(new DefaultAttributeValueItem("tapHold"));
        gestureValueList.add(new DefaultAttributeValueItem("swipeUp"));
        gestureValueList.add(new DefaultAttributeValueItem("swipeDown"));
        gestureValueList.add(new DefaultAttributeValueItem("swipeStart"));
        gestureValueList.add(new DefaultAttributeValueItem("swipeEnd"));
        _gestureValues = Collections.unmodifiableList(gestureValueList);
    }
}

