/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.amx.dt.inspector.AmxDefaultAttributeValueProvider;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import org.w3c.dom.Node;

public final class FacetNameAttributeValueProvider
extends AmxDefaultAttributeValueProvider {
    private static final Map<String, List<String>> _AMX_PREFERRED_AUTOGENERATED_FACETS;
    private static final Map<String, List<String>> _AMX_ALLOWABLE_FACETS;
    private static final Map<String, List<String>> _DVT_ALLOWABLE_FACETS;
    private static final Map<String, List<String>> _ALLOWABLE_FACET_CHILDREN;
    private static final Map<String, Map<String, List<String>>> _ALLOWABLE_FACET_CHILD_ANCESTORS;

    public static List<String> collectNameValues(Node node) {
        if (node != null && node.getNodeType() == 1) {
            String namespace = node.getNamespaceURI();
            String elemName = node.getLocalName();
            return FacetNameAttributeValueProvider.collectFacetNameValues(namespace, elemName);
        }
        return new ArrayList<String>();
    }

    public static List<String> collectFacetNameValues(String namespace, String elemName) {
        ArrayList<String> valueList = new ArrayList<String>();
        if ("http://xmlns.oracle.com/adf/mf/amx".equals(namespace)) {
            FacetNameAttributeValueProvider._addAmxFacetNameValues(elemName, valueList);
        } else if ("http://xmlns.oracle.com/adf/mf/amx/dvt".equals(namespace)) {
            FacetNameAttributeValueProvider._addDvtFacetNameValues(elemName, valueList);
        }
        return valueList;
    }

    public static boolean isFacetRestrictingChildren(String facetName) {
        return _ALLOWABLE_FACET_CHILDREN.containsKey(facetName);
    }

    public static List<String> getValidFacetChildren(String facetName) {
        return _ALLOWABLE_FACET_CHILDREN.get(facetName);
    }

    public static boolean isFacetChildRestrictedByAncestors(String childName) {
        return _ALLOWABLE_FACET_CHILD_ANCESTORS.containsKey(childName);
    }

    public static Map<String, List<String>> getFacetChildAncestors(String childName) {
        return _ALLOWABLE_FACET_CHILD_ANCESTORS.get(childName);
    }

    @Override
    public List<AttributeValueItem> getAttributeValueItems() {
        Node parent = this.context.getOwnerNode().getParentNode();
        List<String> valueList = FacetNameAttributeValueProvider.collectNameValues(parent);
        ArrayList<DefaultAttributeValueItem> nameValueList = new ArrayList<DefaultAttributeValueItem>();
        for (String value : valueList) {
            nameValueList.add(new DefaultAttributeValueItem(value));
        }
        return Collections.unmodifiableList(nameValueList);
    }

    public static List<String> getPreferredFacets(Node node) {
        String nodeName;
        if (node != null && node.getNodeType() == 1 && "http://xmlns.oracle.com/adf/mf/amx".equals(node.getNamespaceURI()) && _AMX_PREFERRED_AUTOGENERATED_FACETS.containsKey(nodeName = node.getLocalName())) {
            return Collections.unmodifiableList(_AMX_PREFERRED_AUTOGENERATED_FACETS.get(nodeName));
        }
        return Collections.emptyList();
    }

    private static void _addAmxFacetNameValues(String elemName, List<String> valueList) {
        if (_AMX_ALLOWABLE_FACETS.containsKey(elemName)) {
            valueList.addAll((Collection<String>)_AMX_ALLOWABLE_FACETS.get(elemName));
        }
        if (_AMX_PREFERRED_AUTOGENERATED_FACETS.containsKey(elemName)) {
            valueList.addAll((Collection<String>)_AMX_PREFERRED_AUTOGENERATED_FACETS.get(elemName));
        }
    }

    private static void _addDvtFacetNameValues(String elemName, List<String> valueList) {
        if (_DVT_ALLOWABLE_FACETS.containsKey(elemName)) {
            valueList.addAll((Collection<String>)_DVT_ALLOWABLE_FACETS.get(elemName));
        }
    }

    static {
        HashMap<String, List<String>> preferredFacetsMap = new HashMap<String, List<String>>();
        preferredFacetsMap.put("panelSplitter", Arrays.asList("navigator"));
        preferredFacetsMap.put("carousel", Arrays.asList("nodeStamp"));
        _AMX_PREFERRED_AUTOGENERATED_FACETS = Collections.unmodifiableMap(preferredFacetsMap);
        HashMap<String, List<String>> allowableFacetsMap = new HashMap<String, List<String>>();
        allowableFacetsMap.put("panelPage", Arrays.asList("header", "primary", "secondary", "footer"));
        allowableFacetsMap.put("listView", Arrays.asList("header", "footer"));
        _AMX_ALLOWABLE_FACETS = Collections.unmodifiableMap(allowableFacetsMap);
        allowableFacetsMap = new HashMap();
        allowableFacetsMap.put("areaChart", Arrays.asList("dataStamp", "seriesStamp"));
        allowableFacetsMap.put("barChart", Arrays.asList("dataStamp", "seriesStamp"));
        allowableFacetsMap.put("bubbleChart", Arrays.asList("dataStamp"));
        allowableFacetsMap.put("comboChart", Arrays.asList("dataStamp", "seriesStamp"));
        allowableFacetsMap.put("horizontalBarChart", Arrays.asList("dataStamp", "seriesStamp"));
        allowableFacetsMap.put("lineChart", Arrays.asList("dataStamp", "seriesStamp"));
        allowableFacetsMap.put("pieChart", Arrays.asList("dataStamp"));
        allowableFacetsMap.put("scatterChart", Arrays.asList("dataStamp"));
        allowableFacetsMap.put("sparkChart", Arrays.asList("dataStamp"));
        _DVT_ALLOWABLE_FACETS = Collections.unmodifiableMap(allowableFacetsMap);
        HashMap<String, List<String>> allowableFacetChildren = new HashMap<String, List<String>>();
        allowableFacetChildren.put("seriesStamp", Arrays.asList("seriesStyle"));
        allowableFacetChildren.put("dataStamp", Arrays.asList("pieDataItem", "sparkDataItem", "chartDataItem"));
        allowableFacetChildren.put("nodeStamp", Arrays.asList("carouselItem"));
        _ALLOWABLE_FACET_CHILDREN = Collections.unmodifiableMap(allowableFacetChildren);
        HashMap<String, Map<String, List<String>>> allowableFacetChildAncestors = new HashMap<String, Map<String, List<String>>>();
        allowableFacetChildAncestors.put("pieDataItem", Collections.singletonMap("dataStamp", Arrays.asList("pieChart")));
        allowableFacetChildAncestors.put("sparkDataItem", Collections.singletonMap("dataStamp", Arrays.asList("sparkChart")));
        allowableFacetChildAncestors.put("chartDataItem", Collections.singletonMap("dataStamp", Arrays.asList("areaChart", "barChart", "bubbleChart", "comboChart", "horizontalBarChart", "lineChart", "scatterChart")));
        allowableFacetChildAncestors.put("seriesStyle", Collections.singletonMap("seriesStamp", Arrays.asList("areaChart", "barChart", "comboChart", "horizontalBarChart", "lineChart")));
        allowableFacetChildAncestors.put("carouselItem", Collections.singletonMap("nodeStamp", Arrays.asList("carousel")));
        _ALLOWABLE_FACET_CHILD_ANCESTORS = Collections.unmodifiableMap(allowableFacetChildAncestors);
    }
}

