/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.webapp.utils.html.ImageUtils;
import oracle.jdevimpl.webapp.inspector.propertyeditor.AbstractURLChooserPropertyEditor;

public class AmxImageUrlPropertyEditor
extends AbstractURLChooserPropertyEditor {
    private static final Map<String, String> _supportedImageTypeMap = new HashMap<String, String>();
    private URL _publicHtmlDirectoryUrl;
    private URL _amxDirectoryUrl;
    private URL _amxFileUrl;
    private static final String _PUBLIC_HTML_RELATIVE_PATH_PREFIX = "/";
    private static final String _ABSOLUTE_PATH_PREFIX;

    protected URLChooser createURLChooser() {
        URLChooser urlChooser = ImageUtils.getImageURLChooser((Context)this.getContext());
        urlChooser.setSelectionMode(0);
        urlChooser.setSelectionScope(0);
        urlChooser.removeShortcutButtons();
        urlChooser.clearChooseableURLFilters();
        this._setUrlChooserRootDirectory(urlChooser);
        this._setUrlChooserImageFilter(urlChooser);
        this._setUrlChooserInitialSelection(urlChooser);
        return urlChooser;
    }

    protected void dialogClosing(URLChooser urlChooser) throws PropertyVetoException {
        URL selectedUrl = urlChooser.getSelectedURL();
        this._validateImageUrl((Component)urlChooser, selectedUrl);
        String relativeUrl = this._getRelativePath(selectedUrl);
        this.setValue(relativeUrl);
    }

    private URL _getAmxDirectoryUrl() {
        if (null == this._amxDirectoryUrl) {
            this._amxDirectoryUrl = URLFileSystem.getParent((URL)this._getAmxFileUrl());
        }
        return this._amxDirectoryUrl;
    }

    private URL _getAmxFileUrl() {
        if (null == this._amxFileUrl) {
            Node nodeOwningSelection = this.getContext().getNode();
            assert (nodeOwningSelection instanceof AMXSourceNode);
            AMXSourceNode sourceNode = (AMXSourceNode)nodeOwningSelection;
            this._amxFileUrl = sourceNode.getURL();
        }
        return this._amxFileUrl;
    }

    private URL _getPublicHtmlDirectoryUrl() {
        if (null == this._publicHtmlDirectoryUrl) {
            this._publicHtmlDirectoryUrl = McAppUtils.getProjectPublicHtmlDir(this.getContext().getProject());
        }
        return this._publicHtmlDirectoryUrl;
    }

    private String _getRelativePath(URL selectedUrl) {
        URL publicHtmlUrl = this._getPublicHtmlDirectoryUrl();
        String relativePath = URLFileSystem.toRelativeSpec((URL)selectedUrl, (URL)publicHtmlUrl, (boolean)true);
        assert (ModelUtil.hasLength((String)relativePath));
        if (!relativePath.startsWith(_PUBLIC_HTML_RELATIVE_PATH_PREFIX)) {
            relativePath = _PUBLIC_HTML_RELATIVE_PATH_PREFIX + relativePath;
        }
        return relativePath;
    }

    private void _setUrlChooserInitialSelection(URLChooser urlChooser) {
        Object currentValue = this.getValue();
        String currentSelectedUrlPath = null;
        if (null != currentValue && currentValue instanceof String) {
            currentSelectedUrlPath = ((String)currentValue).trim();
        }
        URL initialUrl = null;
        if (ModelUtil.hasLength(currentSelectedUrlPath)) {
            URL absoluteUrl = null;
            absoluteUrl = currentSelectedUrlPath.startsWith(_ABSOLUTE_PATH_PREFIX) ? URLFactory.newURL((String)currentSelectedUrlPath) : (currentSelectedUrlPath.startsWith(_PUBLIC_HTML_RELATIVE_PATH_PREFIX) ? URLFactory.newURL((URL)this._getPublicHtmlDirectoryUrl(), (String)currentSelectedUrlPath) : URLFactory.newURL((URL)this._getAmxDirectoryUrl(), (String)currentSelectedUrlPath));
            if (this._isValidImageUrl(absoluteUrl)) {
                initialUrl = absoluteUrl;
            }
        }
        if (null == initialUrl) {
            initialUrl = this._getPublicHtmlDirectoryUrl();
        }
        urlChooser.setSelectedURL(initialUrl);
    }

    private void _setUrlChooserRootDirectory(URLChooser urlChooser) {
        urlChooser.setRoots(new URL[]{this._getPublicHtmlDirectoryUrl()});
    }

    private void _setUrlChooserImageFilter(URLChooser urlChooser) {
        DefaultURLFilter filter = new DefaultURLFilter(MobileResourceUtils.getText("IMAGE_FILTER_DESCRIPTION"), _supportedImageTypeMap.keySet().toArray(new String[0]));
        urlChooser.setURLFilter((URLFilter)filter);
    }

    private boolean _isFileAnImageFile(String fileName) {
        if (!ModelUtil.hasLength((String)fileName)) {
            return false;
        }
        String fileExtension = FileUtils.getFileExtension(fileName);
        return ModelUtil.hasLength((String)fileExtension) && _supportedImageTypeMap.containsKey(fileExtension);
    }

    private boolean _isValidImageUrl(URL imageUrl) {
        return this._doesFileExist(imageUrl) && this._isFileAnImageFile(URLFileSystem.getFileName((URL)imageUrl)) && this._isImageInPublicHtmlFolder(imageUrl);
    }

    private boolean _doesFileExist(URL fileUrl) {
        return null != fileUrl && URLFileSystem.exists((URL)fileUrl);
    }

    private boolean _isImageInPublicHtmlFolder(URL imageUrl) {
        return URLFileSystem.isBaseURLFor((URL)this._getPublicHtmlDirectoryUrl(), (URL)imageUrl);
    }

    private void _validateImageUrl(Component uiParent, URL imageUrl) throws PropertyVetoException {
        String dialogTitle = null;
        String errorMessage = null;
        if (!this._doesFileExist(imageUrl)) {
            dialogTitle = MobileResourceUtils.getText("ERR_INVALID_IMAGE_PATH_DLG_TITLE");
            errorMessage = MobileResourceUtils.getMsg("ADF-MBL-00007", imageUrl);
        } else if (!this._isFileAnImageFile(URLFileSystem.getFileName((URL)imageUrl))) {
            dialogTitle = MobileResourceUtils.getText("ERR_INVALID_IMAGE_TYPE_DLG_TITLE");
            errorMessage = MobileResourceUtils.getMsg("ADF-MBL-00009", URLFileSystem.getFileName((URL)imageUrl), FileUtils.buildCommaDelimitedStringFromMapKeys(_supportedImageTypeMap));
        } else if (!this._isImageInPublicHtmlFolder(imageUrl)) {
            dialogTitle = MobileResourceUtils.getText("ERR_INVALID_IMAGE_TYPE_DLG_TITLE");
            errorMessage = MobileResourceUtils.getMsg("ADF-MBL-02500", URLFileSystem.getFileName((URL)imageUrl), URLFileSystem.getPlatformPathName((URL)this._getPublicHtmlDirectoryUrl()));
        }
        if (ModelUtil.hasLength((String)dialogTitle) && ModelUtil.hasLength((String)errorMessage)) {
            JOptionPane.showMessageDialog(uiParent, errorMessage, dialogTitle, 0);
            throw new PropertyVetoException(errorMessage, null);
        }
    }

    static {
        _supportedImageTypeMap.put(".gif", null);
        _supportedImageTypeMap.put(".png", null);
        _supportedImageTypeMap.put(".jpg", null);
        _supportedImageTypeMap.put(".jpeg", null);
        _ABSOLUTE_PATH_PREFIX = String.format("%s%s%s", "file", ":", _PUBLIC_HTML_RELATIVE_PATH_PREFIX);
    }
}

