/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.adfdt.model.ide.insight.SecurityContextProvider;
import oracle.adfdt.model.ide.insight.SecurityDisplayable;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.Context;
import oracle.jdeveloper.el.Property;

public final class AMXSecurityContextProvider
implements SecurityContextProvider {
    private static final String _AUTHENTICATED = "authenticated";
    private static final String _USER_NAME = "userName";
    private static final String _USER_IN_ROLE = "userInRole";
    private static final String _USER_GRANTED_PRIVILEGE = "userGrantedPrivilege";
    private static final Map<String, Property> _SECURITY_PROPERTIES = new HashMap<String, Property>();

    public boolean applyCustomContext(Context ctx) {
        return AMXUtils.isSupportedNode(ctx.getNode());
    }

    public boolean appendProperties() {
        return false;
    }

    public Map<String, Property> getCustomSecurityContext() {
        return Collections.unmodifiableMap(_SECURITY_PROPERTIES);
    }

    static {
        _SECURITY_PROPERTIES.put(_AUTHENTICATED, (Property)new SecurityDisplayable(_AUTHENTICATED, MobileResourceUtils.getText("AUTHENTICATED_DESC"), MobileResourceUtils.getText("AUTHENTICATED_USAGE")));
        _SECURITY_PROPERTIES.put(_USER_NAME, (Property)new SecurityDisplayable(_USER_NAME, MobileResourceUtils.getText("USERNAME_DESC"), MobileResourceUtils.getText("USERNAME_USAGE")));
        _SECURITY_PROPERTIES.put(_USER_IN_ROLE, (Property)new SecurityDisplayable(_USER_IN_ROLE, MobileResourceUtils.getText("USERINROLE_DESC"), MobileResourceUtils.getText("USERINROLE_USAGE")));
        _SECURITY_PROPERTIES.put(_USER_GRANTED_PRIVILEGE, (Property)new SecurityDisplayable(_USER_GRANTED_PRIVILEGE, MobileResourceUtils.getText("USERGRANTEDPRIV_DESC"), MobileResourceUtils.getText("USERGRANTEDPRIV_USAGE")));
    }
}

