/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.inspector;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.model.ide.insight.BindingPropertiesFilter;
import oracle.adfdt.model.ide.insight.HintsAttrDisplayable;
import oracle.adfdt.model.ide.insight.InsightUtils;
import oracle.adfdt.model.ide.insight.SimpleAttributeDisplayable;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.CtrlHierTypeBinding;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.view.unified.binding.insight.CollectionModelProperty;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.ide.Context;
import oracle.ide.model.Displayable;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.el.DefaultMethod;
import oracle.jdeveloper.el.DefaultProperty;

public class AMXELBindingPropertiesFilter
implements BindingPropertiesFilter {
    private static final String _ACCESSOR_ITERATOR_BINDING = "accessorIterator";
    private static final String _ACTION_BINDING = "action";
    private static final String _ATTRIBUTE_VALUES_BINDING = "attributeValues";
    private static final String _BUTTON_BINDING = "button";
    private static final String _ITERATOR_BINDING = "iterator";
    private static final String _LIST_BINDING = "list";
    private static final String _METHOD_ACTION_BINDING = "methodAction";
    private static final String _METHOD_ITERATOR_BINDING = "methodIterator";
    private static final String _TREE_BINDING = "tree";
    private static final String _VARIABLE_ITERATOR_BINDING = "variableIterator";
    private static final String _ACCESSOR_ITER_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxAccessorIteratorBinding";
    private static final String _ACTION_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxActionBinding";
    private static final String _ATTR_VALUES_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxAttributeBinding";
    private static final String _ITER_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxIteratorBinding";
    private static final String _METHOD_ACTION_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxMethodActionBinding";
    private static final String _METHOD_ITER_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxMethodIteratorBinding";
    private static final String _TREE_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxTreeBinding";
    private static final String _VAR_ITER_BINDING_CLASS = "oracle.adfmf.bindings.dbf.AmxVariableIteratorBinding";
    private static final Map<String, String> _SUPPORTED_BINDING_TYPES = new HashMap<String, String>();
    private static final Map<String, Map<String, Displayable>> _SUPPORTED_BINDING_PROPERTIES;
    private static final Map<String, Displayable> _SUPPORTED_HINTS_MAP;

    public boolean applyBindingPropertiesFilter(Context ctx) {
        return AMXUtils.isSupportedNode(ctx.getNode());
    }

    public Map filterPropertiesMap(ControlBinding binding, Map propertiesMap) {
        String elementName = binding.getElement().getTagName();
        HashMap<String, AMXCollectionModelProperty> supportedPropertiesMap = new HashMap<String, AMXCollectionModelProperty>();
        if (_SUPPORTED_BINDING_TYPES.containsKey(elementName)) {
            Map<String, Displayable> supportedProperties = _SUPPORTED_BINDING_PROPERTIES.get(elementName);
            Set<Map.Entry<String, Displayable>> supportedPropertiesEntries = supportedProperties.entrySet();
            for (Map.Entry<String, Displayable> supportedPropertiesEntry : supportedPropertiesEntries) {
                String supportedPropertyName = supportedPropertiesEntry.getKey();
                if (!propertiesMap.containsKey(supportedPropertyName)) continue;
                if ("collectionModel".equals(supportedPropertyName)) {
                    supportedPropertiesMap.put(supportedPropertyName, new AMXCollectionModelProperty((CtrlHier)binding));
                    continue;
                }
                Object property = propertiesMap.get(supportedPropertyName);
                if (property instanceof DefaultMethod) {
                    supportedPropertiesMap.put(supportedPropertyName, (AMXCollectionModelProperty)supportedPropertiesEntry.getValue());
                    continue;
                }
                supportedPropertiesMap.put(supportedPropertyName, (AMXCollectionModelProperty)((Displayable)property));
            }
        }
        return Collections.unmodifiableMap(supportedPropertiesMap);
    }

    public Map filterHintsMap(ControlBinding binding, Map hintsMap) {
        StructureDefinition strDef;
        IteratorBinding itrBnd;
        String elementName;
        HashMap<String, Object> supportedHintsMap = new HashMap<String, Object>();
        if (hintsMap != null && !hintsMap.isEmpty()) {
            Set<Map.Entry<String, Displayable>> supportedHintsEntries = _SUPPORTED_HINTS_MAP.entrySet();
            for (Map.Entry<String, Displayable> supportedHintsEntry : supportedHintsEntries) {
                String hint = supportedHintsEntry.getKey();
                if (!hintsMap.containsKey(hint)) continue;
                supportedHintsMap.put(hint, (Displayable)hintsMap.get(hint));
            }
        }
        if (_TREE_BINDING.equals(elementName = binding.getElement().getTagName()) && (itrBnd = binding.getIteratorBinding()) != null && itrBnd.getDataControl() != null && (strDef = itrBnd.getDefinition()) != null) {
            DefinitionContainer defCont = strDef.getAttributeDefinitions();
            if (binding instanceof CtrlHier) {
                for (Definition def : defCont) {
                    if (!(def instanceof NamedDefinition)) continue;
                    HintsAttrDisplayable hintsAttrDispl = new HintsAttrDisplayable((NamedDefinition)def, (BaseElementObject)binding);
                    hintsAttrDispl.clear();
                    hintsAttrDispl.putAll(_SUPPORTED_HINTS_MAP);
                    supportedHintsMap.put(((NamedDefinition)def).getName(), hintsAttrDispl);
                }
            }
        }
        return Collections.unmodifiableMap(supportedHintsMap);
    }

    public boolean isFilterHintsMap() {
        return true;
    }

    private static void _findSupportedBindingsProperties() {
        URLClassLoader javaFrameworkClassLoader = AMXUtils.getJavaFrameworkClassLoader();
        for (Map.Entry<String, String> bindingTypeEntry : _SUPPORTED_BINDING_TYPES.entrySet()) {
            HashMap<String, DefaultMethod> supportedProperties = new HashMap<String, DefaultMethod>();
            Set<Method> methodSet = AMXUtils.getPropertyMethods(javaFrameworkClassLoader, bindingTypeEntry.getValue(), false);
            for (Method method : methodSet) {
                String returnType;
                String[] parameterTypes;
                String methodName = method.getName();
                if (AMXELBindingPropertiesFilter._isGetExecuteMethod(methodName, parameterTypes = AMXUtils.getJavaTypesAsStrings(method.getParameterTypes()), returnType = method.getReturnType().getName()) || !AMXUtils.isPropertyAccessor(method) && !AMXMetadataResolver.isActionListenerSupported(method)) continue;
                String propertyName = AMXUtils.getPropertyName(methodName);
                supportedProperties.put(propertyName, new DefaultMethod(propertyName, parameterTypes, returnType));
            }
            _SUPPORTED_BINDING_PROPERTIES.put(bindingTypeEntry.getKey(), supportedProperties);
        }
    }

    private static boolean _isGetExecuteMethod(String methodName, String[] methodParameterTypes, String methodReturnType) {
        String getExecuteMethod = "getExecute";
        String getExecuteMethodReturnType = "java.lang.Object";
        boolean getExecuteMethodParameterTypes = false;
        return "getExecute".equals(methodName) && "java.lang.Object".equals(methodReturnType) && 0 == methodParameterTypes.length;
    }

    static {
        _SUPPORTED_BINDING_TYPES.put(_ACCESSOR_ITERATOR_BINDING, _ACCESSOR_ITER_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_ACTION_BINDING, _ACTION_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_ATTRIBUTE_VALUES_BINDING, _ATTR_VALUES_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_BUTTON_BINDING, _ATTR_VALUES_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_ITERATOR_BINDING, _ITER_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_LIST_BINDING, _ATTR_VALUES_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_METHOD_ACTION_BINDING, _METHOD_ACTION_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_METHOD_ITERATOR_BINDING, _METHOD_ITER_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_TREE_BINDING, _TREE_BINDING_CLASS);
        _SUPPORTED_BINDING_TYPES.put(_VARIABLE_ITERATOR_BINDING, _VAR_ITER_BINDING_CLASS);
        _SUPPORTED_BINDING_PROPERTIES = new HashMap<String, Map<String, Displayable>>();
        AMXELBindingPropertiesFilter._findSupportedBindingsProperties();
        _SUPPORTED_HINTS_MAP = new HashMap<String, Displayable>();
        _SUPPORTED_HINTS_MAP.put("format", (Displayable)new SimpleAttributeDisplayable("format", ADFMobileConstants.STRING_TYPE));
        _SUPPORTED_HINTS_MAP.put("label", (Displayable)new SimpleAttributeDisplayable("label", ADFMobileConstants.STRING_TYPE));
        _SUPPORTED_HINTS_MAP.put("updateable", (Displayable)new SimpleAttributeDisplayable("updateable", ADFMobileConstants.STRING_TYPE));
        _SUPPORTED_HINTS_MAP.put("mandatory", (Displayable)new SimpleAttributeDisplayable("mandatory", ADFMobileConstants.STRING_TYPE));
        _SUPPORTED_HINTS_MAP.put("precision", (Displayable)new SimpleAttributeDisplayable("precision", ADFMobileConstants.STRING_TYPE));
    }

    private static class AMXCollectionModelProperty
    extends CollectionModelProperty {
        private AMXCollectionModelProperty(CtrlHier binding) {
            super(binding);
        }

        public String getType() {
            return null;
        }

        public String getComponentType() {
            return null;
        }

        public List getComponentTypeExtraProperties() {
            ArrayList<DefaultProperty> props = new ArrayList<DefaultProperty>();
            if (this.getBinding().getTypeBindings() != null) {
                for (Object obj : this.getBinding().getTypeBindings()) {
                    if (!(obj instanceof CtrlHierTypeBinding)) continue;
                    CtrlHierTypeBinding type = (CtrlHierTypeBinding)obj;
                    for (String attr : type.getAttrNames()) {
                        DefaultProperty prop = new DefaultProperty(attr, OracleIcons.getIcon((String)"beanattribute.png")){

                            public List getComponentTypeExtraProperties() {
                                ArrayList<DefaultProperty> childProps = new ArrayList<DefaultProperty>();
                                Map supportedProps = (Map)_SUPPORTED_BINDING_PROPERTIES.get(AMXELBindingPropertiesFilter._ATTRIBUTE_VALUES_BINDING);
                                for (Displayable disp : InsightUtils.getPredefinedELProperties((String)"ValueBinding")) {
                                    if (!supportedProps.containsKey(disp.getShortLabel())) continue;
                                    childProps.add(new DefaultProperty(disp.getShortLabel(), disp.getIcon()));
                                }
                                return childProps;
                            }
                        };
                        props.add(prop);
                    }
                }
            }
            final ArrayList bindingsChildProps = new ArrayList(props);
            DefaultProperty bindingsProp = new DefaultProperty("bindings", OracleIcons.getIcon((String)"beanattribute.png")){

                public List getComponentTypeExtraProperties() {
                    return bindingsChildProps;
                }
            };
            props.add(bindingsProp);
            props.add(new DefaultProperty("selectedRow", OracleIcons.getIcon((String)"beanattribute.png")));
            props.add(new DefaultProperty("makeCurrent", OracleIcons.getIcon((String)"beanattribute.png")));
            return props;
        }
    }
}

