/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.quickstart;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import oracle.adfmf.amx.dt.editor.quickstart.SelectionMgr;
import oracle.adfmf.amx.dt.inspector.FacetNameAttributeValueProvider;

public final class FacetSelection {
    private static final String _NONE_SELECTED_IMAGE_NAME = "none";
    private static final String _PANEL_PAGE_PATTERN_START = "<amx:panelPage id=\"pp1\">";
    private static final String _PANEL_PAGE_PATTERN_END = "</amx:panelPage>";
    private static final String _HEADER_PATTERN = "<amx:facet name=\"header\"><amx:outputText value=\"Header\" id=\"ot1\"/></amx:facet>";
    private static final String _FOOTER_PATTERN = "<amx:facet name=\"footer\"><amx:outputText value=\"Footer\" id=\"ot2\"/></amx:facet>";
    private static final String _PRIMARY_PATTERN = "<amx:facet name=\"primary\"><amx:commandButton id=\"cb1\"/></amx:facet>";
    private static final String _SECONDARY_PATTERN = "<amx:facet name=\"secondary\"><amx:commandButton id=\"cb2\"/></amx:facet>";
    private static final Map<String, String> _FACET_PATTERN_MAP = new HashMap<String, String>();
    private Map<String, Boolean> _facetSelectionMap = SelectionMgr.getInstance().getLastSelectionMap();

    public FacetSelection() {
        if (this._facetSelectionMap == null) {
            this._facetSelectionMap = new LinkedHashMap<String, Boolean>();
            List<String> facetNames = FacetNameAttributeValueProvider.collectFacetNameValues("http://xmlns.oracle.com/adf/mf/amx", "panelPage");
            for (String facetName : facetNames) {
                if ("footer".equals(facetName)) {
                    this._facetSelectionMap.put(facetName, false);
                    continue;
                }
                this._facetSelectionMap.put(facetName, true);
            }
        }
    }

    public Map<String, Boolean> getSelectionMap() {
        return this._facetSelectionMap;
    }

    public void setSelection(String facetName, boolean isSelected) {
        this._facetSelectionMap.put(facetName, isSelected);
    }

    public ImageIcon getSelectionImage() {
        String fileName = this.getImageFileName();
        return SelectionMgr.getInstance().getSelectionImage(fileName);
    }

    public boolean isFacetSelected(String facetName) {
        return this._facetSelectionMap.get(facetName);
    }

    public String generatePanelPageWithFacets() {
        StringBuilder strBuilder = new StringBuilder(_PANEL_PAGE_PATTERN_START);
        for (Map.Entry<String, Boolean> facetEntry : this._facetSelectionMap.entrySet()) {
            String facetName = facetEntry.getKey();
            boolean isSelected = facetEntry.getValue();
            if (!isSelected) continue;
            strBuilder.append(_FACET_PATTERN_MAP.get(facetName));
        }
        strBuilder.append(_PANEL_PAGE_PATTERN_END);
        return strBuilder.toString();
    }

    private String getImageFileName() {
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry<String, Boolean> facetEntry : this._facetSelectionMap.entrySet()) {
            String facetName = facetEntry.getKey();
            boolean isSelected = facetEntry.getValue();
            if (!isSelected) continue;
            strBuilder.append(facetName.substring(0, 1));
        }
        if (strBuilder.length() == 0) {
            strBuilder.append(_NONE_SELECTED_IMAGE_NAME);
        }
        strBuilder.append(".png");
        return strBuilder.toString();
    }

    static {
        _FACET_PATTERN_MAP.put("header", _HEADER_PATTERN);
        _FACET_PATTERN_MAP.put("primary", _PRIMARY_PATTERN);
        _FACET_PATTERN_MAP.put("secondary", _SECONDARY_PATTERN);
        _FACET_PATTERN_MAP.put("footer", _FOOTER_PATTERN);
    }
}

