/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.quickstart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.adfmf.amx.dt.editor.AMXFileBuilderPanel;
import oracle.adfmf.amx.dt.editor.quickstart.FacetSelection;
import oracle.ide.Context;
import oracle.javatools.ui.TitledSeparator;

public final class AmxFileBuilderWithPageFacetPanel
extends AMXFileBuilderPanel
implements ActionListener {
    private final Box _imageHolder = Box.createVerticalBox();
    private final FacetSelection _facetSelection = new FacetSelection();

    public AmxFileBuilderWithPageFacetPanel(Context context) {
        super(context);
        this._addFacets();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)target;
            String text = cb.getText();
            this._facetSelection.setSelection(this._getCheckboxFacetName(text), cb.isSelected());
            this._displaySelectionImage();
        }
    }

    public FacetSelection getFacetSelection() {
        return this._facetSelection;
    }

    private void _addFacets() {
        boolean gridx = false;
        int gridy = 4;
        TitledSeparator separator = new TitledSeparator("Page Facets");
        this.add((Component)separator, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(16, 0, 8, 0), 0, 0));
        this._imageHolder.add(new JLabel(this._facetSelection.getSelectionImage()));
        this.add(this._imageHolder, new GridBagConstraints(0, 5, 1, 4, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        JCheckBox headerCb = new JCheckBox("Header", this._facetSelection.isFacetSelected("header"));
        JCheckBox primaryCb = new JCheckBox("Primary Action", this._facetSelection.isFacetSelected("primary"));
        JCheckBox secondaryCb = new JCheckBox("Secondary Action", this._facetSelection.isFacetSelected("secondary"));
        JCheckBox footerCb = new JCheckBox("Footer", this._facetSelection.isFacetSelected("footer"));
        this.add(headerCb, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(primaryCb, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(secondaryCb, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(footerCb, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        headerCb.addActionListener(this);
        primaryCb.addActionListener(this);
        secondaryCb.addActionListener(this);
        footerCb.addActionListener(this);
    }

    private String _getCheckboxFacetName(String display) {
        String[] words = display.split(" ");
        return words[0].toLowerCase();
    }

    private void _displaySelectionImage() {
        ImageIcon image = this._facetSelection.getSelectionImage();
        this._imageHolder.remove(0);
        this._imageHolder.add(new JLabel(image));
        this.revalidate();
    }
}

