/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.quickstart;

import java.util.HashMap;
import oracle.adfmf.amx.dt.editor.AMXFileBuilderModel;
import oracle.adfmf.common.util.XmlUtils;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.ide.Context;
import oracle.ide.model.Node;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public final class AmxFileBuilderWithPageFacetModel
extends AMXFileBuilderModel {
    private static final String _TXN_NAME = "Insert panelPage with enabled facets";
    private String _selectedFacetsPattern = null;

    public AmxFileBuilderWithPageFacetModel(Context context) {
        super(context);
    }

    public void setSelectedFacetsPattern(String facetsPattern) {
        this._selectedFacetsPattern = facetsPattern;
    }

    @Override
    protected boolean buildFile(Node node) {
        assert (this._selectedFacetsPattern != null);
        if (super.buildFile(node)) {
            XmlModel model = this.getFileXmlModel(node);
            new FixedNameTransactionTask(_TXN_NAME){

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Element root = model.getDocument().getDocumentElement();
                    DocumentFragment pageFragment = AmxFileBuilderWithPageFacetModel.this._getPanelPageFragment(model);
                    if (root != null && pageFragment != null) {
                        root.appendChild(pageFragment);
                    }
                }
            }.run((AbstractModel)model);
            XmlUtils.setDefaultSelection((AbstractModel)model);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentFragment _getPanelPageFragment(AbstractModel model) {
        model.acquireReadLock();
        try {
            DomModel domModel = model.getDomModel();
            Document document = model.getDocument();
            HashMap<String, String> prefixMap = new HashMap<String, String>(1);
            prefixMap.put("amx", "http://xmlns.oracle.com/adf/mf/amx");
            DomModel.FragmentParseResult result = domModel.parseFragment((org.w3c.dom.Node)document, prefixMap, this._selectedFacetsPattern);
            if (result != null) {
                DocumentFragment documentFragment = result.getDocumentFragment();
                return documentFragment;
            }
        }
        finally {
            model.releaseReadLock();
        }
        return null;
    }
}

