/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.el;

import java.awt.Image;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.ADFMobileResourceBundleUtils;
import oracle.adfmf.common.util.ELUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.resourcebundle.ResourceBundleManagerDT;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.resourcebundle.ResourceBundleManager;
import oracle.javatools.resourcebundle.ResourceBundleWrapper;
import oracle.jdeveloper.el.DefaultMethod;
import oracle.jdeveloper.el.DefaultProperty;
import oracle.jdeveloper.el.ELManager;
import oracle.jdeveloper.el.ELType;
import oracle.jdeveloper.el.Property;
import oracle.jdeveloper.el.VariableProvider;
import oracle.jdevimpl.webapp.jsp.taglibraries.jsf.JsfArb;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AMXVariableProvider
extends VariableProvider {
    private Map<AMXProperty, Map> _preferenceScopeMap = null;
    private static final Map<String, String> _prefElementLongLabelMap;
    private static final Icon _prefGroupIcon;
    private static final Icon _prefPageIcon;
    private static final Icon _prefElementIcon;
    private static final Map<String, Icon> _prefElementIconMap;
    private static final String _ROW_KEY = "rowKey";
    private static final String _APPLICATION_SCOPE = "applicationScope";
    private static final String _DEVICE_SCOPE = "deviceScope";
    private static final String _PAGE_FLOW_SCOPE = "pageFlowScope";
    private static final String _PREFERENCE_SCOPE = "preferenceScope";
    private static final String _VIEW_SCOPE = "viewScope";
    private static final String _APPLICATION_SCOPE_LONG_LABEL;
    private static final String _DEVICE_SCOPE_LONG_LABEL;
    private static final String _PAGE_FLOW_SCOPE_LONG_LABEL;
    private static final String _PREFERENCE_SCOPE_LONG_LABEL;
    private static final String _VIEW_SCOPE_LONG_LABEL;
    private static final List<Property> _amxObjects;
    private static final String _AMX_COLLECTION_VARIABLE_KEY = "AMXCollectionVariable_Key";
    private static final String _RESOURCE_BUNDLE_VARIABLE_KEY = "ResourceBundleVariable_Key";
    private static final String _SHORT_LABEL;
    private static final String _LONG_LABEL;

    public String getShortLabel() {
        return _SHORT_LABEL;
    }

    public String getLongLabel() {
        return _LONG_LABEL;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"mobile_client_page.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    public boolean supportsContext(Context context, Object location, ELType type) {
        Node node = context.getNode();
        return node != null && (node instanceof AMXSourceNode || node instanceof FeatureXmlSourceNode || node instanceof FrameworkXmlSourceNode);
    }

    public Set getVariables(Context context, Object location, ELType type, Map cache) {
        HashSet<Property> variableSet = new HashSet<Property>();
        if (AMXUtils.isSupportedNode(context.getNode())) {
            variableSet.addAll(_amxObjects);
            List<AMXVariable> collectionVariables = this._getCollectionBasedVariable(context, location, cache);
            this._setVariables(variableSet, collectionVariables);
        }
        List<AMXVariable> resourceBundleVariables = this._getResourceBundleVariable(context, location, cache);
        this._setVariables(variableSet, resourceBundleVariables);
        return variableSet;
    }

    public Set getVariables(Context context, Object location, ELType type) {
        return this.getVariables(context, location, type, null);
    }

    public Set getProperties(Context context, Object location, ELType type, List variableNameTokens, Map cache) {
        if (variableNameTokens != null && !variableNameTokens.isEmpty()) {
            List tokens = variableNameTokens;
            String variableNameToken = (String)variableNameTokens.get(variableNameTokens.size() - 1);
            if (_APPLICATION_SCOPE.equals(variableNameToken) || _PAGE_FLOW_SCOPE.equals(variableNameToken) || _VIEW_SCOPE.equals(variableNameToken)) {
                return Collections.emptySet();
            }
            if (variableNameTokens.contains(_DEVICE_SCOPE)) {
                Set deviceScopeProperties = DeviceScopeVariable.getDeviceScopeProperties(AMXVariableProvider._getKey(tokens));
                if (deviceScopeProperties != null) {
                    return deviceScopeProperties;
                }
            } else {
                if (variableNameTokens.contains(_PREFERENCE_SCOPE)) {
                    if (variableNameTokens.size() == 1 && _PREFERENCE_SCOPE.equals(variableNameToken)) {
                        this._populatePrefScopeMap(context);
                    }
                    return this._getPrefScopeProperties(variableNameTokens);
                }
                HashSet<Displayable> variablePropertiesSet = new HashSet<Displayable>();
                List<AMXVariable> collectionVariables = this._getCollectionBasedVariable(context, location, cache);
                this._setVariableProperties(variablePropertiesSet, collectionVariables, tokens);
                List<AMXVariable> resourceBundleVariables = this._getResourceBundleVariable(context, location, cache);
                this._setVariableProperties(variablePropertiesSet, resourceBundleVariables, tokens);
                return variablePropertiesSet;
            }
        }
        return Collections.emptySet();
    }

    public Set getProperties(Context context, Object location, ELType type, List variableNameTokens) {
        return this.getProperties(context, location, type, variableNameTokens, null);
    }

    public Property getProperty(Context context, Object location, ELType type, List propertyNameTokens) {
        return null;
    }

    private static String _getKey(List<String> variableNameTokens) {
        int size = variableNameTokens.size();
        if (size == 1) {
            return variableNameTokens.get(0);
        }
        StringBuilder keyStr = new StringBuilder(2 * size);
        for (String variableNameToken : variableNameTokens) {
            keyStr.append(variableNameToken + ".");
        }
        return keyStr.substring(0, keyStr.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AMXVariable> _getCollectionBasedVariable(Context context, Object location, Map<String, IdentityHashMap<Object, List<AMXVariable>>> cache) {
        List<AMXVariable> amxVariables = this._getFromCache(location, cache, _AMX_COLLECTION_VARIABLE_KEY);
        if (amxVariables != null) {
            return amxVariables;
        }
        if (!(location instanceof Element)) {
            return null;
        }
        XmlModel model = null;
        AMXVariable amxVariable = null;
        JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)context);
        if (xmlContext != null) {
            model = xmlContext.getModel();
        }
        if (model == null) {
            return null;
        }
        model.acquireReadLock();
        try {
            amxVariable = this._doGatherCollectionVariable(context, model, (org.w3c.dom.Node)location, cache);
        }
        finally {
            model.releaseReadLock();
        }
        amxVariables = amxVariable != null ? Collections.singletonList(amxVariable) : Collections.emptyList();
        this._addToCache(location, cache, _AMX_COLLECTION_VARIABLE_KEY, amxVariables);
        return amxVariables;
    }

    private AMXVariable _doGatherCollectionVariable(Context context, XmlModel model, org.w3c.dom.Node node, Map cache) {
        Element element;
        do {
            if (node.getNodeType() != 1) {
                return null;
            }
            element = (Element)node;
            if (!this._isCollectionSupported(model, node)) continue;
            return this._gatherCollectionVariable(context, element, cache);
        } while ((node = element.getParentNode()) != null);
        return null;
    }

    private AMXVariable _gatherCollectionVariable(Context context, Element element, Map cache) {
        String varValue = element.getAttributeNS(null, "var");
        if (varValue != null && !varValue.isEmpty()) {
            List extraProps = Collections.emptyList();
            String valueExpr = element.getAttributeNS(null, "value");
            if (ELUtils.isELExpression(valueExpr)) {
                String trimmed = valueExpr.substring(2, valueExpr.length() - 1);
                List tokenized = ELManager.getELManager().tokenizeExpression(trimmed);
                Property property = ELManager.getELManager().getProperty(context, (Object)element, ELType.JSF, tokenized, cache);
                if (property != null) {
                    List props;
                    extraProps = props = property.getComponentTypeExtraProperties();
                }
            }
            DefaultProperty parent = new DefaultProperty(varValue);
            AMXVariable collectionVar = new AMXVariable((Property)parent, this._convertProp(extraProps));
            this._createMap(collectionVar);
            return collectionVar;
        }
        return null;
    }

    private Set<AMXVariable> _convertProp(List<Property> props) {
        HashSet<AMXVariable> vars = null;
        if (props != null && !props.isEmpty()) {
            vars = new HashSet<AMXVariable>(props.size());
            for (Property childProp : props) {
                List childProps = childProp.getComponentTypeExtraProperties();
                vars.add(new AMXVariable(childProp, this._convertProp(childProps)));
            }
        }
        return vars;
    }

    private void _createMap(AMXVariable collectionVar) {
        HashMap<String, Set<Displayable>> propMap = new HashMap<String, Set<Displayable>>();
        HashSet<Object> childSet = new HashSet<Object>();
        String key = collectionVar.getProperty().getShortLabel();
        Set<AMXVariable> childrenSet = collectionVar.getChildren();
        if (childrenSet.isEmpty()) {
            propMap.put(key, null);
            return;
        }
        for (AMXVariable var : childrenSet) {
            Property prop = var.getProperty();
            if (prop == null) continue;
            childSet.add(prop);
            if ("bindings".equals(prop.getShortLabel())) {
                this._addBindings(propMap, var, key);
                continue;
            }
            this._addAttributeProperties(propMap, var, key);
        }
        childSet.add(new DefaultProperty(_ROW_KEY));
        propMap.put(key, childSet);
        collectionVar.setMap(propMap);
    }

    private void _addAttributeProperties(Map<String, Set<Displayable>> propMap, AMXVariable variable, String parentKey) {
        String key = parentKey + "." + variable.getProperty().getShortLabel();
        propMap.put(key, variable.getChildrenProperties());
    }

    private void _addBindings(Map<String, Set<Displayable>> propMap, AMXVariable variable, String parentKey) {
        String key = parentKey + "." + variable.getProperty().getShortLabel();
        HashSet<Property> childSet = new HashSet<Property>();
        for (AMXVariable var : variable.getChildren()) {
            childSet.add(var.getProperty());
            propMap.put(key + "." + var.getProperty().getShortLabel(), var.getChildrenProperties());
        }
        propMap.put(key, childSet);
    }

    private boolean _isCollectionSupported(XmlModel model, org.w3c.dom.Node node) {
        XmlKey key = model.getNodeXmlKey(node);
        for (AMXCollectionXmlKey collectionKey : AMXCollectionXmlKey.values()) {
            if (!collectionKey.getXmlKey().equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    private void _populatePrefScopeMap(Context context) {
        this._preferenceScopeMap = new HashMap<AMXProperty, Map>(1);
        HashMap<AMXProperty, Map<AMXProperty, Map>> prefScopeChildMap = new HashMap<AMXProperty, Map<AMXProperty, Map>>(1);
        prefScopeChildMap.put(new AMXProperty("application", OracleIcons.getIcon((String)"folder.png")), this._getApplicationPrefMap(context));
        prefScopeChildMap.put(new AMXProperty("feature", OracleIcons.getIcon((String)"folder.png")), this._getFeaturePrefMap(context));
        this._preferenceScopeMap.put(new AMXProperty(_PREFERENCE_SCOPE), prefScopeChildMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AMXProperty, Map> _getApplicationPrefMap(Context context) {
        Map<AMXProperty, Map> applicationPrefMap;
        block6: {
            FrameworkXmlSourceNode node;
            applicationPrefMap = new HashMap<AMXProperty, Map>(1);
            Workspace workspace = context.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            if ((node = McAppUtils.findOrCreateApplicationXml(workspace)) != null) {
                JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
                XmlModel model = xmlContext.getRelatedXmlModel(node.getURL());
                model.acquireReadLock();
                try {
                    Element rootNode = model.getDocument().getDocumentElement();
                    NodeList rootChildNodes = rootNode.getChildNodes();
                    if (rootChildNodes == null) break block6;
                    for (int i = 0; i < rootChildNodes.getLength(); ++i) {
                        org.w3c.dom.Node rootChild = rootChildNodes.item(i);
                        if (!(rootChild instanceof Element) || !"preferences".equals(rootChild.getLocalName())) continue;
                        applicationPrefMap = this._traversePrefNode(rootChild);
                        break;
                    }
                }
                finally {
                    model.releaseReadLock();
                }
            }
        }
        return applicationPrefMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AMXProperty, Map> _getFeaturePrefMap(Context context) {
        HashMap<AMXProperty, Map> featurePrefMap = new HashMap<AMXProperty, Map>(1);
        Project project = context.getProject();
        FeatureXmlSourceNode node = McAppUtils.findOrCreateFeatureXml(project);
        if (node != null) {
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
            XmlModel model = xmlContext.getRelatedXmlModel(node.getURL());
            model.acquireReadLock();
            try {
                Element rootNode = model.getDocument().getDocumentElement();
                NodeList rootChildNodes = rootNode.getChildNodes();
                if (rootChildNodes != null) {
                    block3: for (int i = 0; i < rootChildNodes.getLength(); ++i) {
                        NodeList featureChildNodes;
                        String id;
                        org.w3c.dom.Node rootChild = rootChildNodes.item(i);
                        if (!(rootChild instanceof Element) || !"feature".equals(rootChild.getLocalName()) || (id = ((Element)rootChild).getAttributeNS(null, "id")) == null || id.trim().length() <= 0 || (featureChildNodes = rootChild.getChildNodes()) == null) continue;
                        for (int j = 0; j < featureChildNodes.getLength(); ++j) {
                            org.w3c.dom.Node featureChild = featureChildNodes.item(j);
                            if (!(featureChild instanceof Element) || !"preferences".equals(featureChild.getLocalName())) continue;
                            int dotIndex = id.indexOf(".");
                            if (dotIndex != -1) {
                                featurePrefMap.put(new AMXProperty(id.substring(0, dotIndex)), this._getFeatureSubMap(id.substring(dotIndex + 1), featureChild));
                                continue block3;
                            }
                            featurePrefMap.put(new AMXProperty(id), this._traversePrefNode(featureChild));
                            continue block3;
                        }
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return featurePrefMap;
    }

    private Map<AMXProperty, Map> _traversePrefNode(org.w3c.dom.Node node) {
        HashMap<AMXProperty, Map> childNodesMap = new HashMap<AMXProperty, Map>(1);
        if (node != null && node instanceof Element) {
            NodeList childNodesList = node.getChildNodes();
            for (int i = 0; i < childNodesList.getLength(); ++i) {
                org.w3c.dom.Node childNode = childNodesList.item(i);
                if (childNode == null || !(childNode instanceof Element)) continue;
                String id = null;
                id = "preferenceValue".equals(childNode.getLocalName()) ? ((Element)childNode).getAttributeNS(null, "name") : ((Element)childNode).getAttributeNS(null, "id");
                if (id == null || id.trim().length() <= 0) continue;
                int dotIndex = id.indexOf(".");
                if (dotIndex != -1) {
                    childNodesMap.put(new AMXProperty(id.substring(0, dotIndex), _prefElementLongLabelMap.get(childNode.getLocalName()), _prefElementIconMap.get(childNode.getLocalName())), this._getPreferenceSubMap(id.substring(dotIndex + 1), childNode));
                    continue;
                }
                childNodesMap.put(new AMXProperty(id, _prefElementLongLabelMap.get(childNode.getLocalName()), _prefElementIconMap.get(childNode.getLocalName())), this._traversePrefNode(childNode));
            }
        }
        return childNodesMap;
    }

    private Set<Property> _getPrefScopeProperties(List variableNameTokens) {
        Map prefMap = this._preferenceScopeMap;
        for (int i = 0; i < variableNameTokens.size(); ++i) {
            Map prefPropertiesMap;
            AMXProperty keyProp = new AMXProperty((String)variableNameTokens.get(i));
            if (prefMap == null) break;
            prefMap = prefPropertiesMap = prefMap.get(keyProp);
        }
        if (prefMap != null) {
            Set<AMXProperty> amxPropSet = prefMap.keySet();
            HashSet<Property> propSet = new HashSet<Property>();
            Iterator<AMXProperty> it = amxPropSet.iterator();
            while (it.hasNext()) {
                propSet.add(it.next().getProperty());
            }
            return propSet;
        }
        return Collections.emptySet();
    }

    private static ImageIcon _createImageIcon(String path, String description) {
        Image image = ImageUtils.getImageResource(AMXVariableProvider.class, (String)path);
        if (image != null) {
            return new ImageIcon(image, description);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AMXVariable> _getResourceBundleVariable(Context context, Object location, Map<String, IdentityHashMap<Object, List<AMXVariable>>> cache) {
        List<AMXVariable> amxVariables = this._getFromCache(location, cache, _RESOURCE_BUNDLE_VARIABLE_KEY);
        if (amxVariables != null) {
            return amxVariables;
        }
        if (!(location instanceof Element)) {
            return null;
        }
        XmlModel model = null;
        JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)context);
        if (xmlContext != null) {
            model = xmlContext.getModel();
        }
        if (model == null) {
            return null;
        }
        model.acquireReadLock();
        try {
            amxVariables = this._parseResourceBundleVariable(context, model, (org.w3c.dom.Node)location);
        }
        finally {
            model.releaseReadLock();
        }
        this._addToCache(location, cache, _RESOURCE_BUNDLE_VARIABLE_KEY, amxVariables);
        return amxVariables;
    }

    private List<AMXVariable> _getFromCache(Object location, Map<String, IdentityHashMap<Object, List<AMXVariable>>> cache, String cacheKey) {
        IdentityHashMap<Object, List<AMXVariable>> variableCacheMap;
        if (cache != null && (variableCacheMap = cache.get(cacheKey)) != null && variableCacheMap.containsKey(location)) {
            return variableCacheMap.get(location);
        }
        return null;
    }

    private void _addToCache(Object location, Map<String, IdentityHashMap<Object, List<AMXVariable>>> cache, String cacheKey, List<AMXVariable> object) {
        if (cache != null) {
            IdentityHashMap<Object, List<AMXVariable>> variableCacheMap = cache.get(cacheKey);
            if (variableCacheMap == null) {
                variableCacheMap = new IdentityHashMap();
            }
            variableCacheMap.put(location, object);
            cache.put(cacheKey, variableCacheMap);
        }
    }

    private List<AMXVariable> _parseResourceBundleVariable(Context context, XmlModel model, org.w3c.dom.Node node) {
        ArrayList<AMXVariable> amxVariableList = new ArrayList<AMXVariable>();
        Set<String> possibleBundleVars = ELUtils.getAttributeELValueFirstProperties(node);
        List<Element> loadBundles = ADFMobileResourceBundleUtils.findApplicableLoadBundles(model, possibleBundleVars);
        if (loadBundles != null) {
            for (Element loadBundle : loadBundles) {
                amxVariableList.add(this._enumerateResourceBundleKeys(context, loadBundle));
            }
        }
        return amxVariableList;
    }

    private AMXVariable _enumerateResourceBundleKeys(Context context, Element element) {
        String varValue = element.getAttributeNS(null, "var");
        HashSet<AMXVariable> childrenVariables = new HashSet<AMXVariable>();
        if (varValue != null && !varValue.isEmpty()) {
            Workspace ps;
            String valueExpr = element.getAttributeNS(null, "basename");
            ResourceBundleManagerDT resourceBundleManagerDT = (ResourceBundleManagerDT)ResourceBundleManager.getResourceBundleManager();
            ResourceBundleWrapper resourceBundleWrapper = resourceBundleManagerDT.getBundle((PropertyStorage)(ps = context.getNode() instanceof FrameworkXmlSourceNode ? context.getWorkspace() : context.getProject()), valueExpr, false);
            if (resourceBundleWrapper != null) {
                for (String key : resourceBundleWrapper.keySet()) {
                    childrenVariables.add(new AMXVariable((Property)new DefaultProperty(key, JsfArb.getString((int)131), null, null, true, ADFMobileConstants.STRING_TYPE, null), null));
                }
                resourceBundleManagerDT.releaseBundle(resourceBundleWrapper);
            }
            DefaultProperty parent = new DefaultProperty(varValue);
            AMXVariable resourceBundleVar = new AMXVariable((Property)parent, childrenVariables);
            this._createResourceBundleMap(resourceBundleVar);
            return resourceBundleVar;
        }
        return null;
    }

    private boolean _isLoadBundleElement(XmlModel model, org.w3c.dom.Node node) {
        XmlKey key = model.getNodeXmlKey(node);
        return "loadBundle".equals(key.getLocalName());
    }

    private void _createResourceBundleMap(AMXVariable resourceBundleVar) {
        HashMap<String, Set<Displayable>> propMap = new HashMap<String, Set<Displayable>>();
        String key = resourceBundleVar.getProperty().getShortLabel();
        Set<Displayable> childrenSet = resourceBundleVar.getChildrenProperties();
        if (childrenSet.isEmpty()) {
            propMap.put(key, null);
            return;
        }
        propMap.put(key, childrenSet);
        resourceBundleVar.setMap(propMap);
    }

    private Map<AMXProperty, Map> _getFeatureSubMap(String id, org.w3c.dom.Node childNode) {
        HashMap<AMXProperty, Map> propertyMap = new HashMap<AMXProperty, Map>(1);
        int dotIndex = id.indexOf(".");
        if (dotIndex != -1) {
            propertyMap.put(new AMXProperty(id.substring(0, dotIndex)), this._getFeatureSubMap(id.substring(dotIndex + 1), childNode));
        } else {
            propertyMap.put(new AMXProperty(id), this._traversePrefNode(childNode));
        }
        return propertyMap;
    }

    private Map _getPreferenceSubMap(String id, org.w3c.dom.Node childNode) {
        HashMap<AMXProperty, Map<AMXProperty, Map>> propertyMap = new HashMap<AMXProperty, Map<AMXProperty, Map>>(1);
        int dotIndex = id.indexOf(".");
        if (dotIndex != -1) {
            propertyMap.put(new AMXProperty(id.substring(0, dotIndex), _prefElementLongLabelMap.get(childNode.getLocalName()), _prefElementIconMap.get(childNode.getLocalName())), this._getPreferenceSubMap(id.substring(dotIndex + 1), childNode));
        } else {
            propertyMap.put(new AMXProperty(id, _prefElementLongLabelMap.get(childNode.getLocalName()), _prefElementIconMap.get(childNode.getLocalName())), this._traversePrefNode(childNode));
        }
        return propertyMap;
    }

    private void _setVariableProperties(Set<Displayable> variablePropertiesSet, List<AMXVariable> amxVariables, List<String> tokens) {
        if (amxVariables != null) {
            for (AMXVariable amxVariable : amxVariables) {
                Set<Displayable> properties = amxVariable.getProperties(AMXVariableProvider._getKey(tokens));
                if (properties == null) continue;
                variablePropertiesSet.addAll(properties);
            }
        }
    }

    private void _setVariables(Set<Property> variableSet, List<AMXVariable> amxVariables) {
        if (amxVariables != null) {
            for (AMXVariable amxVariable : amxVariables) {
                variableSet.add((Property)new DefaultProperty(amxVariable.getProperty().getShortLabel()));
            }
        }
    }

    static {
        HashMap<String, String> longLabelMap = new HashMap<String, String>();
        longLabelMap.put("preferenceBoolean", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceBoolean"));
        longLabelMap.put("preferenceGroup", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceGroup"));
        longLabelMap.put("preferenceList", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceList"));
        longLabelMap.put("preferenceNumber", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceNumber"));
        longLabelMap.put("preferencePage", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferencePage"));
        longLabelMap.put("preferenceText", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceText"));
        longLabelMap.put("preferenceValue", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceValue"));
        _prefElementLongLabelMap = Collections.unmodifiableMap(longLabelMap);
        _prefGroupIcon = AMXVariableProvider._createImageIcon("/oracle/adfmf/framework/dt/editor/images/admingroups.png", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferenceGroup"));
        _prefPageIcon = AMXVariableProvider._createImageIcon("/oracle/adfmf/framework/dt/editor/images/preference-page.png", EditorMetadataMethods.get("ELEM_DISPLAY_NAME_preferencePage"));
        _prefElementIcon = OracleIcons.getIcon((String)"configure.png");
        HashMap<String, Icon> iconMap = new HashMap<String, Icon>();
        iconMap.put("preferenceBoolean", _prefElementIcon);
        iconMap.put("preferenceGroup", _prefGroupIcon);
        iconMap.put("preferenceList", _prefElementIcon);
        iconMap.put("preferenceNumber", _prefElementIcon);
        iconMap.put("preferencePage", _prefPageIcon);
        iconMap.put("preferenceText", _prefElementIcon);
        iconMap.put("preferenceValue", _prefElementIcon);
        _prefElementIconMap = Collections.unmodifiableMap(iconMap);
        _APPLICATION_SCOPE_LONG_LABEL = MobileResourceUtils.getText("APPLICATION_SCOPE_LONG_LABEL");
        _DEVICE_SCOPE_LONG_LABEL = MobileResourceUtils.getText("DEVICE_SCOPE_LONG_LABEL");
        _PAGE_FLOW_SCOPE_LONG_LABEL = MobileResourceUtils.getText("PAGE_FLOW_SCOPE_LONG_LABEL");
        _PREFERENCE_SCOPE_LONG_LABEL = MobileResourceUtils.getText("PREFERENCE_SCOPE_LONG_LABEL");
        _VIEW_SCOPE_LONG_LABEL = MobileResourceUtils.getText("VIEW_SCOPE_LONG_LABEL");
        ArrayList<DefaultProperty> properties = new ArrayList<DefaultProperty>();
        properties.add(new DefaultProperty(_APPLICATION_SCOPE, _APPLICATION_SCOPE_LONG_LABEL, _APPLICATION_SCOPE_LONG_LABEL, null, true, null, null));
        properties.add(new DefaultProperty(_DEVICE_SCOPE, _DEVICE_SCOPE_LONG_LABEL, _DEVICE_SCOPE_LONG_LABEL, null, true, null, null));
        properties.add(new DefaultProperty(_PAGE_FLOW_SCOPE, _PAGE_FLOW_SCOPE_LONG_LABEL, _PAGE_FLOW_SCOPE_LONG_LABEL, null, true, null, null));
        properties.add(new DefaultProperty(_PREFERENCE_SCOPE, _PREFERENCE_SCOPE_LONG_LABEL, _PREFERENCE_SCOPE_LONG_LABEL, null, true, null, null));
        properties.add(new DefaultProperty(_VIEW_SCOPE, _VIEW_SCOPE_LONG_LABEL, _VIEW_SCOPE_LONG_LABEL, null, true, null, null));
        _amxObjects = Collections.unmodifiableList(properties);
        _SHORT_LABEL = MobileResourceUtils.getText("ADF_MOBILE_AMX_VARIABLE_PROVIDER_SHORT_LABEL");
        _LONG_LABEL = MobileResourceUtils.getText("ADF_MOBILE_AMX_VARIABLE_PROVIDER_LONG_LABEL");
    }

    private static final class AMXProperty {
        private String _shortLabel = null;
        private Property _property = null;

        AMXProperty(String shortLabel) {
            this(shortLabel, null);
        }

        AMXProperty(String shortLabel, Icon icon) {
            this(shortLabel, shortLabel, icon);
        }

        AMXProperty(String shortLabel, String longLabel, Icon icon) {
            this._shortLabel = shortLabel;
            if (longLabel == null) {
                longLabel = shortLabel;
            }
            this._property = new DefaultProperty(shortLabel, longLabel, longLabel, icon, true, null, null);
        }

        public Property getProperty() {
            return this._property;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this._shortLabel != null && ((AMXProperty)obj)._shortLabel != null && ((AMXProperty)obj)._shortLabel.equals(this._shortLabel);
        }

        public int hashCode() {
            if (this._shortLabel != null) {
                return this._shortLabel.hashCode();
            }
            return super.hashCode();
        }

        public String toString() {
            return this._shortLabel;
        }
    }

    private static class DeviceScopeVariable {
        private static final String _DEVICE_TOKEN = "device";
        private static final String _DEVICE_PROPERTIES_CLASS = "oracle.adfmf.framework.contract.adf.DeviceProperties";
        private static final String _HARDWARE_TOKEN = "hardware";
        private static final String _DEVICE_HARDWARE_CLASS = "oracle.adfmf.framework.contract.adf.DeviceHardware";
        private static final String _SCREEN_TOKEN = "screen";
        private static final String _DEVICE_SCREEN_CLASS = "oracle.adfmf.framework.contract.adf.DeviceScreen";
        private static final Set<Displayable> _DEVICE_SCOPE_PROPERTIES = new HashSet<Displayable>();
        private static Map<String, Set<Displayable>> _DEVICE_SCOPE_PROPERTIES_MAP;

        private DeviceScopeVariable() {
        }

        public static synchronized Set getDeviceScopeProperties(String key) {
            return _DEVICE_SCOPE_PROPERTIES_MAP.get(key);
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        private static Set<Displayable> _getProperties(String className) {
            HashSet<Object> properties = new HashSet<Object>();
            Set<Method> methodSet = AMXUtils.getPropertyMethods(AMXUtils.getJavaFrameworkClassLoader(), className, true);
            for (Method method : methodSet) {
                if (AMXUtils.isPropertyAccessor(method)) {
                    properties.add(new DefaultProperty(AMXUtils.getPropertyName(method.getName())));
                    continue;
                }
                properties.add((Object)new AMXDefaultMethod(method.getName(), AMXUtils.getJavaTypesAsStrings(method.getParameterTypes()), method.getReturnType().getName()));
            }
            return Collections.unmodifiableSet(properties);
        }

        static {
            _DEVICE_SCOPE_PROPERTIES.add((Displayable)new DefaultProperty(_DEVICE_TOKEN));
            _DEVICE_SCOPE_PROPERTIES.add((Displayable)new DefaultProperty(_HARDWARE_TOKEN));
            _DEVICE_SCOPE_PROPERTIES_MAP = new HashMap<String, Set<Displayable>>();
            _DEVICE_SCOPE_PROPERTIES_MAP.put(AMXVariableProvider._DEVICE_SCOPE, _DEVICE_SCOPE_PROPERTIES);
            _DEVICE_SCOPE_PROPERTIES_MAP.put(AMXVariableProvider._getKey(Arrays.asList(AMXVariableProvider._DEVICE_SCOPE, _DEVICE_TOKEN)), DeviceScopeVariable._getProperties(_DEVICE_PROPERTIES_CLASS));
            _DEVICE_SCOPE_PROPERTIES_MAP.put(AMXVariableProvider._getKey(Arrays.asList(AMXVariableProvider._DEVICE_SCOPE, _HARDWARE_TOKEN)), DeviceScopeVariable._getProperties(_DEVICE_HARDWARE_CLASS));
            _DEVICE_SCOPE_PROPERTIES_MAP.put(AMXVariableProvider._getKey(Arrays.asList(AMXVariableProvider._DEVICE_SCOPE, _HARDWARE_TOKEN, _SCREEN_TOKEN)), DeviceScopeVariable._getProperties(_DEVICE_SCREEN_CLASS));
        }
    }

    private static class AMXDefaultMethod
    extends DefaultMethod {
        public AMXDefaultMethod(String methodName, String[] parameters, String returnType) {
            super(methodName, parameters, returnType);
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"method.png");
        }

        public String getLongLabel() {
            String[] parameters;
            StringBuilder methodParams = new StringBuilder();
            for (String parameter : parameters = this.getParameters()) {
                if (methodParams.length() != 0) {
                    methodParams.append(", ");
                }
                methodParams.append(parameter);
            }
            return MobileResourceUtils.getText("DEFAULT_METHOD_LONG_LABEL", this.getReturnType(), this.getShortLabel(), methodParams.toString());
        }
    }

    private static final class AMXVariable {
        private Property _property;
        private Set<AMXVariable> _childrenVars;
        private Map<String, Set<Displayable>> _propMap;

        AMXVariable(Property property, Set<AMXVariable> childrenVars) {
            this._property = property;
            this._childrenVars = childrenVars;
        }

        public Property getProperty() {
            return this._property;
        }

        public Set<AMXVariable> getChildren() {
            if (this._childrenVars == null) {
                return Collections.emptySet();
            }
            return this._childrenVars;
        }

        public Set<Displayable> getChildrenProperties() {
            if (this._childrenVars == null) {
                return Collections.emptySet();
            }
            HashSet<Displayable> childrenProperties = new HashSet<Displayable>();
            for (AMXVariable var : this._childrenVars) {
                childrenProperties.add((Displayable)var.getProperty());
            }
            return childrenProperties;
        }

        public void setMap(Map<String, Set<Displayable>> propMap) {
            this._propMap = propMap;
        }

        public Set<Displayable> getProperties(String key) {
            if (this._propMap == null) {
                return Collections.emptySet();
            }
            return this._propMap.get(key);
        }
    }

    private static enum AMXCollectionXmlKey {
        ITERATOR("http://xmlns.oracle.com/adf/mf/amx", "iterator"),
        LIST_VIEW("http://xmlns.oracle.com/adf/mf/amx", "listView"),
        CAROUSEL("http://xmlns.oracle.com/adf/mf/amx", "carousel"),
        ELEM_AREA_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "areaChart"),
        ELEM_BAR_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "barChart"),
        ELEM_BUBBLE_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "bubbleChart"),
        ELEM_COMBO_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "comboChart"),
        ELEM_HORIZONTAL_BAR_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "horizontalBarChart"),
        ELEM_LINE_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "lineChart"),
        ELEM_PIE_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "pieChart"),
        ELEM_SCATTER_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "scatterChart"),
        ELEM_SPARK_CHART("http://xmlns.oracle.com/adf/mf/amx/dvt", "sparkChart"),
        ELEM_AREA_DATA_LAYER("http://xmlns.oracle.com/adf/mf/amx/dvt", "areaDataLayer"),
        ELEM_POINT_DATA_LAYER("http://xmlns.oracle.com/adf/mf/amx/dvt", "pointDataLayer");

        private final transient XmlKey _XML_KEY;

        private AMXCollectionXmlKey(String namespace, String key) {
            this._XML_KEY = ImmutableXmlKey.createElementKey((String)namespace, (String)key);
        }

        private XmlKey getXmlKey() {
            return this._XML_KEY;
        }
    }
}

