/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfdt.view.unified.binding.util.ExpressionUtils;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.adfmf.common.util.MobileResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ListViewBindingUtils {
    public static final String TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_TEXT");
    public static final String MAIN_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_MAIN_TEXT");
    public static final String IMAGE = MobileResourceUtils.getText("LISTVIEW_EDITOR_IMAGE");
    public static final String SUBORDINATE_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_SUBORDINATE_TEXT");
    public static final String START_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_START_TEXT");
    public static final String END_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_END_TEXT");
    public static final String UPPER_START_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_UPPER_START_TEXT");
    public static final String UPPER_END_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_UPPER_END_TEXT");
    public static final String LOWER_START_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_LOWER_START_TEXT");
    public static final String LOWER_END_TEXT = MobileResourceUtils.getText("LISTVIEW_EDITOR_LOWER_END_TEXT");
    public static final String IMAGE_COMP_VALUE = "<add path to your image>";
    public static final String TEXT_COMP_VALUE = "ListItem Text";
    public static final String MAIN_TEXT_COMP_VALUE = "Main Text";
    public static final String SUBORDINATE_TEXT_COMP_VALUE = "This is the subordinate text";
    public static final String START_TEXT_COMP_VALUE = "Start Text";
    public static final String END_TEXT_COMP_VALUE = "End Text";
    public static final String UPPER_START_TEXT_COMP_VALUE = "Upper Start Text";
    public static final String UPPER_END_TEXT_COMP_VALUE = "Upper End Text";
    public static final String LOWER_START_TEXT_COMP_VALUE = "Lower Start Text";
    public static final String LOWER_END_TEXT_COMP_VALUE = "Lower End Text";
    private static final List<String> _SIMPLE_COMPONENTS = Arrays.asList(TEXT);
    private static final List<String> _SIMPLE_COMPONENTS_WITH_IMAGE = Arrays.asList(TEXT, IMAGE);
    private static final List<String> _MAINSUB_COMPONENTS = Arrays.asList(MAIN_TEXT, SUBORDINATE_TEXT);
    private static final List<String> _MAINSUB_COMPONENTS_WITH_IMAGE = Arrays.asList(MAIN_TEXT, SUBORDINATE_TEXT, IMAGE);
    private static final List<String> _STARTEND_COMPONENTS = Arrays.asList(START_TEXT, END_TEXT);
    private static final List<String> _STARTEND_COMPONENTS_WITH_IMAGE = Arrays.asList(START_TEXT, END_TEXT, IMAGE);
    private static final List<String> _QUADRANT_COMPONENTS = Arrays.asList(UPPER_START_TEXT, UPPER_END_TEXT, LOWER_START_TEXT, LOWER_END_TEXT);
    private static final List<String> _QUADRANT_COMPONENTS_WITH_IMAGE = Arrays.asList(UPPER_START_TEXT, UPPER_END_TEXT, LOWER_START_TEXT, LOWER_END_TEXT, IMAGE);
    private static final String _INDEX_SIMPLE = "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple.png";
    private static final String _INDEX_SIMPLE_IMAGES = "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple-images.png";
    private static final String _INDEX_MAINSUB = "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub.png";
    private static final String _INDEX_MAINSUB_IMAGES = "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub-images.png";
    private static final String _INDEX_STARTEND = "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend.png";
    private static final String _INDEX_STARTEND_IMAGES = "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend-images.png";
    private static final String _INDEX_QUADRANT = "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant.png";
    private static final String _INDEX_QUADRANT_IMAGES = "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant-images.png";
    public static final String LIST_VIEW_INSET_LIST_CSS = "adfmf-listView-insetList";
    private static final String _LIST_ITEM_HIGHLIGHT_TEXT_CSS = "adfmf-listItem-highlightText";
    private static final String _LIST_ITEM_CAPTION_TEXT_CSS = "adfmf-listItem-captionText";
    private static final String _INSET = "inset";
    private static final String _NO_CHEVRONS = "nochevrons";
    private static final List<String> _IMAGE_INCLUSION_CONTEXT = new ArrayList<String>(1);
    private static final List<String> _DEFAULT_INCLUSION_CONTEXT = new ArrayList<String>(2);
    public static final int LIST_VIEW_DIALOG_WIDTH = 600;
    public static final int LIST_VIEW_DIALOG_HEIGHT = 350;

    public static AMXPrimitiveCollection createDefinitionCollection(CreationContext creationContext, ADFBaseProvider modelProvider, String modelProviderName, Collection<Object> definitions, List<String> inclusionContext, List<AMXPrimitiveDefinition> itemsArrayList) {
        AMXPrimitiveCollection defCollection = new AMXPrimitiveCollection(creationContext, modelProvider, modelProviderName, definitions, inclusionContext);
        defCollection.setItems(itemsArrayList);
        return defCollection;
    }

    public static Node createListItemChild(AMXPrimitiveDefinition item, Document document, boolean isStaticValue, boolean isImage) {
        Node listItemChild = isImage ? ListViewBindingUtils._createImage(item, document, isStaticValue) : ListViewBindingUtils._createOutputText(item, document, isStaticValue);
        return listItemChild;
    }

    public static String getListViewFormatIconPath(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.getListViewFormatIconPath();
        }
        return null;
    }

    public static boolean isDividerAttributeSupported(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.isDividerSupported();
        }
        return false;
    }

    public static boolean isImageSupported(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.isImageSupported();
        }
        return false;
    }

    public static boolean isTableLayoutRequired(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.isTableLayoutRequired();
        }
        return false;
    }

    public static List<String> getSupportedComponents(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.getSupportedComponents();
        }
        return Collections.emptyList();
    }

    public static String getCreatorPattern(String listViewFormat) {
        ListViewFormatVariations listViewFormatVariation = ListViewBindingUtils._getListViewFormatVariation(listViewFormat);
        if (listViewFormatVariation != null) {
            return listViewFormatVariation.getCreatorPattern();
        }
        return null;
    }

    public static boolean isInsetSupported(String listViewStyle) {
        return listViewStyle != null && listViewStyle.contains(_INSET);
    }

    public static boolean isChevronSupported(String listViewStyle) {
        return listViewStyle != null && !listViewStyle.contains(_NO_CHEVRONS);
    }

    public static String getComponentStyleClass(String componentName) {
        ListViewComponents listViewComponent = ListViewBindingUtils._getListViewComponent(componentName);
        if (listViewComponent != null) {
            return listViewComponent.getStyleClass();
        }
        return null;
    }

    public static String getComponentValue(String componentName) {
        ListViewComponents listViewComponent = ListViewBindingUtils._getListViewComponent(componentName);
        if (listViewComponent != null) {
            return listViewComponent.getValue();
        }
        return null;
    }

    public static List<String> getInclusionContext(String componentName) {
        if (IMAGE.equals(componentName)) {
            return _IMAGE_INCLUSION_CONTEXT;
        }
        return ListViewBindingUtils.getDefaultInclusionContext();
    }

    public static List<String> getDefaultInclusionContext() {
        return _DEFAULT_INCLUSION_CONTEXT;
    }

    private static ListViewFormatVariations _getListViewFormatVariation(String listViewFormat) {
        for (ListViewFormatVariations listViewFormatVariation : ListViewFormatVariations.values()) {
            if (!listViewFormatVariation.getListViewFormat().equals(listViewFormat)) continue;
            return listViewFormatVariation;
        }
        return null;
    }

    private static ListViewComponents _getListViewComponent(String componentName) {
        for (ListViewComponents component : ListViewComponents.values()) {
            if (!component.getName().equals(componentName)) continue;
            return component;
        }
        return null;
    }

    private static Node _createOutputText(AMXPrimitiveDefinition item, Document document, boolean isStaticValue) {
        String cssStyle;
        String component = item.getComponent();
        Element outputTextNode = document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "outputText");
        String value = ListViewBindingUtils._getValue(item, isStaticValue);
        if (!value.isEmpty()) {
            outputTextNode.setAttributeNS(null, "value", value);
        }
        if ((cssStyle = ListViewBindingUtils.getComponentStyleClass(component)) != null) {
            outputTextNode.setAttributeNS(null, "styleClass", cssStyle);
        }
        return outputTextNode;
    }

    private static Node _createImage(AMXPrimitiveDefinition item, Document document, boolean isStaticValue) {
        Element imageNode = document.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "image");
        String value = ListViewBindingUtils._getValue(item, isStaticValue);
        if (!value.isEmpty()) {
            imageNode.setAttributeNS(null, "source", value);
        }
        return imageNode;
    }

    private static String _getValue(AMXPrimitiveDefinition item, boolean isStaticValue) {
        String value = item.getValueObject().toString();
        if (!value.isEmpty() && !isStaticValue) {
            value = ExpressionUtils.createExpression((String[])new String[]{"row", value});
        }
        return value;
    }

    static /* synthetic */ List access$000() {
        return _SIMPLE_COMPONENTS;
    }

    static /* synthetic */ List access$100() {
        return _SIMPLE_COMPONENTS_WITH_IMAGE;
    }

    static /* synthetic */ List access$200() {
        return _MAINSUB_COMPONENTS;
    }

    static /* synthetic */ List access$300() {
        return _MAINSUB_COMPONENTS_WITH_IMAGE;
    }

    static /* synthetic */ List access$400() {
        return _STARTEND_COMPONENTS;
    }

    static /* synthetic */ List access$500() {
        return _STARTEND_COMPONENTS_WITH_IMAGE;
    }

    static /* synthetic */ List access$600() {
        return _QUADRANT_COMPONENTS;
    }

    static /* synthetic */ List access$700() {
        return _QUADRANT_COMPONENTS_WITH_IMAGE;
    }

    static {
        _IMAGE_INCLUSION_CONTEXT.add("adfmfListViewImage");
        _DEFAULT_INCLUSION_CONTEXT.add("adfmfListViewText");
        _DEFAULT_INCLUSION_CONTEXT.addAll(_IMAGE_INCLUSION_CONTEXT);
    }

    private static enum ListViewComponents {
        IMAGE_COMP(IMAGE, null, "<add path to your image>"),
        TEXT_COMP(TEXT, null, "ListItem Text"),
        MAIN_TEXT_COMP(MAIN_TEXT, null, "Main Text"),
        SUBORDINATE_TEXT_COMP(SUBORDINATE_TEXT, "adfmf-listItem-captionText", "This is the subordinate text"),
        START_TEXT_COMP(START_TEXT, null, "Start Text"),
        END_TEXT_COMP(END_TEXT, "adfmf-listItem-highlightText", "End Text"),
        UPPER_START_TEXT_COMP(UPPER_START_TEXT, null, "Upper Start Text"),
        UPPER_END_TEXT_COMP(UPPER_END_TEXT, "adfmf-listItem-highlightText", "Upper End Text"),
        LOWER_START_TEXT_COMP(LOWER_START_TEXT, "adfmf-listItem-captionText", "Lower Start Text"),
        LOWER_END_TEXT_COMP(LOWER_END_TEXT, "adfmf-listItem-captionText", "Lower End Text");

        private String _component;
        private String _styleClass;
        private String _value;

        private ListViewComponents(String component, String styleClass, String value) {
            this._component = component;
            this._styleClass = styleClass;
            this._value = value;
        }

        public String getName() {
            return this._component;
        }

        public String getStyleClass() {
            return this._styleClass;
        }

        public String getValue() {
            return this._value;
        }
    }

    private static enum ListViewFormatVariations {
        SIMPLE_BASIC("SIMPLE_BASIC", "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple.png", false, false, false, ListViewBindingUtils.access$000(), "adfmf_list_view_simple"),
        SIMPLE_DIVIDERS("SIMPLE_DIVIDERS", "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple.png", true, false, false, ListViewBindingUtils.access$000(), "adfmf_list_view_simple"),
        SIMPLE_IMAGES("SIMPLE_IMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple-images.png", false, true, true, ListViewBindingUtils.access$100(), "adfmf_list_view_simple"),
        SIMPLE_DIVIDERSIMAGES("SIMPLE_DIVIDERSIMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-simple-images.png", true, true, true, ListViewBindingUtils.access$100(), "adfmf_list_view_simple"),
        MAINSUB_BASIC("MAINSUB_BASIC", "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub.png", false, false, true, ListViewBindingUtils.access$200(), "adfmf_list_view_mainsub"),
        MAINSUB_DIVIDERS("MAINSUB_DIVIDERS", "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub.png", true, false, true, ListViewBindingUtils.access$200(), "adfmf_list_view_mainsub"),
        MAINSUB_IMAGES("MAINSUB_IMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub-images.png", false, true, true, ListViewBindingUtils.access$300(), "adfmf_list_view_mainsub"),
        MAINSUB_DIVIDERSIMAGES("MAINSUB_DIVIDERSIMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-mainsub-images.png", true, true, true, ListViewBindingUtils.access$300(), "adfmf_list_view_mainsub"),
        STARTEND_BASIC("STARTEND_BASIC", "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend.png", false, false, true, ListViewBindingUtils.access$400(), "adfmf_list_view_startend"),
        STARTEND_DIVIDERS("STARTEND_DIVIDERS", "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend.png", true, false, true, ListViewBindingUtils.access$400(), "adfmf_list_view_startend"),
        STARTEND_IMAGES("STARTEND_IMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend-images.png", false, true, true, ListViewBindingUtils.access$500(), "adfmf_list_view_startend"),
        STARTEND_DIVIDERSIMAGES("STARTEND_DIVIDERSIMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-startend-images.png", true, true, true, ListViewBindingUtils.access$500(), "adfmf_list_view_startend"),
        QUADRANT_BASIC("QUADRANT_BASIC", "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant.png", false, false, true, ListViewBindingUtils.access$600(), "adfmf_list_view_quadrant"),
        QUADRANT_DIVIDERS("QUADRANT_DIVIDERS", "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant.png", true, false, true, ListViewBindingUtils.access$600(), "adfmf_list_view_quadrant"),
        QUADRANT_IMAGES("QUADRANT_IMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant-images.png", false, true, true, ListViewBindingUtils.access$700(), "adfmf_list_view_quadrant"),
        QUADRANT_DIVIDERSIMAGES("QUADRANT_DIVIDERSIMAGES", "/oracle/adfmf/amx/dt/editor/databinding/images/index-quadrant-images.png", true, true, true, ListViewBindingUtils.access$700(), "adfmf_list_view_quadrant");

        private String _listViewFormat;
        private String _listViewFormatIconPath;
        private boolean _isDividerSupported;
        private boolean _isImageSupported;
        private boolean _isTableLayoutRequired;
        private List<String> _supportedComponents;
        private String _creatorPattern;

        private ListViewFormatVariations(String listViewFormat, String listViewFormatIconPath, boolean isDividerSupported, boolean isImageSupported, boolean isTableLayoutRequired, List<String> supportedComponents, String creatorPattern) {
            this._listViewFormat = listViewFormat;
            this._listViewFormatIconPath = listViewFormatIconPath;
            this._isDividerSupported = isDividerSupported;
            this._isImageSupported = isImageSupported;
            this._isTableLayoutRequired = isTableLayoutRequired;
            this._supportedComponents = supportedComponents;
            this._creatorPattern = creatorPattern;
        }

        public String getListViewFormat() {
            return this._listViewFormat;
        }

        public String getListViewFormatIconPath() {
            return this._listViewFormatIconPath;
        }

        public boolean isDividerSupported() {
            return this._isDividerSupported;
        }

        public boolean isImageSupported() {
            return this._isImageSupported;
        }

        public boolean isTableLayoutRequired() {
            return this._isTableLayoutRequired;
        }

        public List<String> getSupportedComponents() {
            return this._supportedComponents;
        }

        public String getCreatorPattern() {
            return this._creatorPattern;
        }
    }
}

