/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.collection;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.common.ui.collection.Item;
import oracle.adfdt.common.ui.collection.ItemHolder;
import oracle.adfdtinternal.view.rich.binding.resource.ADFFacesBindingResources;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.javatools.icons.OracleIcons;

public final class AmxListViewCollectionDecorator
extends AMXCollectionDecorator {
    private String _valueHeader = ADFFacesBindingResources.getResource((String)"ADF_EDITOR_COL_VALUE");
    private boolean _isValueText = false;

    public AmxListViewCollectionDecorator(ADFDesignTimeContext dtContext, AMXPrimitiveCollection defCollection, String description) {
        super(dtContext, defCollection, description);
    }

    public boolean isReorderingSupported() {
        return false;
    }

    @Override
    public boolean isNewSupported() {
        return false;
    }

    @Override
    public boolean isColumnEditable(int column) {
        return column != 0 && column != 2;
    }

    @Override
    public String getItemHeader(ItemHolder holder) {
        return "#";
    }

    @Override
    public String getComponentHeader(ItemHolder holder) {
        return MobileResourceUtils.getText("LISTVIEW_EDITOR_COMPONENT_COLUMN_HEADER");
    }

    @Override
    public String getValueHeader(ItemHolder holder) {
        return this._valueHeader;
    }

    public void setValueHeader(String valueHeader) {
        this._valueHeader = valueHeader;
    }

    public void treatValueAsText(boolean isText) {
        this._isValueText = isText;
    }

    @Override
    public Object getComponentDisplayValue(Item item) {
        AMXPrimitiveDefinition defItem = (AMXPrimitiveDefinition)item;
        return defItem.getComponent();
    }

    @Override
    public TableCellEditor getTableCellEditor(int column) {
        if (!this.isColumnEditable(column)) {
            return null;
        }
        if (column == 1 && this._isValueText) {
            JTextField text = new JTextField();
            DefaultCellEditor cellEditor = new DefaultCellEditor(text);
            cellEditor.setClickCountToStart(1);
            return cellEditor;
        }
        return super.getTableCellEditor(column);
    }

    @Override
    public TableCellRenderer getTableCellRenderer(int column) {
        if (column == 0) {
            return new ListViewLabelTableCellRenderer();
        }
        return super.getTableCellRenderer(column);
    }

    @Override
    protected String getDisplayValueFromItemValue(Object value, JLabel label) {
        String displayValue = super.getDisplayValueFromItemValue(value, label);
        if (displayValue != null && !this._isValueText) {
            label.setIcon(OracleIcons.getIcon((String)"collectionattribute.png"));
        }
        return displayValue;
    }

    private static final class ListViewLabelTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ListViewLabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer rowNumber = row + 1;
            String displayValue = rowNumber.toString();
            return super.getTableCellRendererComponent(table, displayValue, isSelected, hasFocus, row, column);
        }
    }
}

