/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.adfdt.common.ui.collection.Item;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;

public class AMXPrimitiveCollection
extends oracle.adfdt.common.ui.collection.Collection {
    private CreationContext _creationContext;
    private ADFBaseProvider _itorModelProvider;
    private String _itorModelProviderName;
    private final Object[] _definitionsArray;
    private int _curItemIndex;
    private List<String> _inclusionContext;
    private boolean _bCollectionChanged;
    private final Collection<Object> _itemDefinitions;

    public AMXPrimitiveCollection(CreationContext creationContext, ADFBaseProvider modelProvider, String modelProviderName, Collection<Object> definitions, List<String> inclusionContext) {
        this._itemDefinitions = definitions;
        this._inclusionContext = inclusionContext;
        this._definitionsArray = this._itemDefinitions.toArray(new Object[this._itemDefinitions.size()]);
        this._curItemIndex = 0;
        this._creationContext = creationContext;
        this._itorModelProvider = modelProvider;
        this._itorModelProviderName = modelProviderName;
        this._bCollectionChanged = false;
    }

    public List<String> getInclusionContext() {
        return this._inclusionContext;
    }

    public String getDefinitionDisplayName(Object definition) {
        if (definition == null) {
            return null;
        }
        if (definition instanceof NamedDefinition) {
            NamedDefinition namedDefinition = (NamedDefinition)definition;
            NamedDefinition parent = (NamedDefinition)namedDefinition.getDefinitionParent();
            if (parent != null) {
                String parentName;
                if (parent instanceof StructureDefinition) {
                    parent = (NamedDefinition)parent.getDefinitionParent();
                }
                if (parent != null && !this._itorModelProviderName.equals(parentName = parent.getName())) {
                    return String.format("%s.%s", parentName, namedDefinition.getName());
                }
            }
            return namedDefinition.getName();
        }
        return definition.toString();
    }

    public Item createItem() {
        Item toAdd = this.createDefinitionItem();
        ArrayList<Item> items = new ArrayList<Item>(this.getItems());
        items.add(toAdd);
        this.setItems(items);
        return toAdd;
    }

    public void delete(Item[] items) {
        super.delete(items);
        this.collectionChanged();
    }

    public void collectionChanged() {
        this._bCollectionChanged = true;
    }

    public boolean isCollectionChanged() {
        return this._bCollectionChanged;
    }

    public void commit() throws Exception {
        for (Item item : this.getItems()) {
            item.commit();
        }
    }

    public Item group(Item[] item) {
        return null;
    }

    public void ungroup(Item item) {
    }

    public Collection<Object> getDefinitions() {
        return this._itemDefinitions;
    }

    protected Item createDefinitionItem() {
        Object itemDef = this._definitionsArray[this._curItemIndex++ % this._definitionsArray.length];
        return new AMXPrimitiveDefinition(this._creationContext, this._itorModelProvider, this._inclusionContext, AMXCollectionDecorator.DEFAULT_LABEL_MARKER, itemDef);
    }
}

