/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.collection;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.common.ui.collection.CollectionPanelDecorator;
import oracle.adfdt.common.ui.collection.ComponentTableCellEditor;
import oracle.adfdt.common.ui.collection.Item;
import oracle.adfdt.common.ui.collection.ItemHolder;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.creator.CreatorInfo;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdtinternal.view.rich.binding.resource.ADFFacesBindingResources;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.binding.meta.NamedDefinition;
import oracle.javatools.icons.OracleIcons;

public class AMXCollectionDecorator
extends CollectionPanelDecorator {
    public static final Object DEFAULT_LABEL_MARKER = new Object(){

        public String toString() {
            return "";
        }
    };
    public static final Object EMPTY_LABEL_MARKER = new Object(){

        public String toString() {
            return "";
        }
    };
    private static final Object[] _LABELS = new Object[]{DEFAULT_LABEL_MARKER, EMPTY_LABEL_MARKER};
    private static final String _TABLE_LABEL_KEY = "ADF_EDITOR_TABLE_LABEL";
    private static final String _COLUMN_LABEL_KEY = "ADF_EDITOR_COL_HEADER";
    protected static final String COLUMN_VALUE_LABEL_KEY = "ADF_EDITOR_COL_VALUE";
    private static final String _COLUMN_COMP_LABEL_KEY = "ADF_EDITOR_COL_COMPONENT";
    private static final String _BIND_TO_LABEL_KEY = "ADF_EDITOR_BIND_TO_LABEL";
    private static final String _BIND_TO_EMPTY_LABEL_KEY = "ADF_EDITOR_BIND_TO_EMPTY_LABEL";
    private static final String _HELP_TOPIC = "f1_adfmf_customiterator_html";
    private final AMXPrimitiveCollection _defCollection;
    private XmlMetadataResolver _resolver;
    private final String _description;

    public AMXCollectionDecorator(ADFDesignTimeContext dtContext, AMXPrimitiveCollection defCollection, String description) {
        this._defCollection = defCollection;
        this._description = description;
        if (dtContext != null && dtContext instanceof JDevDesignTimeContext) {
            XmlContext xmlContext = (XmlContext)dtContext.getEnvironmentContext();
            this._resolver = xmlContext.getModel().getXmlMetadataResolver();
        }
    }

    public String getSummaryDescription() {
        return this._description;
    }

    public String getSummaryHelpTopic() {
        return _HELP_TOPIC;
    }

    public Object getItemDisplayValue(Item item) {
        AMXPrimitiveDefinition defItem = (AMXPrimitiveDefinition)item;
        return defItem.getItemLabelValueObject();
    }

    public Object getValueDisplayValue(Item item) {
        AMXPrimitiveDefinition defItem = (AMXPrimitiveDefinition)item;
        return defItem.getValueObject();
    }

    public Object getComponentDisplayValue(Item item) {
        AMXPrimitiveDefinition defItem = (AMXPrimitiveDefinition)item;
        Widget widget = defItem.getWidget();
        if (widget != null) {
            return widget;
        }
        return defItem.getComponent();
    }

    public String getTableLabelForString() {
        return ADFFacesBindingResources.getResource((String)_TABLE_LABEL_KEY);
    }

    public void setItemValue(Item item, int column, Object aValue) {
        AMXPrimitiveDefinition defItem = (AMXPrimitiveDefinition)item;
        switch (column) {
            case 0: {
                defItem.setItemLabelValueObject(aValue);
                break;
            }
            case 1: {
                defItem.setValueObject(aValue);
                break;
            }
            case 2: {
                defItem.setWidget((Widget)aValue);
                break;
            }
            default: {
                String value = aValue == null ? "" : aValue.toString();
                super.setItemValue(item, column, (Object)value);
            }
        }
    }

    public TableCellEditor getTableCellEditor(int column) {
        if (!this.isColumnEditable(column)) {
            return null;
        }
        if (column == 0) {
            JComboBox<Object> box = new JComboBox<Object>(_LABELS);
            box.setEditable(true);
            this._setComboBoxListener(box);
            DefaultCellEditor cellEditor = new DefaultCellEditor(box);
            box.setRenderer(new LabelListCellRenderer());
            cellEditor.setClickCountToStart(1);
            return cellEditor;
        }
        if (column == 1) {
            JComboBox<Object> box = new JComboBox<Object>(this._defCollection.getDefinitions().toArray());
            DefaultCellEditor cellEditor = new DefaultCellEditor(box);
            box.setRenderer(new ValueListCellRenderer());
            this._setComboBoxListener(box);
            cellEditor.setClickCountToStart(1);
            return cellEditor;
        }
        if (column == 2) {
            ComponentTableCellEditor cellEditor = new ComponentTableCellEditor(this){

                public void configureComboBox(JComboBox box, Item item) {
                    AMXPrimitiveDefinition defItem;
                    Widget currentWidget;
                    if (item instanceof AMXPrimitiveDefinition && (currentWidget = (defItem = (AMXPrimitiveDefinition)item).getWidget()) != null) {
                        box.setSelectedItem(currentWidget);
                    }
                }
            };
            JComboBox comboBox = (JComboBox)cellEditor.getComponent();
            comboBox.setRenderer(new ComponentListCellRenderer());
            return cellEditor;
        }
        return null;
    }

    public TableCellRenderer getTableCellRenderer(int column) {
        if (column == 1) {
            return new ValueTableCellRenderer();
        }
        if (column == 0) {
            return new LabelTableCellRenderer();
        }
        if (column == 2) {
            return new ComponentTableCellRenderer();
        }
        return super.getTableCellRenderer(column);
    }

    public List getAvailableComponents(Item item) {
        AMXPrimitiveDefinition itemDef = (AMXPrimitiveDefinition)item;
        NamedDefinition itemValue = (NamedDefinition)itemDef.getValueObject();
        CreationContext creationContext = itemDef.getCreationContext();
        ADFBaseProvider modelProvider = itemDef.getParentModelProvider();
        return creationContext.getAvailableWidgets(modelProvider.getDataControl(), itemValue, this._defCollection.getInclusionContext());
    }

    public String getItemHeader(ItemHolder holder) {
        return ADFFacesBindingResources.getResource((String)_COLUMN_LABEL_KEY);
    }

    public String getValueHeader(ItemHolder holder) {
        return ADFFacesBindingResources.getResource((String)COLUMN_VALUE_LABEL_KEY);
    }

    public String getComponentHeader(ItemHolder holder) {
        return ADFFacesBindingResources.getResource((String)_COLUMN_COMP_LABEL_KEY);
    }

    public boolean isColumnEditable(int column) {
        return true;
    }

    public boolean isNewSupported() {
        return true;
    }

    protected AMXPrimitiveCollection getCollection() {
        return this._defCollection;
    }

    protected String getDisplayValueFromItemValue(Object value, JLabel label) {
        label.setIcon(null);
        if (value == null) {
            return null;
        }
        if (value instanceof NamedDefinition) {
            NamedDefinition definition = (NamedDefinition)value;
            label.setIcon(OracleIcons.getIcon((String)"collectionattribute.png"));
            return this._defCollection.getDefinitionDisplayName(definition);
        }
        return value.toString();
    }

    private void _setItemIconIfNeeded(Object value, JLabel label) {
        label.setIcon(null);
        if (value instanceof ModelProvider) {
            label.setIcon(OracleIcons.getIcon((String)"collectionattribute.png"));
        }
    }

    private String _getDisplayValueFromItemLabel(Object value, JLabel label) {
        label.setIcon(null);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            label.setIcon(OracleIcons.getIcon((String)"attribute.png"));
            return (String)value;
        }
        if (value.equals(DEFAULT_LABEL_MARKER)) {
            label.setIcon(OracleIcons.getIcon((String)"attribute.png"));
            return ADFFacesBindingResources.getResource((String)_BIND_TO_LABEL_KEY);
        }
        if (value.equals(EMPTY_LABEL_MARKER)) {
            return ADFFacesBindingResources.getResource((String)_BIND_TO_EMPTY_LABEL_KEY);
        }
        return value.toString();
    }

    private void _setLabelIconIfNeeded(Object value, JLabel label) {
        label.setIcon(null);
        if (value.equals(DEFAULT_LABEL_MARKER)) {
            label.setIcon(OracleIcons.getIcon((String)"attribute.png"));
        }
    }

    private String _getDisplayValueFromItemComponent(Object value, JLabel label) {
        label.setIcon(null);
        if (value == null) {
            return null;
        }
        if (value instanceof Widget) {
            CreatorInfo creatorInfo = ((Widget)value).getCreator();
            if (this._resolver != null) {
                XmlKey key = ImmutableXmlKey.createElementKey((String)creatorInfo.getRepresentativeNamespace(), (String)creatorInfo.getRepresentativeLocalName());
                label.setIcon(this._resolver.getSmallIcon(key));
            }
            return StringUtils.stripMnemonic((String)creatorInfo.getDescription());
        }
        return StringUtils.stripMnemonic((String)value.toString());
    }

    private void _setComponentIconIfNeeded(Object value, JLabel label) {
        label.setIcon(null);
        if (value instanceof CreatorInfo) {
            CreatorInfo creatorInfo = (CreatorInfo)value;
            if (this._resolver != null) {
                XmlKey key = ImmutableXmlKey.createElementKey((String)creatorInfo.getRepresentativeNamespace(), (String)creatorInfo.getRepresentativeLocalName());
                label.setIcon(this._resolver.getSmallIcon(key));
            }
        }
    }

    private void _setComboBoxListener(final JComboBox comboBox) {
        comboBox.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                comboBox.requestFocusInWindow();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    private final class ComponentTableCellRenderer
    extends DefaultTableCellRenderer {
        private ComponentTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String displayValue = AMXCollectionDecorator.this._getDisplayValueFromItemComponent(value, this);
            return super.getTableCellRendererComponent(table, displayValue, isSelected, hasFocus, row, column);
        }
    }

    private final class ComponentListCellRenderer
    extends DefaultListCellRenderer {
        private ComponentListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayValue = AMXCollectionDecorator.this._getDisplayValueFromItemComponent(value, this);
            Component ret = super.getListCellRendererComponent((JList<?>)list, displayValue, index, isSelected, cellHasFocus);
            AMXCollectionDecorator.this._setComponentIconIfNeeded(value, this);
            return ret;
        }
    }

    private final class LabelTableCellRenderer
    extends DefaultTableCellRenderer {
        private LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String displayValue = AMXCollectionDecorator.this._getDisplayValueFromItemLabel(value, this);
            return super.getTableCellRendererComponent(table, displayValue, isSelected, hasFocus, row, column);
        }
    }

    private final class LabelListCellRenderer
    extends DefaultListCellRenderer {
        private LabelListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayValue = AMXCollectionDecorator.this._getDisplayValueFromItemLabel(value, this);
            Component ret = super.getListCellRendererComponent((JList<?>)list, displayValue, index, isSelected, cellHasFocus);
            AMXCollectionDecorator.this._setLabelIconIfNeeded(value, this);
            return ret;
        }
    }

    private final class ValueTableCellRenderer
    extends DefaultTableCellRenderer {
        private ValueTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String displayValue = AMXCollectionDecorator.this.getDisplayValueFromItemValue(value, this);
            return super.getTableCellRendererComponent(table, displayValue, isSelected, hasFocus, row, column);
        }
    }

    private final class ValueListCellRenderer
    extends DefaultListCellRenderer {
        private ValueListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayValue = AMXCollectionDecorator.this.getDisplayValueFromItemValue(value, this);
            Component ret = super.getListCellRendererComponent((JList<?>)list, displayValue, index, isSelected, cellHasFocus);
            AMXCollectionDecorator.this._setItemIconIfNeeded(value, this);
            return ret;
        }
    }
}

