/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.binder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.unified.binding.provider.api.ColumnModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFTableModelProvider;
import oracle.adfmf.amx.dt.editor.databinding.binder.AMXCollectionDrivenBinder;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.adfmf.amx.dt.editor.databinding.collection.AmxListViewCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.util.ListViewBindingUtils;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemContentPanel;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreator;
import oracle.adfmf.amx.dt.metadata.creators.listview.ListItemCreatorFactory;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import org.w3c.dom.Node;

public final class AMXListViewBinder
extends AMXCollectionDrivenBinder {
    private ListItemContentPanel _listItemContentPanel;
    private String _listViewFormatVariation;
    private String _listViewStyle;
    private static final String _EDITOR_DESC_LISTVIEW_KEY = "LISTVIEW_EDITOR_DESCRIPTION";
    private static final String _HELP_ID = "f1_adfmf_listview_html";

    @Override
    public void commit() {
        this._listItemContentPanel.commit();
        List items = this.getDefinitionCollection().getItems();
        ListItemCreator listItemCreator = ListItemCreatorFactory.createListItemCreator(this._listViewFormatVariation, this.getRoot().getOwnerDocument());
        if (listItemCreator != null) {
            this.getRoot().appendChild(listItemCreator.createListItem(this.createChildren(items), this._listViewFormatVariation, this._listViewStyle));
        }
    }

    @Override
    public String getTitle() {
        return MobileResourceUtils.getText("EDIT_LIST_VIEW_WIZARD_TITLE");
    }

    @Override
    protected List<Node> createChildren(List<Object> collectionItems) {
        ADFTableModelProvider modelProvider = (ADFTableModelProvider)this.getModelProvider();
        this.getRoot().setAttributeNS(null, "fetchSize", modelProvider.getRowSizeExpression());
        return super.createChildren(collectionItems);
    }

    @Override
    protected void updateCollectionBinding() {
        super.updateCollectionBinding();
        ADFTableModelProvider modelProvider = (ADFTableModelProvider)this.getModelProvider();
        String dividerAttributeValue = this._listItemContentPanel.getDividerAttributeValue();
        if (!dividerAttributeValue.equals(MobileResourceUtils.getText("LISTVIEW_EDITOR_NO_DIVIDER_VALUE"))) {
            Collection columnBindings = modelProvider.getUninitializedColumnModelBindings();
            for (ColumnModelProvider colProvider : columnBindings) {
                String attributeId = colProvider.getAttributeId();
                String rootAccessorId = colProvider.getRootAccessorId();
                if (rootAccessorId != null && !rootAccessorId.isEmpty()) {
                    attributeId = String.format("%s.%s", rootAccessorId, attributeId);
                }
                if (!dividerAttributeValue.equals(attributeId)) continue;
                modelProvider.initializeColumnModel(colProvider);
                break;
            }
        }
    }

    @Override
    protected Node createChild(AMXPrimitiveDefinition collectionItem, Map<String, Object> properties) {
        String cssStyle;
        String component = collectionItem.getComponent();
        if (component != null && (cssStyle = ListViewBindingUtils.getComponentStyleClass(component)) != null) {
            Map updatedProperties = ADFBindingUtils.createPropertyExtensionMap(properties, (Object[])new Object[]{"styleClass", cssStyle});
            return super.createChild(collectionItem, updatedProperties);
        }
        return super.createChild(collectionItem, properties);
    }

    @Override
    protected AMXCollectionDecorator createDecorator() {
        return new AmxListViewCollectionDecorator(this.getDesignTimeContext(), this.getDefinitionCollection(), this.getSummaryDescription());
    }

    @Override
    protected JEWTDialog createDialog() {
        JEWTDialog dialog = super.createDialog();
        dialog.setPreferredSize(600, 350);
        return dialog;
    }

    @Override
    protected JPanel createWizard(AMXCollectionDecorator decorator) {
        this._listItemContentPanel = new ListItemContentPanel(this.getRoot(), decorator, this.getDefinitionCollection(), this._getListViewFormatVariation(), this._getListViewStyle(), true);
        HelpUtils.setHelpID((JComponent)this._listItemContentPanel, (String)this.getHelpId());
        return this._listItemContentPanel;
    }

    @Override
    protected String getHelpId() {
        return _HELP_ID;
    }

    @Override
    protected List<String> getInclusionContext() {
        return ListViewBindingUtils.getDefaultInclusionContext();
    }

    @Override
    protected List<AMXPrimitiveDefinition> getCollectionItems(Collection<? extends ColumnModelProvider> columnModelProviders, List<Object> attrDefinitions) {
        Object attrDefinition;
        ArrayList<AMXPrimitiveDefinition> itemsArrayList = new ArrayList<AMXPrimitiveDefinition>();
        for (ColumnModelProvider columnModelProvider : columnModelProviders) {
            attrDefinition = columnModelProvider.getAttributeDefinition();
            attrDefinitions.add(attrDefinition);
        }
        if (this._getListViewFormatVariation() != null) {
            List<String> components = ListViewBindingUtils.getSupportedComponents(this._getListViewFormatVariation());
            Iterator<? extends ColumnModelProvider> iterator = columnModelProviders.iterator();
            if (attrDefinitions.size() > 0 && iterator.hasNext() && components != null) {
                attrDefinition = attrDefinitions.get(0);
                for (String component : components) {
                    AMXPrimitiveDefinition defItem = new AMXPrimitiveDefinition(this.getCreationContext(), (ADFBaseProvider)((ADFTableModelProvider)this.getModelProvider()), ListViewBindingUtils.getInclusionContext(component), AMXCollectionDecorator.DEFAULT_LABEL_MARKER, attrDefinition);
                    defItem.setComponent(component);
                    itemsArrayList.add(defItem);
                }
            }
        }
        return itemsArrayList;
    }

    @Override
    protected void initializeCollection(List<Object> definitions, List<AMXPrimitiveDefinition> itemsArrayList) {
        super.initializeCollection(definitions, itemsArrayList);
        this.getDefinitionCollection().collectionChanged();
    }

    @Override
    protected String getSummaryDescription() {
        return MobileResourceUtils.getText(_EDITOR_DESC_LISTVIEW_KEY);
    }

    private String _getListViewFormatVariation() {
        if (this._listViewFormatVariation == null) {
            this._listViewFormatVariation = (String)this.getProperties().get("listFormat");
        }
        return this._listViewFormatVariation;
    }

    private String _getListViewStyle() {
        if (this._listViewStyle == null) {
            this._listViewStyle = (String)this.getProperties().get("style");
        }
        return this._listViewStyle;
    }
}

