/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding.binder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.adfdt.common.ui.collection.Collection;
import oracle.adfdt.common.ui.collection.CollectionPanelDecorator;
import oracle.adfdt.common.ui.collection.CollectionSummaryPanel;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdtinternal.view.rich.binding.provider.ADFIteratorModelProvider;
import oracle.adfdtinternal.view.rich.binding.resource.ADFFacesBindingResources;
import oracle.adfmf.amx.dt.editor.databinding.binder.AMXBaseBinder;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXCollectionDecorator;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveCollection;
import oracle.adfmf.amx.dt.editor.databinding.collection.AMXPrimitiveDefinition;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import org.w3c.dom.DocumentFragment;

public class AMXBaseFormBinder
extends AMXBaseBinder {
    private static final String _EDITABLE_FORM_CONTEXT = "adfmfEditableForm";
    private static final String _READ_ONLY_FORM_CONTEXT = "adfmfReadOnlyForm";
    private static final String _EDITOR_DESC_FORM_KEY = "ADF_EDITOR_DESCRIPTION_FORM";
    private static final String _FORM_BINDER_WIZARD_TITLE_KEY = "ADF_EDITOR_FORM_INSTR";
    private static final String _HELP_ID = "f1_adfmf_form_html";

    public void commit() {
        List items = this.getDefinitionCollection().getItems();
        for (Object itemObj : items) {
            AMXPrimitiveDefinition item = (AMXPrimitiveDefinition)((Object)itemObj);
            Map<String, Object> itemProperties = item.addSuggestedLabel(this.getProperties());
            DocumentFragment fragment = this.create(item.getWidget(), this.getModelProvider(), itemProperties);
            this.getRoot().appendChild(fragment);
        }
    }

    @Override
    public String getTitle() {
        return MobileResourceUtils.getText("FORM_WIZARD_TITLE");
    }

    @Override
    protected JPanel createBinderPanel() {
        ADFIteratorModelProvider modelProvider = (ADFIteratorModelProvider)this.getModelProvider();
        ArrayList<Object> definitions = new ArrayList<Object>();
        definitions.addAll(modelProvider.getFormDefinitions());
        definitions.addAll(modelProvider.getFormStructuredAttributeDefinitions());
        ArrayList<AMXPrimitiveDefinition> itemsArrayList = new ArrayList<AMXPrimitiveDefinition>();
        List<String> inclusionContexts = this._getInclusionContext(this.getProperties());
        for (Object e : definitions) {
            itemsArrayList.add(new AMXPrimitiveDefinition(this.getCreationContext(), (ADFBaseProvider)modelProvider, inclusionContexts, AMXCollectionDecorator.DEFAULT_LABEL_MARKER, e));
        }
        this.setDefinitionCollection(new AMXPrimitiveCollection(this.getCreationContext(), (ADFBaseProvider)modelProvider, modelProvider.getDisplayName(), definitions, inclusionContexts));
        this.getDefinitionCollection().setItems(itemsArrayList);
        AMXCollectionDecorator decorator = new AMXCollectionDecorator(this.getDesignTimeContext(), this.getDefinitionCollection(), ADFFacesBindingResources.getResource((String)_EDITOR_DESC_FORM_KEY));
        return this._createWizard(decorator);
    }

    private JPanel _createWizard(AMXCollectionDecorator decorator) {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)new CollectionSummaryPanel((Collection)this.getDefinitionCollection(), (CollectionPanelDecorator)decorator));
        MultiLineLabel headerText = new MultiLineLabel();
        headerText.setTextWrapper(WordWrapper.getTextWrapper());
        headerText.setText(ADFFacesBindingResources.getResource((String)_FORM_BINDER_WIZARD_TITLE_KEY) + "\n\n");
        contentPane.add((Component)headerText, "North");
        HelpUtils.setHelpID((JComponent)contentPane, (String)_HELP_ID);
        return contentPane;
    }

    private List<String> _getInclusionContext(Map<String, Object> properties) {
        ArrayList<String> inclusionContexts = new ArrayList<String>();
        if (!ADFBindingUtils.hasProperty(properties, (String)"readOnly")) {
            inclusionContexts.add(_EDITABLE_FORM_CONTEXT);
        }
        inclusionContexts.add(_READ_ONLY_FORM_CONTEXT);
        return inclusionContexts;
    }
}

