/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.view.common.binding.provider.ADFModelProviderFactory;
import oracle.adfdt.view.common.binding.provider.BindingsType;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.rich.binding.util.JSFExpressionUtils;
import oracle.adfdt.view.rich.binding.util.ModelProviderUtils;
import oracle.adfdt.view.unified.binding.provider.ADFGenericConverterModelProvider;
import oracle.adfdt.view.unified.binding.provider.ADFMultiSelectionModelProvider;
import oracle.adfdt.view.unified.binding.provider.ADFPrimitiveModelProvider;
import oracle.adfdt.view.unified.binding.provider.api.ColumnModelProvider;
import oracle.adfdt.view.unified.binding.provider.api.HierarchyChildOverride;
import oracle.adfdt.view.unified.binding.provider.api.TableModelProvider;
import oracle.adfdt.view.unified.binding.util.ProviderOverrides;
import oracle.adfdtinternal.view.rich.binding.provider.ADFBoolSelectionModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFMethodIteratorModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFMethodModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFOperationModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFSelectionModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFTableModelProvider;
import oracle.adfdtinternal.view.rich.binding.provider.ADFUserDrivenFormModelProvider;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AccessorParameterDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.VariableDefinition;
import org.w3c.dom.Element;

public class AMXModelProviderFactory
implements ADFModelProviderFactory {
    public static final BindingsType ADF_MOBILE_TEXT = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_TEXT"), (String)"adfmfText");
    public static final BindingsType ADF_MOBILE_DATE = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_DATE"), (String)"adfmfDate");
    private static final BindingsType _ADF_MOBILE_OPERATION = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_OPERATION"), (String)"adfmfOperation");
    public static final BindingsType ADF_MOBILE_METHOD = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_METHOD"), (String)"adfmfMethod");
    public static final BindingsType ADF_MOBILE_SINGLE_SELECTION = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_SINGLE_SELECTION"), (String)"adfmfSelectBoolean");
    public static final BindingsType ADF_MOBILE_SELECT_ONE_RADIO = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_SINGLE_SELECTION"), (String)"adfmfSelectOneRadio");
    public static final BindingsType ADF_MOBILE_SELECT_ONE_CHOICE = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_SINGLE_SELECTION"), (String)"adfmfSelectOneChoice");
    public static final BindingsType ADF_MOBILE_SELECT_ONE_BUTTON = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_SINGLE_SELECTION"), (String)"adfmfSelectOneButton");
    public static final BindingsType ADF_MOBILE_FORM = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_FORM"), (String)"adfmfForm");
    public static final BindingsType ADF_MOBILE_LIST_VIEW = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_LIST_VIEW"), (String)"adfmfList");
    private static final BindingsType _ADF_MOBILE_ITERATOR = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_ITERATOR"), (String)"adfmfIterator");
    private static final BindingsType _ADF_MOBILE_BINDINGS_NUMBER_CONVERTER = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_CONVERTER"), (String)"adfmfNumberConverter");
    private static final BindingsType _ADF_MOBILE_BINDINGS_DATE_CONVERTER = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_CONVERTER"), (String)"adfmfDateConverter");
    private static final BindingsType _ADF_MOBILE_PARAMETER = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_OPERATION_PARAMETER"), (String)"adfmfParameter");
    public static final BindingsType ADF_MOBILE_MANY_SELECTION = BindingsType.create((String)MobileResourceUtils.getText("ADF_MOBILE_MANY_SELECTION"), (String)"adfmfSelectMany");
    private static final String _JAVA_UTIL_DATE = "java.util.Date";
    private static final String _JAVA_SQL_TIME = "java.sql.Time";
    private static final String _JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String _JAVA_SQL_DATE = "java.sql.Date";
    private static final String _JAVA_LANG_NUMBER = "java.lang.Number";
    private static final String _JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String _JAVA_LANG_LONG = "java.lang.Long";
    private static final String _JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String _JAVA_LANG_DOUBLE = "java.lang.Double";

    public Collection<BindingsType> getApplicableBindingsTypes(NamedDefinition dataControlDefinition) {
        int definitionType = dataControlDefinition.getDefinitionType();
        ArrayList<BindingsType> bindingsTypeList = new ArrayList<BindingsType>();
        if (definitionType == 40) {
            AccessorDefinition accDefinition = (AccessorDefinition)dataControlDefinition;
            if (ADFBindingUtils.hasAttributeDefinitions((Definition)accDefinition)) {
                bindingsTypeList.add(ADF_MOBILE_FORM);
                bindingsTypeList.add(_ADF_MOBILE_ITERATOR);
                bindingsTypeList.add(ADF_MOBILE_LIST_VIEW);
            }
            if (accDefinition.isCollection()) {
                if (ADFBindingUtils.hasAttributeDefinitions((Definition)accDefinition)) {
                    if (!accDefinition.isScalarCollection()) {
                        bindingsTypeList.add(ADF_MOBILE_MANY_SELECTION);
                    }
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_RADIO);
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_CHOICE);
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_BUTTON);
                }
            } else {
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_RADIO);
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_CHOICE);
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_BUTTON);
            }
        } else if (definitionType == 30) {
            AttributeDefinition attrDefinition = (AttributeDefinition)dataControlDefinition;
            bindingsTypeList.add(ADF_MOBILE_TEXT);
            bindingsTypeList.add(ADF_MOBILE_SINGLE_SELECTION);
            bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_RADIO);
            bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_CHOICE);
            bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_BUTTON);
            String javaType = attrDefinition.getJavaTypeString();
            if (this.isDateType(javaType)) {
                bindingsTypeList.add(ADF_MOBILE_DATE);
                bindingsTypeList.add(_ADF_MOBILE_BINDINGS_DATE_CONVERTER);
            } else if (this.isNumberType(javaType)) {
                bindingsTypeList.add(_ADF_MOBILE_BINDINGS_NUMBER_CONVERTER);
            }
        } else if (definitionType == 60) {
            OperationDefinition opDefinition = (OperationDefinition)dataControlDefinition;
            int methodId = opDefinition.getOperationId();
            if (methodId == 999) {
                bindingsTypeList.add(ADF_MOBILE_METHOD);
            } else {
                bindingsTypeList.add(_ADF_MOBILE_OPERATION);
            }
            if (ADFBindingUtils.hasAttributeDefinitions((Definition)opDefinition)) {
                bindingsTypeList.add(_ADF_MOBILE_PARAMETER);
            }
        } else if (definitionType == 70 || definitionType == 100) {
            ParameterDefinition paramDefinition = (ParameterDefinition)dataControlDefinition;
            if (100 == definitionType && paramDefinition.isAccessor() && ADFBindingUtils.hasAttributeDefinitions((Definition)paramDefinition)) {
                bindingsTypeList.add(ADF_MOBILE_FORM);
                bindingsTypeList.add(_ADF_MOBILE_ITERATOR);
                bindingsTypeList.add(ADF_MOBILE_LIST_VIEW);
            } else if (paramDefinition instanceof AccessorParameterDefinition && ((AccessorParameterDefinition)paramDefinition).isCollection()) {
                if (ADFBindingUtils.hasAttributeDefinitions((Definition)paramDefinition)) {
                    if (!((AccessorParameterDefinition)paramDefinition).isScalarCollection()) {
                        bindingsTypeList.add(ADF_MOBILE_MANY_SELECTION);
                    }
                    bindingsTypeList.add(ADF_MOBILE_FORM);
                    bindingsTypeList.add(_ADF_MOBILE_ITERATOR);
                    bindingsTypeList.add(ADF_MOBILE_LIST_VIEW);
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_RADIO);
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_CHOICE);
                    bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_BUTTON);
                }
            } else if (!paramDefinition.isAccessor()) {
                bindingsTypeList.add(ADF_MOBILE_TEXT);
                bindingsTypeList.add(ADF_MOBILE_SINGLE_SELECTION);
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_RADIO);
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_CHOICE);
                bindingsTypeList.add(ADF_MOBILE_SELECT_ONE_BUTTON);
                String javaType = paramDefinition.getJavaTypeString();
                if (this.isDateType(javaType)) {
                    bindingsTypeList.add(ADF_MOBILE_DATE);
                    bindingsTypeList.add(_ADF_MOBILE_BINDINGS_DATE_CONVERTER);
                } else if (this.isNumberType(javaType)) {
                    bindingsTypeList.add(_ADF_MOBILE_BINDINGS_NUMBER_CONVERTER);
                }
            }
        }
        return Collections.unmodifiableCollection(bindingsTypeList);
    }

    public ModelProvider createModelProvider(ADFDesignTimeContext dtContext, BindingsType bindingsType, DataControl dataControl, NamedDefinition dataControlDefinition) {
        if (ADF_MOBILE_FORM.equals(bindingsType)) {
            return new ADFUserDrivenFormModelProvider(dtContext, dataControl, dataControlDefinition, true);
        }
        if (ADF_MOBILE_LIST_VIEW.equals(bindingsType) || _ADF_MOBILE_ITERATOR.equals(bindingsType)) {
            return new ADFTableModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (_ADF_MOBILE_PARAMETER.equals(bindingsType)) {
            return new ADFMethodIteratorModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_TEXT.equals(bindingsType) || ADF_MOBILE_DATE.equals(bindingsType)) {
            return new ADFPrimitiveModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (_ADF_MOBILE_OPERATION.equals(bindingsType)) {
            return new ADFOperationModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_METHOD.equals(bindingsType)) {
            return new ADFMethodModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (_ADF_MOBILE_BINDINGS_DATE_CONVERTER.equals(bindingsType) || _ADF_MOBILE_BINDINGS_NUMBER_CONVERTER.equals(bindingsType)) {
            return new ADFGenericConverterModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_MANY_SELECTION.equals(bindingsType)) {
            return new ADFMultiSelectionModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_SINGLE_SELECTION.equals(bindingsType)) {
            return new ADFBoolSelectionModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_SELECT_ONE_RADIO.equals(bindingsType)) {
            return new ADFSelectionModelProvider(dtContext, dataControl, dataControlDefinition);
        }
        if (ADF_MOBILE_SELECT_ONE_CHOICE.equals(bindingsType) || ADF_MOBILE_SELECT_ONE_BUTTON.equals(bindingsType)) {
            return new ADFSelectionModelProvider(dtContext, dataControl, dataControlDefinition, null, true);
        }
        return null;
    }

    private boolean isDateType(String javaType) {
        return _JAVA_UTIL_DATE.equals(javaType) || _JAVA_SQL_TIME.equals(javaType) || _JAVA_SQL_TIMESTAMP.equals(javaType) || _JAVA_SQL_DATE.equals(javaType);
    }

    private boolean isNumberType(String javaType) {
        return _JAVA_LANG_NUMBER.equals(javaType) || _JAVA_LANG_INTEGER.equals(javaType) || _JAVA_LANG_LONG.equals(javaType) || _JAVA_LANG_FLOAT.equals(javaType) || _JAVA_LANG_DOUBLE.equals(javaType);
    }

    static {
        ProviderOverrides.registerHierarchyChildOverride((HierarchyChildOverride)new CollectionHierProviderOverride("iterator"));
        ProviderOverrides.registerHierarchyChildOverride((HierarchyChildOverride)new CollectionHierProviderOverride("listView"));
    }

    private static class CollectionHierProviderOverride
    implements HierarchyChildOverride {
        private String _localName;

        public CollectionHierProviderOverride(String localName) {
            this._localName = localName;
        }

        public String getNamespace() {
            return "http://xmlns.oracle.com/adf/mf/amx";
        }

        public String getLocalName() {
            return this._localName;
        }

        public HierarchyChildOverride.HierarchyChildDescriptor createDescriptor(ADFDesignTimeContext dtContext, PageDefinition pageDefinition, ModelProvider hostModelProvider, VariableDefinition definition, Element element) {
            String value = element.getAttributeNS(null, "value");
            String bindingId = JSFExpressionUtils.getBindingIdFromExpression((String)value);
            TableModelProvider tableProvider = ModelProviderUtils.getTableModelProvider((ADFDesignTimeContext)dtContext, (PageDefinition)pageDefinition, (String)bindingId);
            if (tableProvider == null) {
                return null;
            }
            ColumnModelProvider colProvider = tableProvider.getBaseColumnModelBinding(definition);
            if (colProvider == null) {
                return null;
            }
            tableProvider.initializeColumnModel(colProvider);
            String itorVar = element.getAttributeNS(null, "var");
            if (itorVar != null && !"".equals(itorVar)) {
                itorVar = itorVar.trim();
            }
            return new HierarchyChildOverride.HierarchyChildDescriptor(itorVar, colProvider.getTableBindingPrefix(), colProvider.getAttributeId(), colProvider.getRootAccessorId());
        }
    }
}

