/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import oracle.adfmf.amx.dt.editor.AMXConstants;
import oracle.adfmf.amx.dt.editor.AMXPreviewBrowser;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.amx.skins.ADFMobileSkins;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.FormFactorsPrefs;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactors;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdevimpl.webapp.html.HtmlArb;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PreviewEditor
extends Editor {
    private static final String DEFAULT_AMX_FILE = "home.amx";
    private static final String BOOTSTRAP_HTML = "bootstrap.html?amx_dtmode=true&file=home.amx";
    private static final String FEATURE_ROOT_PARAM = "featureRoot=";
    private static final String INCLUDES_FILE = "featureLevelIncludes.jso";
    private static final String DT_FOLDER_PATH_PARAM = "amx_dtfolderpath=";
    private static final String TIMESTAMP_PARAM = "timestamp=";
    private static final String INCLUDES_FOLDER = "includes";
    private static final String AMX_DT_CSS = "amx-dt.css";
    private AMXPreviewBrowser m_webViewBrowser;
    private boolean m_editorShown = false;
    private PreviewPaneToolbar m_toolbar = new PreviewPaneToolbar();
    private boolean m_isAmxInsideFar = false;
    private final JPanel m_mainPanel = new JPanel();
    private static final Logger s_logger = Logger.getLogger(PreviewEditor.class.getName());
    private ADFMobileSkins m_skins;

    public PreviewEditor() {
        this.init(false);
    }

    private void init(boolean testMode) {
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_toolbar.EnableReload(true);
        if (testMode) {
            this.m_webViewBrowser = new AMXPreviewBrowser(testMode);
            return;
        }
        this.m_webViewBrowser = new AMXPreviewBrowser();
        this.m_webViewBrowser.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PreviewEditor.this.m_toolbar.EnableReload(false);
            }
        });
        JXLayer jxLayer = new JXLayer((Component)this.m_webViewBrowser, (LayerUI)new BlockingEventsLayerUI());
        this.m_mainPanel.add((Component)jxLayer, "North");
    }

    public PreviewEditor(boolean testMode) {
        this.init(testMode);
    }

    public void open() {
        this.m_isAmxInsideFar = McAppUtils.isFarFileUrl(this.getCurrentPageUrl());
    }

    public Component getGUI() {
        return this.m_mainPanel;
    }

    public synchronized void update(Object observed, UpdateMessage change) {
        int msg = change.getMessageID();
        if (msg != UpdateMessage.OBJECT_CLOSED && (msg == CodeEditorConstants.UNDO_WRAPPER_MSG || msg == UpdateMessage.STRUCTURE_CHANGED || msg == UpdateMessage.ATTRIBUTE_CHANGED || msg == UpdateMessage.CONTENT_MODIFIED || msg == UpdateMessage.OBJECT_RELOADED)) {
            this.updateAMXToStage();
            this.loadNode();
        }
    }

    public void close() {
        super.close();
        this.m_webViewBrowser.close();
        this.cleanupStage();
        this.m_toolbar.cleanup();
    }

    public Component getFixedTopMargin() {
        return this.m_toolbar.getToolbar();
    }

    public void editorShown() {
        super.editorShown();
        this.adjustScreenResolution();
        this.updateAMXToStage();
        this.loadBootstrap();
        this.m_toolbar.populateContentIds();
        this.m_editorShown = true;
    }

    public void editorHidden() {
        super.editorHidden();
        this.m_editorShown = false;
    }

    public void applyFileIncludes() {
        ArrayList<FileIncludes> fileIncludes = new ArrayList<FileIncludes>();
        URL dtCssUrl = URLFactory.newDirURL((URL)AMXConstants.getAmxStageURL(), (String)"css");
        FileIncludes dtCssInclude = new FileIncludes("StyleSheet", URLFactory.newURL((URL)dtCssUrl, (String)AMX_DT_CSS).toString());
        fileIncludes.add(dtCssInclude);
        this.m_skins = new ADFMobileSkins(this.getContext());
        Stack<String> stylesheets = this.m_skins.getSkinStylesheets(this.m_toolbar.getCurrentModel(), this.m_toolbar.getCurrentPlatform());
        while (!stylesheets.isEmpty()) {
            FileIncludes amxInclude = new FileIncludes("StyleSheet", stylesheets.pop());
            fileIncludes.add(amxInclude);
        }
        fileIncludes.addAll(this.m_toolbar.getCurrentFileIncludes());
        this.cleanupIncludes();
        if (fileIncludes.isEmpty()) {
            if (this.m_editorShown) {
                this.reload();
            }
            return;
        }
        StringBuilder includesString = new StringBuilder();
        for (FileIncludes includes : fileIncludes) {
            if (includesString.length() == 0) {
                includesString.append("[\n");
            } else {
                includesString.append(",\n");
            }
            String type = includes.getType();
            String fileLocation = includes.getLocation();
            includesString.append("{\"type\":\"");
            includesString.append(type);
            includesString.append("\",");
            includesString.append("\"file\":\"");
            if (this.m_isAmxInsideFar) {
                this.copyFarFileToStage(fileLocation);
                File file = new File(fileLocation);
                fileLocation = "includes/" + file.getName();
            }
            fileLocation = fileLocation + "?timestamp=" + System.currentTimeMillis();
            includesString.append(fileLocation);
            includesString.append("\"}");
        }
        includesString.append("\n]");
        this.addIncludesFile(includesString.toString());
        if (this.m_editorShown) {
            this.reload();
        }
    }

    private void copyFarFileToStage(String filePath) {
        URL destFolder = URLFactory.newURL((URL)this.getEditorStageURL(), (String)INCLUDES_FOLDER);
        if (!URLFileSystem.exists((URL)destFolder)) {
            URLFileSystem.mkdirs((URL)destFolder);
        }
        try {
            FileUtils.copyFile(URLFactory.newURL((String)filePath), destFolder, null);
        }
        catch (IOException e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00084", filePath, e));
        }
    }

    private synchronized void loadBootstrap() {
        try {
            URL amxFolderUrl = URLFileSystem.getParent((URL)this.getCurrentPageUrl());
            String bootStrapWithParams = "bootstrap.html?amx_dtmode=true&file=home.amx&amx_dtfolderpath=" + amxFolderUrl.toExternalForm() + "&" + FEATURE_ROOT_PARAM + this.getId();
            URL loadURL = new URL(AMXConstants.getAmxStageURL(), bootStrapWithParams);
            this.loadPage(loadURL);
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00035", this.getContext().getNode().getShortLabel(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateAMXToStage() {
        Node currentNode = this.getContext().getNode();
        InputStream amxNode = null;
        XmlModel model = null;
        if (currentNode instanceof AMXSourceNode) {
            AMXSourceNode cfr_ignored_0 = (AMXSourceNode)currentNode;
            model = AMXSourceNode.getXmlContext((Context)this.getContext()).getModel();
            model.acquireReadLock();
        }
        amxNode = currentNode.getInputStream();
        URL outputFile = URLFactory.newURL((URL)this.getEditorStageURL(), (String)DEFAULT_AMX_FILE);
        URLFileSystem.copy((InputStream)amxNode, (URL)outputFile);
        try {
            if (amxNode == null) return;
            amxNode.close();
            return;
        }
        catch (Exception e) {
            s_logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10014", e));
            return;
        }
        finally {
            if (model != null) {
                model.releaseReadLock();
            }
        }
        catch (Exception e) {
            try {
                s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00036", this.getContext().getNode().getShortLabel(), e));
            }
            catch (Throwable throwable) {
                try {
                    if (amxNode == null) throw throwable;
                    amxNode.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    s_logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10014", e2));
                    throw throwable;
                }
                finally {
                    if (model != null) {
                        model.releaseReadLock();
                    }
                }
            }
            try {
                if (amxNode == null) return;
                amxNode.close();
                return;
            }
            catch (Exception e3) {
                s_logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10014", e3));
                return;
            }
            finally {
                if (model != null) {
                    model.releaseReadLock();
                }
            }
        }
    }

    private void loadNode() {
        if (this.m_editorShown) {
            this.reload();
        }
    }

    private final void loadPage(URL url) {
        this.m_webViewBrowser.load(url.toExternalForm());
        this.setLoadHandler();
    }

    private void setLoadHandler() {
        ChangeListener<Worker.State> stateChgListener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State oldS, Worker.State newS) {
                final boolean isDone = Worker.State.SUCCEEDED.equals((Object)newS) || Worker.State.FAILED.equals((Object)newS) || Worker.State.CANCELLED.equals((Object)newS);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreviewEditor.this.m_toolbar.EnableReload(isDone);
                        double scaleFactor = PreviewEditor.this.m_toolbar.getSelectedScaleFactor();
                        PreviewEditor.this.m_webViewBrowser.zoom(scaleFactor *= PreviewEditor.this.m_toolbar.getDefaultScaleFactor());
                    }
                });
            }
        };
        AMXPreviewBrowser.executeASync(new Runnable((ChangeListener)stateChgListener){
            final /* synthetic */ ChangeListener val$stateChgListener;
            {
                this.val$stateChgListener = changeListener;
            }

            @Override
            public void run() {
                WebEngine webEngine = PreviewEditor.this.m_webViewBrowser.getWebEngine();
                if (webEngine == null) {
                    PreviewEditor.this.m_toolbar.EnableReload(true);
                    return;
                }
                Worker loadWorker = webEngine.getLoadWorker();
                ReadOnlyObjectProperty stateProp = loadWorker.stateProperty();
                stateProp.addListener(this.val$stateChgListener);
            }
        });
    }

    private void reload() {
        if (this.isReady()) {
            this.m_toolbar.EnableReload(false);
            this.m_webViewBrowser.reload();
        }
    }

    private void setWebViewResolution(Dimension dimension) {
        if (this.m_webViewBrowser != null) {
            this.m_webViewBrowser.setPreferredSize(dimension);
            this.m_webViewBrowser.setSize(dimension);
            this.m_webViewBrowser.revalidate();
        }
    }

    private void adjustScreenResolution() {
        int selectedWidth = this.m_toolbar.getSelectedFormFactorWidth();
        int selectedHeight = this.m_toolbar.getSelectedFormFactorHeight();
        double defaultScaleFactor = this.m_toolbar.getDefaultScaleFactor();
        selectedWidth = (int)((double)selectedWidth / defaultScaleFactor);
        selectedHeight = (int)((double)selectedHeight / defaultScaleFactor);
        String orientation = this.m_toolbar.getCurrentOrientation();
        if (FormFactorsConstants.Orientation.PORTRAIT.getOrientation().equals(orientation) && selectedWidth > selectedHeight || FormFactorsConstants.Orientation.LANDSCAPE.getOrientation().equals(orientation) && selectedHeight > selectedWidth) {
            int temp = selectedHeight;
            selectedHeight = selectedWidth;
            selectedWidth = temp;
        }
        double currentScale = this.m_toolbar.getSelectedScaleFactor();
        this.m_webViewBrowser.setContentDimension(selectedWidth, selectedHeight);
        this.setWebViewResolution(new Dimension((int)((double)selectedWidth * (currentScale *= defaultScaleFactor)), (int)((double)selectedHeight * currentScale)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIncludesFile(String includeString) {
        URL outputFile = URLFactory.newURL((URL)this.getEditorStageURL(), (String)INCLUDES_FILE);
        ByteArrayInputStream is = new ByteArrayInputStream(includeString.getBytes());
        try {
            URLFileSystem.copy((InputStream)is, (URL)outputFile);
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00063", INCLUDES_FILE, e));
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void cleanupIncludes() {
        try {
            URL includeFileURL = URLFactory.newFileURL((String)(this.getEditorStageURL().getPath() + INCLUDES_FILE));
            if (URLFileSystem.exists((URL)includeFileURL)) {
                URLFileSystem.deleteEx((URL)includeFileURL);
            }
        }
        catch (IOException e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00065", e));
        }
    }

    private URL getEditorStageURL() {
        URL dirURL = URLFactory.newDirURL((URL)AMXConstants.getAmxStageURL(), (String)this.getId());
        return URLFactory.newDirURL((URL)dirURL, (String)"public_html");
    }

    private void cleanupStage() {
        try {
            FileUtils.deleteDirectory(URLFactory.newDirURL((URL)AMXConstants.getAmxStageURL(), (String)this.getId()));
        }
        catch (IOException e) {
            s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00067", e));
        }
    }

    private URL getCurrentPageUrl() {
        return this.getContext().getNode().getURL();
    }

    private static class BlockingEventsLayerUI
    extends AbstractLayerUI<AMXPreviewBrowser> {
        public void installUI(JComponent component) {
            super.installUI(component);
            JXLayer jxlayer = (JXLayer)component;
            jxlayer.setLayerEventMask(56L);
        }

        public void uninstallUI(JComponent component) {
            JXLayer jxlayer = (JXLayer)component;
            jxlayer.setLayerEventMask(0L);
            super.uninstallUI(component);
        }

        public void eventDispatched(AWTEvent e, JXLayer<? extends AMXPreviewBrowser> layer) {
            if (e instanceof InputEvent) {
                if (e instanceof MouseEvent && !this._isContentArea((MouseEvent)e, layer)) {
                    super.eventDispatched(e, layer);
                } else {
                    ((InputEvent)e).consume();
                }
                return;
            }
            super.eventDispatched(e, layer);
        }

        private boolean _isContentArea(MouseEvent e, JXLayer<? extends AMXPreviewBrowser> layer) {
            Point mousePoint;
            int scrollSize;
            AMXPreviewBrowser browser;
            Rectangle browserRect;
            Object source = e.getSource();
            return source instanceof Component && (browserRect = new Rectangle(browser.getPreferredSize().width - (scrollSize = this._getScrollSize(browser = (AMXPreviewBrowser)layer.getView())), browser.getPreferredSize().height - scrollSize)).contains(mousePoint = SwingUtilities.convertPoint((Component)source, e.getPoint(), browser));
        }

        private int _getScrollSize(AMXPreviewBrowser browser) {
            double _DEFAULT_SCROLL_SIZE = new Scrollbar().getVisibleAmount();
            double scaleFactor = browser.getScale();
            return (int)(_DEFAULT_SCROLL_SIZE * scaleFactor);
        }
    }

    private class PreviewPaneToolbar {
        private static final String PORTRAIT_ICON = "icons/Portrait.png";
        private static final String LANDSCAPE_ICON = "icons/Landscape.png";
        private static final int DEFAULT_HOR_SPACE = 3;
        private static final int SCALE_100_PERCENT_INDEX = 3;
        private final List<String> SCALE_VALUES = Arrays.asList("200%", "150%", "125%", "100%", "75%", "50%", "25%");
        private final JButton m_reload = this.createButton(HtmlArb.getIcon((int)22), HtmlArb.getString((int)21));
        private final JButton m_stop = this.createButton(HtmlArb.getIcon((int)25), HtmlArb.getString((int)24));
        private final JToolBar m_toolbar = new JToolBar();
        private JComboBox m_formFactorCombo;
        private JComboBox m_scaleCombo;
        private JComboBox m_contentIds;
        private AMXIncludes m_amxIncludes = new AMXIncludes();
        private ActionListener m_contentActionListner = new ContentActionListener();
        private StructureChangeListener m_prefChangeListener;
        private FormFactorsPrefs m_formFactorPrefs;
        private ButtonBar m_orientationBar = new ButtonBar();

        public PreviewPaneToolbar() {
            this.m_formFactorPrefs = FormFactorsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            this.createToolbar();
        }

        public Component getToolbar() {
            return this.m_toolbar;
        }

        public int getSelectedFormFactorWidth() {
            return this.parseFormFactorPropety("Resolution Width");
        }

        public int getSelectedFormFactorHeight() {
            return this.parseFormFactorPropety("Resolution Height");
        }

        public String getCurrentOrientation() {
            for (Component comp : this.m_orientationBar.getComponents()) {
                JToggleButton toggleButton;
                if (!(comp instanceof JToggleButton) || !(toggleButton = (JToggleButton)comp).isSelected()) continue;
                return toggleButton.getActionCommand();
            }
            return "";
        }

        public double getSelectedScaleFactor() {
            String item = (String)this.m_scaleCombo.getSelectedItem();
            if (item.endsWith("%")) {
                String factorString = item.substring(0, item.length() - 1);
                try {
                    double scaleFactor = Double.parseDouble(factorString);
                    return scaleFactor /= 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 1.0;
        }

        public double getDefaultScaleFactor() {
            FormFactor factor = (FormFactor)this.m_formFactorCombo.getItemAt(this.m_formFactorCombo.getSelectedIndex());
            String scaleFactorString = factor.getProperty("Scale Factor");
            try {
                return Double.parseDouble(scaleFactorString);
            }
            catch (NumberFormatException numberFormatException) {
                return 1.0;
            }
        }

        public String getCurrentModel() {
            if (this.m_formFactorCombo == null) {
                return "";
            }
            FormFactor factor = (FormFactor)this.m_formFactorCombo.getItemAt(this.m_formFactorCombo.getSelectedIndex());
            return factor.getProperty("Model");
        }

        public String getCurrentPlatform() {
            if (this.m_formFactorCombo == null) {
                return "";
            }
            FormFactor factor = (FormFactor)this.m_formFactorCombo.getItemAt(this.m_formFactorCombo.getSelectedIndex());
            return factor.getProperty("Platform");
        }

        public Collection<FileIncludes> getCurrentFileIncludes() {
            String item = (String)this.m_contentIds.getSelectedItem();
            return this.m_amxIncludes.getFileIncludes(item);
        }

        public void EnableReload(boolean reloadEnabled) {
            this.m_reload.setEnabled(reloadEnabled);
            this.m_stop.setEnabled(!reloadEnabled);
        }

        public void populateContentIds() {
            Object currentlySelectedItem = this.m_contentIds.getSelectedItem();
            this.m_contentIds.removeActionListener(this.m_contentActionListner);
            this.m_contentIds.removeAllItems();
            String defaultItem = "<" + MobileResourceUtils.getText("NO_FEATURE_CONTENT_SELECTED") + ">";
            this.m_contentIds.addItem(defaultItem);
            for (String key : this.m_amxIncludes.getAmxContentIds()) {
                this.m_contentIds.addItem(key);
            }
            this.m_contentIds.setMaximumSize(this.m_contentIds.getPreferredSize());
            this.m_contentIds.addActionListener(this.m_contentActionListner);
            if (currentlySelectedItem != null) {
                this.m_contentIds.setSelectedItem(currentlySelectedItem);
            } else {
                this.m_contentIds.setSelectedIndex(0);
            }
        }

        public void cleanup() {
            this.m_formFactorPrefs.removeStructureChangeListener(this.m_prefChangeListener);
        }

        private int parseFormFactorPropety(String property) {
            FormFactor factor = (FormFactor)this.m_formFactorCombo.getItemAt(this.m_formFactorCombo.getSelectedIndex());
            String number = factor.getProperty(property);
            int value = 0;
            try {
                value = Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            return value;
        }

        private void createToolbar() {
            this.m_toolbar.setMargin(new Insets(0, 0, 0, 0));
            this.m_toolbar.setFloatable(false);
            this.m_toolbar.setRollover(true);
            this.m_toolbar.add(this.m_reload);
            this.m_toolbar.add(this.m_stop);
            this.m_reload.setFocusable(true);
            this.m_stop.setFocusable(true);
            this.m_toolbar.addSeparator();
            this.createFormFactorCombo();
            this.m_toolbar.add(Box.createHorizontalStrut(3));
            this.m_toolbar.add(this.m_formFactorCombo);
            this.createScaleCombo();
            this.m_toolbar.add(Box.createHorizontalStrut(3));
            this.m_toolbar.add(this.m_scaleCombo);
            this.createOrientationButtons();
            this.m_toolbar.add(Box.createHorizontalStrut(3));
            this.m_toolbar.add((Component)this.m_orientationBar);
            this.m_contentIds = new JComboBox();
            this.m_contentIds.setToolTipText(MobileResourceUtils.getText("PREVIEW_FEATURE_CONTENT_TOOLTIP"));
            this.m_toolbar.add(Box.createHorizontalStrut(3));
            this.m_toolbar.addSeparator();
            this.m_toolbar.add(Box.createHorizontalStrut(3));
            this.m_toolbar.add(this.m_contentIds);
        }

        private void createScaleCombo() {
            this.m_scaleCombo = new JComboBox();
            this.m_scaleCombo.setToolTipText(MobileResourceUtils.getText("PREVIEW_SCALE_TOOLTIP"));
            for (String value : this.SCALE_VALUES) {
                this.m_scaleCombo.addItem(value);
            }
            this.m_scaleCombo.setSelectedIndex(3);
            this.m_scaleCombo.setMaximumSize(this.m_scaleCombo.getPreferredSize());
            this.m_scaleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewEditor.this.adjustScreenResolution();
                }
            });
        }

        private void createOrientationButtons() {
            JToggleButton portraitButton = new JToggleButton(this.getIcon(PORTRAIT_ICON));
            portraitButton.setToolTipText(MobileResourceUtils.getText("PREVIEW_PORTRAIT_TOOLTIP"));
            portraitButton.setActionCommand(FormFactorsConstants.Orientation.PORTRAIT.getOrientation());
            JToggleButton landscapeButton = new JToggleButton(this.getIcon(LANDSCAPE_ICON));
            landscapeButton.setToolTipText(MobileResourceUtils.getText("PREVIEW_LANDSCAPE_TOOLTIP"));
            landscapeButton.setActionCommand(FormFactorsConstants.Orientation.LANDSCAPE.getOrientation());
            IconicButtonUI.install((AbstractButton)portraitButton);
            IconicButtonUI.install((AbstractButton)landscapeButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(portraitButton);
            buttonGroup.add(landscapeButton);
            this.m_orientationBar = new ButtonBar();
            this.m_orientationBar.add((Component)portraitButton);
            this.m_orientationBar.add((Component)landscapeButton);
            this.m_orientationBar.setMaximumSize(this.m_orientationBar.getPreferredSize());
            this.setDefaultOrientation();
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int state = itemEvent.getStateChange();
                    if (state == 1) {
                        PreviewEditor.this.adjustScreenResolution();
                    }
                }
            };
            portraitButton.addItemListener(itemListener);
            landscapeButton.addItemListener(itemListener);
        }

        private void createFormFactorCombo() {
            this.m_formFactorCombo = new JComboBox();
            this.m_formFactorCombo.setToolTipText(MobileResourceUtils.getText("PREVIEW_FORM_FACTOR_TOOLTIP"));
            this.loadFormFactors();
            this.m_prefChangeListener = new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    PreviewPaneToolbar.this.m_formFactorCombo.removeAllItems();
                    PreviewPaneToolbar.this.loadFormFactors();
                }
            };
            this.m_formFactorPrefs.addStructureChangeListener(this.m_prefChangeListener);
            this.m_formFactorCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!(e.getSource() instanceof JComboBox)) {
                        return;
                    }
                    JComboBox combo = (JComboBox)e.getSource();
                    if (combo.getSelectedIndex() >= 0) {
                        PreviewEditor.this.adjustScreenResolution();
                        PreviewPaneToolbar.this.setDefaultOrientation();
                        PreviewEditor.this.applyFileIncludes();
                    }
                }
            });
        }

        private void loadFormFactors() {
            this.m_formFactorCombo.setSelectedIndex(-1);
            FormFactors formFactors = this.m_formFactorPrefs.loadFormFactors();
            Collection<FormFactor> formFactorList = null;
            if (formFactors == null) {
                PreviewPaneToolbar previewPaneToolbar = this;
                formFactorList = previewPaneToolbar.m_formFactorPrefs.getDefaultFormFactors();
            } else {
                formFactorList = formFactors.getAll();
            }
            if (formFactorList.isEmpty()) {
                this.m_formFactorCombo.addItem(FormFactor.createDefaultFormFactor());
            } else {
                for (FormFactor formFactor : formFactorList) {
                    this.m_formFactorCombo.addItem(formFactor);
                    if (!formFactor.isDefault()) continue;
                    this.m_formFactorCombo.setSelectedItem(formFactor);
                }
            }
            if (this.m_formFactorCombo.getSelectedIndex() == -1) {
                this.m_formFactorCombo.setSelectedIndex(0);
            }
            this.m_formFactorCombo.setMaximumSize(this.m_formFactorCombo.getPreferredSize());
        }

        private void setDefaultOrientation() {
            FormFactor formFactor = (FormFactor)this.m_formFactorCombo.getItemAt(this.m_formFactorCombo.getSelectedIndex());
            String orientation = formFactor.getProperty("Default Orientation");
            for (Component comp : this.m_orientationBar.getComponents()) {
                JToggleButton toggleButton;
                if (!(comp instanceof JToggleButton) || !orientation.equals((toggleButton = (JToggleButton)comp).getActionCommand())) continue;
                toggleButton.setSelected(true);
                break;
            }
        }

        private Icon getIcon(String iconName) {
            return new ImageIcon(GraphicsUtils.loadFromResource((String)iconName, this.getClass()));
        }

        private final JButton createButton(Icon icon, String tooltip) {
            JButton button = new JButton(icon);
            button.setToolTipText(tooltip);
            button.setEnabled(false);
            button.setFocusable(false);
            button.setFocusPainted(false);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Object src = ev.getSource();
                    if (src == PreviewPaneToolbar.this.m_reload) {
                        PreviewEditor.this.reload();
                    } else if (src == PreviewPaneToolbar.this.m_stop) {
                        PreviewPaneToolbar.this.EnableReload(true);
                        PreviewEditor.this.m_webViewBrowser.stop();
                    }
                }
            });
            return button;
        }

        private class ContentActionListener
        implements ActionListener {
            private ContentActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewEditor.this.applyFileIncludes();
            }
        }
    }

    private class AMXIncludes {
        private final Map<String, List<FileIncludes>> m_includesMap = new LinkedHashMap<String, List<FileIncludes>>();

        public Collection<String> getAmxContentIds() {
            this.m_includesMap.clear();
            this.parseFeatures();
            return Collections.unmodifiableCollection(this.m_includesMap.keySet());
        }

        public Collection<FileIncludes> getFileIncludes(String contentId) {
            if (!this.m_includesMap.containsKey(contentId)) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection((Collection)this.m_includesMap.get(contentId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseFeatures() {
            URL featureXmlUrl = this.getFeatureXmlUrl();
            if (featureXmlUrl == null) {
                s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00085", PreviewEditor.this.getCurrentPageUrl().getFile()));
                return;
            }
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)PreviewEditor.this.getContext());
            XmlModel model = xmlContext.getRelatedXmlModel(featureXmlUrl);
            if (model != null) {
                model.acquireReadLock();
                try {
                    Element rootElement = model.getDocument().getDocumentElement();
                    List<Element> featureElements = this.getChildElements(rootElement, "feature");
                    for (Element feature : featureElements) {
                        List<Element> contentElements = this.getChildElements(feature, "content");
                        for (Element content : contentElements) {
                            List<Element> amxElements = this.getChildElements(content, "amx");
                            for (Element amx : amxElements) {
                                String featureName = feature.getAttributeNS(null, "name");
                                String contentId = content.getAttributeNS(null, "id");
                                ArrayList<FileIncludes> includesList = new ArrayList<FileIncludes>();
                                org.w3c.dom.Node includesElement = DomUtils.getNamedChild((org.w3c.dom.Node)amx, (String)"http://xmlns.oracle.com/adf/mf", (String)PreviewEditor.INCLUDES_FOLDER);
                                if (includesElement != null) {
                                    List<Element> includeElements = this.getChildElements((Element)includesElement, "include");
                                    for (Element include : includeElements) {
                                        String type = include.getAttributeNS(null, "type");
                                        String file = include.getAttributeNS(null, "file");
                                        URL publicHtmlDir = null;
                                        publicHtmlDir = PreviewEditor.this.m_isAmxInsideFar ? McAppUtils.getFarPublicHtmlDir(PreviewEditor.this.getCurrentPageUrl()) : McAppUtils.getProjectPublicHtmlDir(PreviewEditor.this.getContext().getProject());
                                        if (publicHtmlDir != null) {
                                            FileIncludes amxInclude = new FileIncludes(type, URLFactory.newURL((URL)publicHtmlDir, (String)file).toString());
                                            includesList.add(amxInclude);
                                            continue;
                                        }
                                        s_logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00086", PreviewEditor.this.getCurrentPageUrl().getFile()));
                                    }
                                }
                                this.m_includesMap.put(featureName + "#" + contentId, includesList);
                            }
                        }
                    }
                }
                finally {
                    model.releaseReadLock();
                }
            }
        }

        private URL getFeatureXmlUrl() {
            if (PreviewEditor.this.m_isAmxInsideFar) {
                URL farUrl = McAppUtils.getFarUrl(PreviewEditor.this.getCurrentPageUrl());
                if (farUrl != null) {
                    return URLFactory.newJarURL((URL)farUrl, (String)ADFMobileConstants.FEATURE_XML_FAR_PATH);
                }
            } else {
                return McAppUtils.getProjectFeatureXmlUrl(PreviewEditor.this.getContext().getProject());
            }
            return null;
        }

        private List<Element> getChildElements(Element parent, String elementName) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            NodeList nodeList = parent.getElementsByTagNameNS("*", elementName);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                elementList.add((Element)nodeList.item(i));
            }
            return Collections.unmodifiableList(elementList);
        }
    }

    private static class FileIncludes {
        private final String m_type;
        private final String m_location;

        public FileIncludes(String type, String location) {
            this.m_type = type;
            this.m_location = location;
        }

        public String getType() {
            return this.m_type;
        }

        public String getLocation() {
            return this.m_location;
        }
    }
}

