/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import oracle.adfmf.amx.dt.editor.AMXConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.webupdate.PostStartupHook;

public final class AmxStageUpdatePostStartupHook
implements PostStartupHook {
    private static final Logger _LOGGER = Logger.getLogger(AmxStageUpdatePostStartupHook.class.getName());

    public void install() {
        URL amxStageURL = AMXConstants.getAmxStageURL();
        if (URLFileSystem.exists((URL)amxStageURL)) {
            try {
                JarFile mobileJarFile = this._getMobileExtensionJarFile();
                this._updateAmxStage(mobileJarFile);
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-02501", e));
            }
        }
    }

    private JarFile _getMobileExtensionJarFile() throws MalformedURLException, IOException {
        File file;
        Extension mobileExtension = ExtensionRegistry.getExtensionRegistry().findExtension("oracle.adf.mobile");
        if (mobileExtension != null && (file = ExtensionRegistry.getExtensionRegistry().getExtensionJAR(mobileExtension)) != null) {
            return new JarFile(file);
        }
        return null;
    }

    private void _updateAmxStage(JarFile jarFile) throws IOException {
        List<JarEntry> stageEntries;
        if (jarFile != null && !(stageEntries = this._getAmxStageEntries(jarFile)).isEmpty()) {
            FileUtils.deleteDirectory(AMXConstants.getAmxStageURL());
            this._copyStageEntriesfromJar(jarFile, stageEntries);
        }
    }

    private List<JarEntry> _getAmxStageEntries(JarFile jarFile) {
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        ArrayList<JarEntry> stageEntries = new ArrayList<JarEntry>();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (!jarEntry.getName().startsWith("amx-stage/")) continue;
            stageEntries.add(jarEntry);
        }
        return stageEntries;
    }

    private void _copyStageEntriesfromJar(JarFile jarFile, List<JarEntry> stageEntries) throws IOException {
        for (JarEntry stageEntry : stageEntries) {
            FileUtils.copyFromZip(jarFile, stageEntry, URLFactory.newURL((URL)AMXConstants.ADFMOBILE_SYSTEM_DIR, (String)stageEntry.getName()));
        }
    }
}

