/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.dt.editor.AmxAddIdModelAdapter;
import oracle.adfmf.amx.dt.inspector.FacetNameAttributeValueProvider;
import oracle.adfmf.amx.dt.inspector.methodbinding.AMXMethodsBindingProvider;
import oracle.adfmf.common.resourcebundle.ADFMobileResourceBundleContextualActionProvider;
import oracle.adfmf.common.util.XmlUtils;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataEvaluator;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.jdeveloper.el.inspector.BindToDataContextualActionProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AMXXmlModel
extends XmlModel {
    private static final Map<String, String> _DEFAULT_CHILD_ELEMENTS;

    public AMXXmlModel() {
    }

    public AMXXmlModel(MetadataProvider provider) {
        super(provider);
    }

    protected void postAttachmentHook() {
        super.postAttachmentHook();
        this.getContext().registerGlobalContextualActionProvider((ContextualActionProvider)new BindToDataContextualActionProvider());
        this.getContext().registerGlobalContextualActionProvider((ContextualActionProvider)new AMXMethodsBindingProvider());
        this.getContext().registerGlobalContextualActionProvider((ContextualActionProvider)new ADFMobileResourceBundleContextualActionProvider());
    }

    protected void postCreationHook() {
        super.postCreationHook();
        this.addModelListener((XmlModelListener)new AmxAddIdModelAdapter());
        XmlUtils.setDefaultSelection((AbstractModel)this);
    }

    protected final XmlMetadataResolver createMetadataResolver(MetadataProvider provider) {
        XmlMetadataEvaluator evaluator = new XmlMetadataEvaluator(provider, this.getContext().getGrammarProvider(), this.getContext().getGrammarResolver(), (AbstractModel)this);
        return new AMXMetadataResolver((MetadataEvaluator)evaluator, (AbstractModel)this);
    }

    protected boolean initializeNewNodeHook(Node node, XmlKey key, boolean wasOk) {
        boolean rtn = super.initializeNewNodeHook(node, key, wasOk);
        this._addPreferredFacets(node);
        this._addDefaultChildElement(node);
        return rtn;
    }

    private void _addPreferredFacets(Node node) {
        List<String> facetNames;
        AMXMetadataResolver resolver = (AMXMetadataResolver)this.getXmlMetadataResolver();
        if (resolver.isUIComponent(node) && !(facetNames = FacetNameAttributeValueProvider.getPreferredFacets(node)).isEmpty()) {
            Iterator<String> iterator = facetNames.iterator();
            Document doc = this.getDocument();
            while (iterator.hasNext()) {
                Element elem = doc.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "facet");
                elem.setAttributeNS(null, "name", iterator.next());
                node.appendChild(elem);
            }
        }
    }

    private void _addDefaultChildElement(Node node) {
        if (node != null && DomUtils.isElement((Node)node) && "http://xmlns.oracle.com/adf/mf/amx".equals(node.getNamespaceURI()) && _DEFAULT_CHILD_ELEMENTS.containsKey(node.getNodeName())) {
            Document doc = this.getDocument();
            Element elem = doc.createElementNS("http://xmlns.oracle.com/adf/mf/amx", _DEFAULT_CHILD_ELEMENTS.get(node.getNodeName()));
            node.appendChild(elem);
        }
    }

    static {
        HashMap<String, String> defaultChildElements = new HashMap<String, String>();
        defaultChildElements.put("selectManyCheckbox", "selectItem");
        defaultChildElements.put("selectManyChoice", "selectItem");
        defaultChildElements.put("selectOneButton", "selectItem");
        defaultChildElements.put("selectOneChoice", "selectItem");
        defaultChildElements.put("selectOneRadio", "selectItem");
        defaultChildElements.put("panelSplitter", "panelItem");
        _DEFAULT_CHILD_ELEMENTS = Collections.unmodifiableMap(defaultChildElements);
    }
}

