/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.feedback.FeedbackManager;

public class AMXPreviewBrowser
extends JPanel {
    private WebView _webView;
    private JFXPanel _jfxPanel;
    private WebEngine _webEngine;
    private Group _root;
    private int _webViewWidth = 0;
    private int _webViewHeight = 0;
    private double _scale = 1.0;
    private static Boolean _sIsSupportedPlatformCache = null;
    private static final Logger _logger = Logger.getLogger(AMXPreviewBrowser.class.getName());
    private static final String _OS = "osgi.os";
    private static final String _ARCHITECTURE = "osgi.arch";
    private static final String _WINDOWS = "win";
    private static final String _X86 = "x86";
    private static final String _X86_64_BIT = "x86_64";
    private static final String _LINUX = "linux";
    private static final String _WEBVIEW_PROPERTY_LINUX = "use.webview.on.linux";
    private static final String _MAC = "mac";

    public AMXPreviewBrowser() {
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        this._initComponents();
    }

    public AMXPreviewBrowser(boolean testMode) {
    }

    public void load(final String url) {
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        AMXPreviewBrowser.executeASync(new Runnable(){

            @Override
            public void run() {
                AMXPreviewBrowser.this._webEngine.getLoadWorker().cancel();
                AMXPreviewBrowser.this._webEngine.load(url);
            }
        });
    }

    public void stop() {
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        AMXPreviewBrowser.executeASync(new Runnable(){

            @Override
            public void run() {
                Worker worker = AMXPreviewBrowser.this._webEngine.getLoadWorker();
                if (worker != null) {
                    worker.cancel();
                }
            }
        });
    }

    public void reload() {
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        AMXPreviewBrowser.executeASync(new Runnable(){

            @Override
            public void run() {
                Worker worker = AMXPreviewBrowser.this._webEngine.getLoadWorker();
                if (worker != null) {
                    worker.cancel();
                }
                AMXPreviewBrowser.this._webEngine.reload();
            }
        });
    }

    public WebEngine getWebEngine() {
        return this._webEngine;
    }

    public void close() {
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        this.stop();
    }

    public void zoom(final double scale) {
        this.setScale(scale);
        if (!AMXPreviewBrowser._isSupportedPlatform()) {
            return;
        }
        AMXPreviewBrowser.executeASync(new Runnable(){

            @Override
            public void run() {
                AMXPreviewBrowser.this._root.setRotate(0.0);
                AMXPreviewBrowser.this._root.setEffect(null);
                AMXPreviewBrowser.this._jfxPanel.getScene().setFill(null);
                AMXPreviewBrowser.this._root.setScaleX(scale);
                AMXPreviewBrowser.this._root.setScaleY(scale);
                Bounds bound1 = AMXPreviewBrowser.this._root.getBoundsInLocal();
                Bounds bound2 = AMXPreviewBrowser.this._root.getBoundsInParent();
                AMXPreviewBrowser.this._root.setTranslateX((bound2.getWidth() - bound1.getWidth()) / 2.0);
                AMXPreviewBrowser.this._root.setTranslateY((bound2.getHeight() - bound1.getHeight()) / 2.0);
            }
        });
    }

    public void setContentDimension(int width, int height) {
        this._webViewWidth = width;
        this._webViewHeight = height;
    }

    public static void executeASync(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public double getScale() {
        return this._scale;
    }

    public void setScale(double sf) {
        this._scale = sf;
    }

    private static boolean _isSupportedPlatform() {
        if (_sIsSupportedPlatformCache == null) {
            _sIsSupportedPlatformCache = false;
            String name = System.getProperty(_OS);
            String arch = System.getProperty(_ARCHITECTURE);
            if (name == null || arch == null) {
                _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00073"));
                return _sIsSupportedPlatformCache;
            }
            if (name.contains(_WINDOWS)) {
                if (_X86.equals(arch) || _X86_64_BIT.equals(arch)) {
                    _sIsSupportedPlatformCache = true;
                } else {
                    _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00074", arch, name));
                }
            } else if (name.contains(_LINUX)) {
                if (_X86.equals(arch)) {
                    _sIsSupportedPlatformCache = !"false".equalsIgnoreCase(System.getProperty(_WEBVIEW_PROPERTY_LINUX));
                    if (!_sIsSupportedPlatformCache.booleanValue()) {
                        _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00076"));
                    }
                } else {
                    _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00074", arch, name));
                }
            } else if (name.contains(_MAC)) {
                if (_X86.equals(arch) || _X86_64_BIT.equals(arch)) {
                    _sIsSupportedPlatformCache = true;
                } else {
                    _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00074", arch, name));
                }
            } else {
                _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00075", name, arch));
            }
            _sIsSupportedPlatformCache = _sIsSupportedPlatformCache != false && AMXPreviewBrowser._canCreateJFXPanel();
        }
        return _sIsSupportedPlatformCache;
    }

    private void _createScene() {
        AMXPreviewBrowser.executeASync(new Runnable(){

            @Override
            public void run() {
                AMXPreviewBrowser.this._root = new Group();
                Scene scene = new Scene((Parent)AMXPreviewBrowser.this._root);
                AMXPreviewBrowser.this._webView = new WebView();
                AMXPreviewBrowser.this._webEngine = AMXPreviewBrowser.this._webView.getEngine();
                AMXPreviewBrowser.this._webView.setPrefSize((double)AMXPreviewBrowser.this._jfxPanel.getWidth(), (double)AMXPreviewBrowser.this._jfxPanel.getHeight());
                ObservableList children = AMXPreviewBrowser.this._root.getChildren();
                children.add((Object)AMXPreviewBrowser.this._webView);
                AMXPreviewBrowser.this._jfxPanel.setScene(scene);
            }
        });
    }

    private void _initComponents() {
        this._jfxPanel = new JFXPanel();
        this._createScene();
        this._jfxPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AMXPreviewBrowser.executeASync(new Runnable(){

                    @Override
                    public void run() {
                        if (AMXPreviewBrowser.this._webViewWidth > 0) {
                            AMXPreviewBrowser.this._webView.setPrefSize((double)AMXPreviewBrowser.this._webViewWidth, (double)AMXPreviewBrowser.this._webViewHeight);
                        } else {
                            AMXPreviewBrowser.this._webView.setPrefSize((double)AMXPreviewBrowser.this._jfxPanel.getWidth(), (double)AMXPreviewBrowser.this._jfxPanel.getHeight());
                        }
                        AMXPreviewBrowser.this._webView.requestLayout();
                        AMXPreviewBrowser.this._webEngine.reload();
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._jfxPanel, "Center");
    }

    private static boolean _canCreateJFXPanel() {
        if (SwingUtilities.isEventDispatchThread()) {
            return AMXPreviewBrowser._tryCreatingJFXPanel();
        }
        Runnable checkLater = new Runnable(){

            @Override
            public void run() {
                if (!AMXPreviewBrowser._tryCreatingJFXPanel()) {
                    _sIsSupportedPlatformCache = false;
                }
            }
        };
        SwingUtilities.invokeLater(checkLater);
        return true;
    }

    private static boolean _tryCreatingJFXPanel() {
        try {
            new JFXPanel();
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00077", e));
            FeedbackManager.reportException((Throwable)e);
            return false;
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00078", t));
            FeedbackManager.reportException((Throwable)t);
            return false;
        }
    }
}

