/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.adfmf.amx.dt.editor.el.AMXELDatabindingHandler;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataMethods;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.bali.xml.util.DatabindingHandler;
import oracle.jdeveloper.el.ELType;
import oracle.jdeveloper.webapp.xdf.ELReferenceFactory;
import oracle.jdeveloper.webapp.xdf.MethodBindingReferenceFactory;
import oracle.jdevimpl.webapp.faces.backingfile.MethodBinding;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public final class AMXMetadataResolver
extends XmlMetadataResolver {
    private static final String _ACTION = "action";
    private static final String _ACTION_LISTENER = "actionListener";
    private static final String _BINDING = "binding";
    private static final String _VALUE_CHANGE_LISTENER = "valueChangeListener";
    private static final String _MOVE_LISTENER = "moveListener";
    private static final String _SELECTION_LISTENER = "selectionListener";
    private static final String _BINDING_HELP_ID = "f1_sfdbactionlisten_html";
    private static final String _ACTION_HELP_ID = "f1_sfdbaction_html";
    private static final String _ACTION_LISTENER_HELP_ID = "f1_adfmf_dbactionlisten_html";
    private static final String _VALUE_CHANGE_LISTENER_HELP_ID = "f1_adfmf_dbvaluechangelisten_html";
    private static final String _MOVE_LISTENER_HELP_ID = "f1_adfmf_dbmovelisten_html";
    private static final String _COMPS_TO_APPEAR_ONCE = "componentsThatShouldAppearOnlyOnce";
    private static final String _DVT_UI_COMPONENTS = "dvtUiComponents";
    private static final String _NON_UI_COMPONENTS = "nonUIComponents";
    private static final String _SCOPED_ID_HOLDER_ATTRIBUTES = "scopedIdHolderAttributes";
    private List<String> _dvtUiComponentsList;
    private List<String> _amxNonUiComponentsList = this._getEnumerationValuesFromXsd("nonUIComponents");
    private List<String> _compsThatShouldAppearOnceList;
    private List<String> _scopedIdHolderAttrsList;

    public AMXMetadataResolver(MetadataEvaluator evaluator, AbstractModel model) {
        super(evaluator, model);
        this._dvtUiComponentsList = this._getEnumerationValuesFromXsd(_DVT_UI_COMPONENTS);
        this._compsThatShouldAppearOnceList = this._getEnumerationValuesFromXsd(_COMPS_TO_APPEAR_ONCE);
        this._scopedIdHolderAttrsList = this._getEnumerationValuesFromXsd(_SCOPED_ID_HOLDER_ATTRIBUTES);
    }

    public final MethodBinding getMethodBinding(XmlKey key) {
        String propertyName = key.getLocalName();
        if (_ACTION_LISTENER.equals(propertyName)) {
            return MethodBindings._ACTION_LISTENER_METHOD_BINDING;
        }
        if (_BINDING.equals(propertyName)) {
            return MethodBindings._BINDING_METHOD_BINDING;
        }
        if (_ACTION.equals(propertyName)) {
            return MethodBindings._ACTION_METHOD_BINDING;
        }
        if (_VALUE_CHANGE_LISTENER.equals(propertyName)) {
            return MethodBindings._VALUE_CHANGE_LISTENER_METHOD_BINDING;
        }
        if (_MOVE_LISTENER.equals(propertyName)) {
            return MethodBindings._MOVE_LISTENER_METHOD_BINDING;
        }
        if (_SELECTION_LISTENER.equals(propertyName)) {
            return MethodBindings._SELECTION_LISTENER_METHOD_BINDING;
        }
        return null;
    }

    public static boolean isActionListenerSupported(Method method) {
        String[] parameters = AMXUtils.getJavaTypesAsStrings(method.getParameterTypes());
        String returnType = method.getReturnType().getName();
        return parameters.length == 1 && "oracle.adfmf.amx.event.ActionEvent".equals(parameters[0]) && "void".equals(returnType);
    }

    public boolean isAction(XmlKey key) {
        return _ACTION.equals(key.getLocalName());
    }

    public boolean isUIComponent(Node node) {
        if ("http://xmlns.oracle.com/adf/mf/amx".equals(node.getNamespaceURI())) {
            return !this._amxNonUiComponentsList.contains(node.getLocalName());
        }
        if ("http://xmlns.oracle.com/adf/mf/amx/dvt".equals(node.getNamespaceURI())) {
            return this._dvtUiComponentsList.contains(node.getLocalName());
        }
        return false;
    }

    public boolean isScopedIdHolder(Attr attr) {
        return this._scopedIdHolderAttrsList.contains(attr.getName());
    }

    public List<String> getComponentsToAppearOnce() {
        return Collections.unmodifiableList(this._compsThatShouldAppearOnceList);
    }

    protected XmlMetadataResolver createResolver(MetadataEvaluator evaluator, AbstractModel model) {
        return new AMXMetadataResolver(evaluator, model);
    }

    protected String getHelpTopicImpl(Node node, XmlKey key) {
        String helpTopic = XmlMetadataMethods.getHelpTopic((MetadataEvaluator)this.getMetadataEvaluator(), (Object)key, (Node)node);
        if (helpTopic == null && key.getNodeType() == 2) {
            String attributeName = key.getLocalName();
            if (_ACTION_LISTENER.equals(attributeName)) {
                return _ACTION_LISTENER_HELP_ID;
            }
            if (_BINDING.equals(attributeName)) {
                return _BINDING_HELP_ID;
            }
            if (_ACTION.equals(attributeName)) {
                return _ACTION_HELP_ID;
            }
            if (_VALUE_CHANGE_LISTENER.equals(attributeName)) {
                return _VALUE_CHANGE_LISTENER_HELP_ID;
            }
            if (_MOVE_LISTENER.equals(attributeName)) {
                return _MOVE_LISTENER_HELP_ID;
            }
        }
        return super.getHelpTopicImpl(node, key);
    }

    protected DatabindingHandler getDatabindingHandlerImpl(Node node, XmlKey key) {
        DatabindingHandler handler = super.getDatabindingHandlerImpl(node, key);
        return handler != null ? handler : new AMXELDatabindingHandler();
    }

    protected ReferenceFactory getReferenceFactoryImpl(Node node, XmlKey key) {
        MethodBinding methodBinding;
        ReferenceFactory superReferenceFactory = super.getReferenceFactoryImpl(node, key);
        if (this.getSupportsDatabinding(key)) {
            DatabindingHandler databindingHandler = this.getDatabindingHandler(key);
            return new ELReferenceFactory(key, ELType.JSF, (XmlMetadataResolver)this, databindingHandler, superReferenceFactory);
        }
        if (key.getNodeType() == 2 && (methodBinding = this.getMethodBinding(key)) != null) {
            return new MethodBindingReferenceFactory(key, (XmlMetadataResolver)this, methodBinding, superReferenceFactory);
        }
        return superReferenceFactory;
    }

    private List<String> _getEnumerationValuesFromGrammar(Grammar grammar, String simpleType) {
        Type enumeration;
        if (grammar != null && (enumeration = grammar.getTypeByName(simpleType)) != null && enumeration instanceof SimpleType) {
            Set enumValues = AttributeValueUtils.getAttributeValues((SimpleType)((SimpleType)enumeration));
            return new ArrayList<String>(enumValues);
        }
        return Collections.emptyList();
    }

    private List<String> _getEnumerationValuesFromXsd(String simpleType) {
        if (this.getModel() != null && this.getContext() != null) {
            Grammar amxGrammar = this.getContext().getGrammarProvider().getGrammarForNamespace("http://xmlns.oracle.com/adf/mf/amx");
            List<String> amxValues = this._getEnumerationValuesFromGrammar(amxGrammar, simpleType);
            Grammar dvtGrammar = this.getContext().getGrammarProvider().getGrammarForNamespace("http://xmlns.oracle.com/adf/mf/amx/dvt");
            List<String> dvtValues = this._getEnumerationValuesFromGrammar(dvtGrammar, simpleType);
            ArrayList<String> allValues = new ArrayList<String>();
            if (!amxValues.isEmpty()) {
                allValues.addAll(amxValues);
            }
            if (!dvtValues.isEmpty()) {
                allValues.addAll(dvtValues);
            }
            if (!allValues.isEmpty()) {
                return Collections.unmodifiableList(allValues);
            }
        }
        return Collections.emptyList();
    }

    private static final class MethodBindings {
        private static final String _AMX_EVENT_CLASSES_PACKAGE = "oracle.adfmf.amx.event.";
        private static final String _VOID_RETURN_TYPE = "void";
        private static final String[][] _EMPTY_PARAMS = new String[0][0];
        private static final String _ACTION_EVENT_CLASS = "oracle.adfmf.amx.event.ActionEvent";
        private static final String _ACTION_EVENT_PARAM = "actionEvent";
        private static final String _VALUE_CHANGE_EVENT_CLASS = "oracle.adfmf.amx.event.ValueChangeEvent";
        private static final String _VALUE_CHANGE_EVENT_PARAM = "valueChangeEvent";
        private static final String _MOVE_EVENT_CLASS = "oracle.adfmf.amx.event.MoveEvent";
        private static final String _MOVE_EVENT_PARAM = "moveEvent";
        private static final String _SELECTION_EVENT_CLASS = "oracle.adfmf.amx.event.SelectionEvent";
        private static final String _SELECTION_EVENT_PARAM = "selectionEvent";
        private static final String[][] _ACTION_LISTENER_PARAMS = new String[][]{{"oracle.adfmf.amx.event.ActionEvent", "actionEvent"}};
        private static final String[][] _VALUE_CHANGE_LISTENER_PARAMS = new String[][]{{"oracle.adfmf.amx.event.ValueChangeEvent", "valueChangeEvent"}};
        private static final String[][] _MOVE_LISTENER_PARAMS = new String[][]{{"oracle.adfmf.amx.event.MoveEvent", "moveEvent"}};
        private static final String[][] _SELECTION_LISTENER_PARAMS = new String[][]{{"oracle.adfmf.amx.event.SelectionEvent", "selectionEvent"}};
        private static final MethodBinding _ACTION_METHOD_BINDING = new AMXMethodBinding("action", _EMPTY_PARAMS, ADFMobileConstants.STRING_TYPE);
        private static final MethodBinding _ACTION_LISTENER_METHOD_BINDING = new AMXMethodBinding("actionListener", _ACTION_LISTENER_PARAMS, "void");
        private static final MethodBinding _BINDING_METHOD_BINDING = new AMXMethodBinding("binding", _ACTION_LISTENER_PARAMS, "void");
        private static final MethodBinding _VALUE_CHANGE_LISTENER_METHOD_BINDING = new AMXMethodBinding("valueChangeListener", _VALUE_CHANGE_LISTENER_PARAMS, "void");
        private static final MethodBinding _MOVE_LISTENER_METHOD_BINDING = new AMXMethodBinding("moveListener", _MOVE_LISTENER_PARAMS, "void");
        private static final MethodBinding _SELECTION_LISTENER_METHOD_BINDING = new AMXMethodBinding("selectionListener", _SELECTION_LISTENER_PARAMS, "void");

        private MethodBindings() {
        }
    }

    private static final class AMXMethodBinding
    implements MethodBinding {
        private String _propertyName;
        private String[][] _params;
        private String _returnType;

        public AMXMethodBinding(String propertyName, String[][] params, String returnType) {
            this._propertyName = propertyName;
            this._params = params;
            this._returnType = returnType;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String[][] getParameters() {
            return this._params;
        }

        public String getReturnType() {
            return this._returnType;
        }
    }
}

