/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.awt.Component;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilderPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class AMXFileBuilderPanel
extends FileBuilderPanel
implements URLChooserInit {
    private URL _baseUrl;
    private final transient Context _context;
    private static final long serialVersionUID = 1L;

    public AMXFileBuilderPanel(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this.jbInit();
    }

    public boolean validateAndWriteToState(BaliWizardState state) {
        FileBuilderModel model = (FileBuilderModel)state;
        try {
            this.resetURLCache();
            URL selectedUrl = this.getFileURL();
            if (this._isInRoot(selectedUrl)) {
                model.setFileName(this.getFileField().getText());
                model.setURL(selectedUrl);
                return true;
            }
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return false;
    }

    public void initURLChooser(URLChooser urlChooser) {
        FileUtils.initializeURLChooser(this._baseUrl, urlChooser);
    }

    protected void jbInit() {
        this._baseUrl = McAppUtils.getProjectPublicHtmlDir(this._context.getProject());
        this.setBrowseButtonLabel("");
        JButton browseButton = this.getBrowseButton();
        browseButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        browseButton.setContentAreaFilled(false);
        IconicButtonUI.install((AbstractButton)browseButton);
        browseButton.setIcon(OracleIcons.getIcon((String)"lov.png"));
        this.setLayoutOrientation(0);
        JTextField directoryField = this.getDirectoryField();
        assert (directoryField instanceof URLTextField);
        ((URLTextField)directoryField).setChooserInit((URLChooserInit)this);
    }

    private boolean _isInRoot(URL selectedUrl) {
        if (selectedUrl == null || !URLFileSystem.isBaseURLFor((URL)this._baseUrl, (URL)selectedUrl)) {
            String errorMsg = MobileResourceUtils.getText("ADF_MOBILE_AMX_FILE_BUILDER_MODEL_NOT_IN_ROOT");
            String alertTitle = MobileResourceUtils.getText("ADF_MOBILE_AMX_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)errorMsg, (String)alertTitle, null);
            return false;
        }
        return true;
    }
}

