/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfdtinternal.controller.mobile.interactions.AdfMobileDTInteractions;
import oracle.adfmf.amx.dt.editor.AMXSourceModel;
import oracle.adfmf.amx.dt.editor.AMXSourceNode;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.wizard.Wizard;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AMXFileBuilderModel
extends FileBuilderModel {
    private static final String _TXN_NAME = "Initialize file contents";
    private static final String _XSI_PREFIX = "xsi";
    private final Logger _logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Context _ideContext = null;
    private XmlModel _model = null;

    public AMXFileBuilderModel(Context ctx) {
        super(ctx, ".amx");
        this._ideContext = ctx;
    }

    public String getFileType() {
        return MobileResourceUtils.getText("ADF_MOBILE_AMX_FILE_TYPE");
    }

    public String getBuilderType() {
        return MobileResourceUtils.getText("ADF_MOBILE_AMX_FILE_TYPE");
    }

    public void saveLegacyParameters() {
        URL fileURL;
        String[] wizardParameters = Wizard.getLegacyParams((Context)this._ideContext);
        if (wizardParameters != null && wizardParameters.length > 0 && (fileURL = this.getURL()) != null) {
            wizardParameters[0] = fileURL.toString();
        }
    }

    protected SourceModel createSourceModel() {
        return new AMXSourceModel(this.getFileExtension());
    }

    protected String getBaseName() {
        return MobileResourceUtils.getText("ADF_MOBILE_AMX_UNTITLED");
    }

    protected void initializeFromContext(Context ctx) {
        super.initializeFromContext(ctx);
        String[] wizardParameters = Wizard.getLegacyParams((Context)ctx);
        try {
            if (wizardParameters != null && wizardParameters.length > 0) {
                URL fileURL = new URL(wizardParameters[0]);
                if (URLFileSystem.isDirectoryPath((URL)fileURL)) {
                    this.setDirectory(fileURL);
                    this.getSourceModel().generateDefaultFileName(this.getBaseName());
                } else {
                    this.setDirectory(URLFileSystem.getParent((URL)fileURL));
                    this.setFileName(URLFileSystem.getFileName((URL)fileURL));
                }
            }
        }
        catch (MalformedURLException e) {
            this._logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10011", wizardParameters[0], e));
        }
    }

    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            this._model = this.getFileXmlModel(node);
            this._model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, "UTF-8", null));
            new FixedNameTransactionTask(_TXN_NAME){

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Document doc = model.getDocument();
                    Element root = doc.createElementNS("http://xmlns.oracle.com/adf/mf/amx", "amx:view");
                    DomUtils.addXmlns((Element)root, (String)AMXFileBuilderModel._XSI_PREFIX, (String)"http://www.w3.org/2001/XMLSchema-instance");
                    DomUtils.addXmlns((Element)root, (String)"amx", (String)"http://xmlns.oracle.com/adf/mf/amx");
                    DomUtils.addXmlns((Element)root, (String)"dvtm", (String)"http://xmlns.oracle.com/adf/mf/amx/dvt");
                    doc.appendChild(root);
                }
            }.run((AbstractModel)this._model);
            AdfMobileDTInteractions.getInstance().pageCreated(this._ideContext.getProject(), node);
            return true;
        }
        return false;
    }

    protected XmlModel getFileXmlModel(Node node) {
        if (this._model != null) {
            return this._model;
        }
        Context newCtxt = new Context(null, this._ideContext.getWorkspace(), this._ideContext.getProject(), node);
        return AMXSourceNode.getXmlContext((Context)newCtxt).getModel();
    }
}

